/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.providers;

import com.ecyrd.jspwiki.FileUtil;
import com.ecyrd.jspwiki.InternalWikiException;
import com.ecyrd.jspwiki.NoRequiredPropertyException;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.providers.AbstractFileProvider;
import com.ecyrd.jspwiki.providers.NoSuchVersionException;
import com.ecyrd.jspwiki.providers.ProviderException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Category;

public class VersioningFileProvider
extends AbstractFileProvider {
    private static final Category log = Category.getInstance((Class)(class$com$ecyrd$jspwiki$providers$VersioningFileProvider == null ? (class$com$ecyrd$jspwiki$providers$VersioningFileProvider = VersioningFileProvider.class$("com.ecyrd.jspwiki.providers.VersioningFileProvider")) : class$com$ecyrd$jspwiki$providers$VersioningFileProvider));
    public static final String PAGEDIR = "OLD";
    public static final String PROPERTYFILE = "page.properties";
    static /* synthetic */ Class class$com$ecyrd$jspwiki$providers$VersioningFileProvider;

    public void initialize(Properties properties) throws NoRequiredPropertyException, IOException {
        super.initialize(properties);
    }

    private File findOldPageDir(String page) {
        if (page == null) {
            throw new InternalWikiException("Page may NOT be null in the provider!");
        }
        File oldpages = new File(this.getPageDirectory(), PAGEDIR);
        return new File(oldpages, this.mangleName(page));
    }

    private int findLatestVersion(String page) {
        File pageDir = this.findOldPageDir(page);
        String[] pages = pageDir.list(new AbstractFileProvider.WikiFileFilter());
        if (pages == null) {
            return -1;
        }
        int version = -1;
        for (int i = 0; i < pages.length; ++i) {
            int cutpoint = pages[i].indexOf(46);
            if (cutpoint <= 0) continue;
            String pageNum = pages[i].substring(0, cutpoint);
            try {
                int res = Integer.parseInt(pageNum);
                if (res <= version) continue;
                version = res;
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return version;
    }

    private Properties getPageProperties(String page) throws IOException {
        Properties props = new Properties();
        File propertyFile = new File(this.findOldPageDir(page), PROPERTYFILE);
        if (propertyFile != null && propertyFile.exists()) {
            FileInputStream in = new FileInputStream(propertyFile);
            props.load(in);
            ((InputStream)in).close();
        }
        return props;
    }

    private void putPageProperties(String page, Properties properties) throws IOException {
        File propertyFile = new File(this.findOldPageDir(page), PROPERTYFILE);
        FileOutputStream out = new FileOutputStream(propertyFile);
        properties.store(out, " JSPWiki page properties for " + page + ". DO NOT MODIFY!");
        ((OutputStream)out).close();
    }

    private int realVersion(String page, int requestedVersion) throws NoSuchVersionException {
        int latest = this.findLatestVersion(page);
        if (requestedVersion == -1 || requestedVersion == latest + 1 || requestedVersion == 1 && latest == -1) {
            return -1;
        }
        if (requestedVersion > latest) {
            throw new NoSuchVersionException("Requested version " + requestedVersion + ", but latest is " + latest);
        }
        return requestedVersion;
    }

    public synchronized String getPageText(String page, int version) throws ProviderException {
        File dir = this.findOldPageDir(page);
        if ((version = this.realVersion(page, version)) == -1) {
            return super.getPageText(page, -1);
        }
        File pageFile = new File(dir, "" + version + ".txt");
        return this.readFile(pageFile);
    }

    /*
     * Loose catch block
     */
    private String readFile(File pagedata) throws ProviderException {
        String result;
        block9: {
            block10: {
                block11: {
                    result = null;
                    FileInputStream in = null;
                    if (!pagedata.exists()) break block10;
                    if (!pagedata.canRead()) break block11;
                    in = new FileInputStream(pagedata);
                    result = FileUtil.readContents(in, this.m_encoding);
                    Object var6_4 = null;
                    try {
                        if (in != null) {
                            ((InputStream)in).close();
                        }
                        break block9;
                    }
                    catch (Exception e) {
                        log.fatal((Object)"Closing failed", (Throwable)e);
                    }
                    break block9;
                    {
                        catch (IOException e) {
                            log.error((Object)"Failed to read", (Throwable)e);
                            throw new ProviderException("I/O error: " + e.getMessage());
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_5 = null;
                        try {
                            if (in != null) {
                                ((InputStream)in).close();
                            }
                        }
                        catch (Exception e) {
                            log.fatal((Object)"Closing failed", (Throwable)e);
                        }
                        throw throwable;
                    }
                }
                log.warn((Object)("Failed to read page from '" + pagedata.getAbsolutePath() + "', possibly a permissions problem"));
                throw new ProviderException("I cannot read the requested page.");
            }
            log.info((Object)"New page");
        }
        return result;
    }

    public synchronized void putPageText(WikiPage page, String text) {
        File pageDir = this.findOldPageDir(page.getName());
        if (!pageDir.exists()) {
            pageDir.mkdirs();
        }
        int latest = this.findLatestVersion(page.getName());
        try {
            int versionNumber;
            File oldFile = this.findPage(page.getName());
            int n = versionNumber = latest >= 0 ? latest + 1 : 1;
            if (oldFile != null && oldFile.exists()) {
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(oldFile));
                File pageFile = new File(pageDir, Integer.toString(versionNumber) + ".txt");
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(pageFile));
                FileUtil.copyContents(in, out);
                ((OutputStream)out).close();
                ((InputStream)in).close();
                pageFile.setLastModified(oldFile.lastModified());
                ++versionNumber;
            }
            super.putPageText(page, text);
            Properties props = this.getPageProperties(page.getName());
            if (page.getAuthor() != null) {
                props.setProperty(versionNumber + ".author", page.getAuthor());
            }
            this.putPageProperties(page.getName(), props);
        }
        catch (IOException e) {
            log.error((Object)"Saving failed", (Throwable)e);
        }
    }

    public WikiPage getPageInfo(String page, int version) throws ProviderException {
        int realVersion;
        int latest = this.findLatestVersion(page);
        WikiPage p = null;
        if (version == -1 || version == latest + 1 || version == 1 && latest == -1) {
            realVersion = latest >= 0 ? latest + 1 : 1;
            p = super.getPageInfo(page, -1);
            if (p != null) {
                p.setVersion(realVersion);
            }
        } else {
            realVersion = version;
            File dir = this.findOldPageDir(page);
            if (!dir.exists() || !dir.isDirectory()) {
                return null;
            }
            File file = new File(dir, version + ".txt");
            if (file != null && file.exists()) {
                p = new WikiPage(page);
                p.setLastModified(new Date(file.lastModified()));
                p.setVersion(version);
            }
        }
        if (p != null) {
            try {
                Properties props = this.getPageProperties(page);
                String author = props.getProperty(realVersion + ".author");
                if (author != null) {
                    p.setAuthor(author);
                }
            }
            catch (IOException e) {
                log.error((Object)("Cannot get author for page" + page + ": "), (Throwable)e);
            }
        }
        return p;
    }

    public List getVersionHistory(String page) throws ProviderException {
        ArrayList<WikiPage> list = new ArrayList<WikiPage>();
        int latest = this.findLatestVersion(page);
        list.add(this.getPageInfo(page, -1));
        for (int i = latest; i > 0; --i) {
            WikiPage info = this.getPageInfo(page, i);
            if (info == null) continue;
            list.add(info);
        }
        return list;
    }

    public String getProviderInfo() {
        return "";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

