/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.rss;

import com.ecyrd.jspwiki.NoRequiredPropertyException;
import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.attachment.Attachment;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;

public class RSSGenerator {
    private WikiEngine m_engine;
    private String m_channelDescription = "";
    private String m_channelLanguage = "en-us";
    public static final String PROP_CHANNEL_DESCRIPTION = "jspwiki.rss.channelDescription";
    public static final String PROP_CHANNEL_LANGUAGE = "jspwiki.rss.channelLanguage";
    public static final String PROP_GENERATE_RSS = "jspwiki.rss.generate";
    public static final String PROP_RSSFILE = "jspwiki.rss.fileName";
    public static final String PROP_INTERVAL = "jspwiki.rss.interval";

    public RSSGenerator(WikiEngine engine, Properties properties) throws NoRequiredPropertyException {
        this.m_engine = engine;
        if (engine.getBaseURL() == null || engine.getBaseURL().length() == 0) {
            throw new NoRequiredPropertyException("RSS requires jspwiki.baseURL to be set!", "jspwiki.baseURL");
        }
        this.m_channelDescription = properties.getProperty(PROP_CHANNEL_DESCRIPTION, this.m_channelDescription);
        this.m_channelLanguage = properties.getProperty(PROP_CHANNEL_LANGUAGE, this.m_channelLanguage);
    }

    public static String format(String s) {
        s = TextUtil.replaceString(s, "&", "&amp;");
        s = TextUtil.replaceString(s, "<", "&lt;");
        s = TextUtil.replaceString(s, "]]>", "]]&gt;");
        return s.trim();
    }

    private String getAuthor(WikiPage page) {
        String author = page.getAuthor();
        if (author == null) {
            author = "An unknown author";
        }
        return author;
    }

    private String getAttachmentDescription(Attachment att) {
        String author = this.getAuthor(att);
        if (att.getVersion() != 1) {
            return author + " uploaded a new version of this attachment on " + att.getLastModified();
        }
        return author + " created this attachment on " + att.getLastModified();
    }

    private String getPageDescription(WikiPage page) {
        StringBuffer buf = new StringBuffer();
        String author = this.getAuthor(page);
        if (page.getVersion() > 1) {
            String diff = this.m_engine.getDiff(page.getName(), page.getVersion() - 1, page.getVersion());
            buf.append(author + " changed this page on " + page.getLastModified() + ":<br /><hr /><br />");
            buf.append(diff);
        } else {
            buf.append(author + " created this page on " + page.getLastModified() + ":<br /><hr /><br />");
            buf.append(this.m_engine.getHTML(page.getName()));
        }
        return buf.toString();
    }

    private String getEntryDescription(WikiPage page) {
        String res = page instanceof Attachment ? this.getAttachmentDescription((Attachment)page) : this.getPageDescription(page);
        return res;
    }

    private String getEntryTitle(WikiPage page) {
        return page.getName();
    }

    public String generate() {
        StringBuffer result = new StringBuffer();
        SimpleDateFormat iso8601fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        result.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        result.append("<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n   xmlns=\"http://purl.org/rss/1.0/\"\n   xmlns:dc=\"http://purl.org/dc/elements/1.1/\"\n   xmlns:wiki=\"http://purl.org/rss/1.0/modules/wiki/\">\n");
        result.append(" <channel rdf:about=\"" + this.m_engine.getBaseURL() + "\">\n");
        result.append("  <title>").append(this.m_engine.getApplicationName()).append("</title>\n");
        result.append("  <link>").append(this.m_engine.getBaseURL()).append("</link>\n");
        result.append("  <description>");
        result.append(RSSGenerator.format(this.m_channelDescription));
        result.append("</description>\n");
        result.append("  <language>");
        result.append(this.m_channelLanguage);
        result.append("</language>\n");
        Collection changed = this.m_engine.getRecentChanges();
        StringBuffer itemBuffer = new StringBuffer();
        result.append("  <items>\n   <rdf:Seq>\n");
        Iterator i = changed.iterator();
        for (int items = 0; i.hasNext() && items < 15; ++items) {
            WikiPage page = (WikiPage)i.next();
            String encodedName = this.m_engine.encodeName(page.getName());
            String url = page instanceof Attachment ? this.m_engine.getAttachmentURL(page.getName()) : this.m_engine.getViewURL(page.getName());
            result.append("    <rdf:li rdf:resource=\"" + url + "\" />\n");
            itemBuffer.append(" <item rdf:about=\"" + url + "\">\n");
            itemBuffer.append("  <title>");
            itemBuffer.append(this.getEntryTitle(page));
            itemBuffer.append("</title>\n");
            itemBuffer.append("  <link>");
            itemBuffer.append(url);
            itemBuffer.append("</link>\n");
            itemBuffer.append("  <description>");
            itemBuffer.append(RSSGenerator.format(this.getEntryDescription(page)));
            itemBuffer.append("</description>\n");
            if (page.getVersion() != -1) {
                itemBuffer.append("  <wiki:version>" + page.getVersion() + "</wiki:version>\n");
            }
            if (page.getVersion() > 1) {
                itemBuffer.append("  <wiki:diff>" + this.m_engine.getBaseURL() + "Diff.jsp?page=" + encodedName + "&amp;r1=-1" + "</wiki:diff>\n");
            }
            itemBuffer.append("  <dc:date>");
            Calendar cal = Calendar.getInstance();
            cal.setTime(page.getLastModified());
            cal.add(14, -(cal.get(15) + (cal.getTimeZone().inDaylightTime(page.getLastModified()) ? cal.get(16) : 0)));
            itemBuffer.append(iso8601fmt.format(cal.getTime()));
            itemBuffer.append("</dc:date>\n");
            String author = this.getAuthor(page);
            itemBuffer.append("  <dc:contributor>\n");
            itemBuffer.append("   <rdf:Description");
            if (this.m_engine.pageExists(author)) {
                itemBuffer.append(" link=\"" + this.m_engine.getViewURL(author) + "\"");
            }
            itemBuffer.append(">\n");
            itemBuffer.append("    <rdf:value>" + author + "</rdf:value>\n");
            itemBuffer.append("   </rdf:Description>\n");
            itemBuffer.append("  </dc:contributor>\n");
            itemBuffer.append("  <wiki:history>");
            itemBuffer.append(this.m_engine.getBaseURL() + "PageInfo.jsp?page=" + encodedName);
            itemBuffer.append("</wiki:history>\n");
            itemBuffer.append(" </item>\n");
        }
        result.append("   </rdf:Seq>\n  </items>\n");
        result.append(" </channel>\n");
        result.append(itemBuffer.toString());
        String searchURL = this.m_engine.getBaseURL() + "Search.jsp";
        result.append(" <textinput rdf:about=\"" + searchURL + "\">\n");
        result.append("  <title>Search</title>\n");
        result.append("  <description>Search this Wiki</description>\n");
        result.append("  <name>query</name>\n");
        result.append("  <link>" + searchURL + "</link>\n");
        result.append(" </textinput>\n");
        result.append("</rdf:RDF>");
        return result.toString();
    }
}

