/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.xmlrpc;

import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.xmlrpc.WikiRPCHandler;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public abstract class AbstractRPCHandler
implements WikiRPCHandler {
    public static final int ERR_NOPAGE = 1;
    public static final String LINK_LOCAL = "local";
    public static final String LINK_EXTERNAL = "external";
    public static final String LINK_INLINE = "inline";
    protected WikiEngine m_engine;
    public static final int RPC_VERSION = 1;

    public void initialize(WikiEngine engine) {
        this.m_engine = engine;
    }

    protected abstract Hashtable encodeWikiPage(WikiPage var1);

    public Vector getRecentChanges(Date since) {
        Collection pages = this.m_engine.getRecentChanges();
        Vector<Hashtable> result = new Vector<Hashtable>();
        Calendar cal = Calendar.getInstance();
        cal.setTime(since);
        cal.add(14, cal.get(15) + (cal.getTimeZone().inDaylightTime(since) ? cal.get(16) : 0));
        Iterator i = pages.iterator();
        while (i.hasNext()) {
            WikiPage page = (WikiPage)i.next();
            if (!page.getLastModified().after(cal.getTime())) continue;
            result.add(this.encodeWikiPage(page));
        }
        return result;
    }

    public int getRPCVersionSupported() {
        return 1;
    }
}

