/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.xmlrpc;

import com.ecyrd.jspwiki.LinkCollector;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.attachment.Attachment;
import com.ecyrd.jspwiki.xmlrpc.AbstractRPCHandler;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Category;
import org.apache.xmlrpc.XmlRpcException;

public class RPCHandlerUTF8
extends AbstractRPCHandler {
    Category log = Category.getInstance((Class)(class$com$ecyrd$jspwiki$xmlrpc$RPCHandlerUTF8 == null ? (class$com$ecyrd$jspwiki$xmlrpc$RPCHandlerUTF8 = RPCHandlerUTF8.class$("com.ecyrd.jspwiki.xmlrpc.RPCHandlerUTF8")) : class$com$ecyrd$jspwiki$xmlrpc$RPCHandlerUTF8));
    static /* synthetic */ Class class$com$ecyrd$jspwiki$xmlrpc$RPCHandlerUTF8;

    public String getApplicationName() {
        return this.m_engine.getApplicationName();
    }

    public Vector getAllPages() {
        Collection pages = this.m_engine.getRecentChanges();
        Vector<String> result = new Vector<String>();
        boolean count = false;
        Iterator i = pages.iterator();
        while (i.hasNext()) {
            WikiPage p = (WikiPage)i.next();
            if (p instanceof Attachment) continue;
            result.add(p.getName());
        }
        return result;
    }

    protected Hashtable encodeWikiPage(WikiPage page) {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("name", page.getName());
        Date d = page.getLastModified();
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.add(14, -(cal.get(15) + (cal.getTimeZone().inDaylightTime(d) ? cal.get(16) : 0)));
        ht.put("lastModified", cal.getTime());
        ht.put("version", new Integer(page.getVersion()));
        if (page.getAuthor() != null) {
            ht.put("author", page.getAuthor());
        }
        return ht;
    }

    public Vector getRecentChanges(Date since) {
        Collection pages = this.m_engine.getRecentChanges();
        Vector<Hashtable> result = new Vector<Hashtable>();
        Calendar cal = Calendar.getInstance();
        cal.setTime(since);
        cal.add(14, cal.get(15) + (cal.getTimeZone().inDaylightTime(since) ? cal.get(16) : 0));
        since = cal.getTime();
        Iterator i = pages.iterator();
        while (i.hasNext()) {
            WikiPage page = (WikiPage)i.next();
            if (!page.getLastModified().after(since) || page instanceof Attachment) continue;
            result.add(this.encodeWikiPage(page));
        }
        return result;
    }

    private String parsePageCheckCondition(String pagename) throws XmlRpcException {
        if (!this.m_engine.pageExists(pagename)) {
            throw new XmlRpcException(1, "No such page '" + pagename + "' found, o master.");
        }
        return pagename;
    }

    public Hashtable getPageInfo(String pagename) throws XmlRpcException {
        pagename = this.parsePageCheckCondition(pagename);
        return this.encodeWikiPage(this.m_engine.getPage(pagename));
    }

    public Hashtable getPageInfoVersion(String pagename, int version) throws XmlRpcException {
        pagename = this.parsePageCheckCondition(pagename);
        return this.encodeWikiPage(this.m_engine.getPage(pagename, version));
    }

    public String getPage(String pagename) throws XmlRpcException {
        pagename = this.parsePageCheckCondition(pagename);
        String text = this.m_engine.getPureText(pagename, -1);
        return text;
    }

    public String getPageVersion(String pagename, int version) throws XmlRpcException {
        pagename = this.parsePageCheckCondition(pagename);
        return this.m_engine.getPureText(pagename, version);
    }

    public String getPageHTML(String pagename) throws XmlRpcException {
        pagename = this.parsePageCheckCondition(pagename);
        return this.m_engine.getHTML(pagename);
    }

    public String getPageHTMLVersion(String pagename, int version) throws XmlRpcException {
        pagename = this.parsePageCheckCondition(pagename);
        return this.m_engine.getHTML(pagename, version);
    }

    public Vector listLinks(String pagename) throws XmlRpcException {
        Hashtable<String, String> ht;
        String link;
        pagename = this.parsePageCheckCondition(pagename);
        WikiPage page = this.m_engine.getPage(pagename);
        String pagedata = this.m_engine.getPureText(page);
        LinkCollector localCollector = new LinkCollector();
        LinkCollector extCollector = new LinkCollector();
        LinkCollector attCollector = new LinkCollector();
        this.m_engine.textToHTML(new WikiContext(this.m_engine, page), pagedata, localCollector, extCollector, attCollector);
        Vector result = new Vector();
        Iterator i = localCollector.getLinks().iterator();
        while (i.hasNext()) {
            link = (String)i.next();
            ht = new Hashtable<String, String>();
            ht.put("page", link);
            ht.put("type", "local");
            if (this.m_engine.pageExists(link)) {
                ht.put("href", this.m_engine.getViewURL(link));
            } else {
                ht.put("href", this.m_engine.getEditURL(link));
            }
            result.add(ht);
        }
        i = attCollector.getLinks().iterator();
        while (i.hasNext()) {
            link = (String)i.next();
            ht = new Hashtable();
            ht.put("page", link);
            ht.put("type", "local");
            ht.put("href", this.m_engine.getAttachmentURL(link));
            result.add(ht);
        }
        i = extCollector.getLinks().iterator();
        while (i.hasNext()) {
            link = (String)i.next();
            ht = new Hashtable();
            ht.put("page", link);
            ht.put("type", "external");
            ht.put("href", link);
            result.add(ht);
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

