/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.xmlrpc;

import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.xmlrpc.WikiRPCHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Category;
import org.apache.xmlrpc.XmlRpcServer;

public class RPCServlet
extends HttpServlet {
    public static final String XMLRPC_PREFIX = "wiki";
    private WikiEngine m_engine;
    private XmlRpcServer m_xmlrpcServer = new XmlRpcServer();
    Category log = Category.getInstance((Class)(class$com$ecyrd$jspwiki$xmlrpc$RPCServlet == null ? (class$com$ecyrd$jspwiki$xmlrpc$RPCServlet = RPCServlet.class$("com.ecyrd.jspwiki.xmlrpc.RPCServlet")) : class$com$ecyrd$jspwiki$xmlrpc$RPCServlet));
    static /* synthetic */ Class class$com$ecyrd$jspwiki$xmlrpc$RPCServlet;

    public void initHandler(String prefix, String handlerName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> handlerClass = Class.forName(handlerName);
        WikiRPCHandler rpchandler = (WikiRPCHandler)handlerClass.newInstance();
        rpchandler.initialize(this.m_engine);
        this.m_xmlrpcServer.addHandler(prefix, (Object)rpchandler);
    }

    public void init(ServletConfig config) throws ServletException {
        this.m_engine = WikiEngine.getInstance(config);
        String handlerName = config.getInitParameter("handler");
        String prefix = config.getInitParameter("prefix");
        if (handlerName == null) {
            handlerName = "com.ecyrd.jspwiki.xmlrpc.RPCHandler";
        }
        if (prefix == null) {
            prefix = XMLRPC_PREFIX;
        }
        try {
            this.initHandler(prefix, handlerName);
            this.initHandler("metaWeblog", "com.ecyrd.jspwiki.xmlrpc.MetaWeblogHandler");
        }
        catch (Exception e) {
            this.log.fatal((Object)"Unable to start RPC interface: ", (Throwable)e);
            throw new ServletException("No RPC interface", (Throwable)e);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.log.debug((Object)"Received POST to RPCServlet");
        try {
            byte[] result = this.m_xmlrpcServer.execute((InputStream)request.getInputStream());
            response.setContentType("text/xml; charset=utf-8");
            response.setContentLength(result.length);
            ServletOutputStream out = response.getOutputStream();
            out.write(result);
            out.flush();
        }
        catch (IOException e) {
            throw new ServletException("Failed to build RPC result", (Throwable)e);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.log.debug((Object)"Received HTTP GET to RPCServlet");
        try {
            String msg = "We do not support HTTP GET here.  Sorry.";
            response.setContentType("text/plain");
            response.setContentLength(msg.length());
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream()));
            writer.println(msg);
            writer.flush();
        }
        catch (IOException e) {
            throw new ServletException("Failed to build RPC result", (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

