/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.drivers;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.exolab.castor.jdo.drivers.HsqlColumn;
import org.exolab.castor.jdo.drivers.HsqlCondition;
import org.exolab.castor.jdo.drivers.JDBCQueryExpression;
import org.exolab.castor.persist.spi.PersistenceFactory;

public final class HsqlQueryExpression
extends JDBCQueryExpression {
    public HsqlQueryExpression(PersistenceFactory factory) {
        super(factory);
    }

    public final void addColumn(String tableName, String columnName) {
        this._tables.put(tableName, tableName);
        this._cols.addElement(new HsqlColumn(tableName, columnName));
    }

    public void addCondition(String tableName, String columnName, String condOp, String value) {
        this._tables.put(tableName, tableName);
        this._conds.addElement(new HsqlCondition(tableName, columnName, condOp, value));
    }

    public String getStatement(boolean lock) {
        StringBuffer sql = new StringBuffer(128);
        HsqlAliasInfo aliasInfo = new HsqlAliasInfo(this._joins);
        this.addSelectClause(sql, aliasInfo);
        this.addFromClause(sql, aliasInfo);
        boolean first = this.addJoinClause(sql, aliasInfo);
        this.addWhereClause(sql, aliasInfo, first);
        this.addOrderByClause(sql);
        this.addForUpdateClause(sql, lock);
        return sql.toString();
    }

    private void addSelectClause(StringBuffer buffer, HsqlAliasInfo aliasInfo) {
        buffer.append("SELECT ");
        if (this._distinct) {
            buffer.append(" DISTINCT ");
        }
        this.addColumnList(buffer, aliasInfo);
    }

    private void addFromClause(StringBuffer buffer, HsqlAliasInfo aliasInfo) {
        buffer.append(" FROM ");
        Hashtable tables = (Hashtable)this._tables.clone();
        boolean first = this.addOuterJoins(buffer, tables, aliasInfo);
        this.addTables(buffer, tables, first);
    }

    private boolean addOuterJoins(StringBuffer buffer, Hashtable tables, HsqlAliasInfo aliasInfo) {
        boolean first = true;
        int i = 0;
        while (i < this._joins.size()) {
            JDBCQueryExpression.Join join = (JDBCQueryExpression.Join)this._joins.elementAt(i);
            if (join.outer) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(",");
                }
                this.addOuterJoin(buffer, join, aliasInfo);
                tables.remove(join.leftTable);
                tables.remove(join.rightTable);
            }
            ++i;
        }
        return first;
    }

    private void addOuterJoin(StringBuffer buffer, JDBCQueryExpression.Join join, HsqlAliasInfo aliasInfo) {
        String leftAlias = aliasInfo.getAliasFor(join.leftTable, join);
        String rightAlias = aliasInfo.getAliasFor(join.rightTable, join);
        this.addJoinTable(buffer, join.leftTable, leftAlias);
        buffer.append(" LEFT OUTER JOIN ");
        this.addJoinTable(buffer, join.rightTable, rightAlias);
        buffer.append(" ON ").append(" (");
        String leftTable = leftAlias == null ? join.leftTable : leftAlias;
        String rightTable = rightAlias == null ? join.rightTable : rightAlias;
        this.addOuterJoinCondition(buffer, join.leftColumns, join.rightColumns, leftTable, rightTable);
        buffer.append(")");
    }

    private void addOuterJoinCondition(StringBuffer buffer, String[] leftColumns, String[] rightColumns, String leftTable, String rightTable) {
        int j = 0;
        while (j < leftColumns.length) {
            if (j > 0) {
                buffer.append(" AND ");
            }
            String name = leftTable + "." + leftColumns[j];
            buffer.append(this._factory.quoteName(name));
            buffer.append("=");
            name = rightTable + "." + rightColumns[j];
            buffer.append(this._factory.quoteName(name));
            ++j;
        }
    }

    private void addJoinTable(StringBuffer buffer, String table, String alias) {
        buffer.append(table);
        if (alias != null) {
            buffer.append(' ').append(alias);
        }
    }

    private void addTables(StringBuffer buffer, Hashtable tables, boolean first) {
        Enumeration enumeration = tables.elements();
        while (enumeration.hasMoreElements()) {
            if (first) {
                first = false;
            } else {
                buffer.append(",");
            }
            buffer.append(this._factory.quoteName((String)enumeration.nextElement()));
        }
    }

    private boolean addJoinClause(StringBuffer buffer, HsqlAliasInfo aliasInfo) {
        boolean first = true;
        int i = 0;
        while (i < this._joins.size()) {
            JDBCQueryExpression.Join join = (JDBCQueryExpression.Join)this._joins.elementAt(i);
            if (!join.outer) {
                first = this.addWhereOrAnd(buffer, first);
                this.addJoin(buffer, aliasInfo, join);
            }
            ++i;
        }
        first = this.addOuterJoins(buffer, aliasInfo, first);
        return first;
    }

    private void addJoin(StringBuffer buffer, HsqlAliasInfo aliasInfo, JDBCQueryExpression.Join join) {
        int j = 0;
        while (j < join.leftColumns.length) {
            if (j > 0) {
                buffer.append(" AND ");
            }
            String where = this.quoteTableAndColumn(join.leftTable, join.leftColumns[j]);
            buffer.append(this.checkForAlias(aliasInfo, join.leftTable, where));
            buffer.append("=");
            where = this.quoteTableAndColumn(join.rightTable, join.rightColumns[j]);
            buffer.append(this.checkForAlias(aliasInfo, join.rightTable, where));
            ++j;
        }
    }

    private String checkForAlias(HsqlAliasInfo aliasInfo, String tableName, String where) {
        String alias = aliasInfo.getAnAliasFor(tableName);
        if (alias != null) {
            return this.substituteAlias(where, tableName, alias);
        }
        return where;
    }

    private boolean addOuterJoins(StringBuffer buffer, HsqlAliasInfo aliasInfo, boolean first) {
        Enumeration keys = aliasInfo.getTables();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Hashtable hash = aliasInfo.getAliasHash(key);
            Enumeration joins = hash.keys();
            JDBCQueryExpression.Join join = (JDBCQueryExpression.Join)joins.nextElement();
            String[] columns = join.leftTable.equals(key) ? join.leftColumns : join.rightColumns;
            while (joins.hasMoreElements()) {
                first = this.addWhereOrAnd(buffer, first);
                this.addOuterJoinCondition(buffer, columns, columns, (String)hash.get(join), (String)hash.get(joins.nextElement()));
            }
        }
        return first;
    }

    private String quoteTableAndColumn(String table, String column) {
        return this._factory.quoteName(table + "." + column);
    }

    protected boolean addWhereClause(StringBuffer buffer, HsqlAliasInfo aliasInfo, boolean first) {
        first = this.addConditions(buffer, aliasInfo, first);
        first = this.addWhere(buffer, aliasInfo, first);
        return first;
    }

    private boolean addConditions(StringBuffer buffer, HsqlAliasInfo aliasInfo, boolean first) {
        if (this._conds.size() > 0) {
            first = this.addWhereOrAnd(buffer, first);
            int i = 0;
            while (i < this._conds.size()) {
                if (i > 0) {
                    buffer.append(" AND ");
                }
                HsqlCondition condition = (HsqlCondition)this._conds.elementAt(i);
                buffer.append(this.getConditionString(condition, aliasInfo));
                ++i;
            }
        }
        return first;
    }

    private boolean addWhere(StringBuffer buffer, HsqlAliasInfo aliasInfo, boolean first) {
        if (this._where != null) {
            first = this.addWhereOrAnd(buffer, first);
            String where = this._where;
            Enumeration enumeration = aliasInfo.getTables();
            while (enumeration.hasMoreElements()) {
                String table = (String)enumeration.nextElement();
                String alias = aliasInfo.getAnAliasFor(table);
                where = this.substituteAlias(where, table + '.', alias + '.');
            }
            buffer.append(where);
        }
        return first;
    }

    private String substituteAlias(String expression, String table, String alias) {
        StringBuffer buffer = new StringBuffer(expression.length());
        int pos = 0;
        int end = expression.indexOf(table);
        while (end != -1) {
            buffer.append(expression.substring(pos, end));
            buffer.append(alias);
            pos = end + table.length();
            end = expression.indexOf(table, pos);
        }
        buffer.append(expression.substring(pos));
        return buffer.toString();
    }

    private void addOrderByClause(StringBuffer buffer) {
        if (this._order != null) {
            buffer.append(" ORDER BY ").append(this._order);
        }
    }

    private void addForUpdateClause(StringBuffer buffer, boolean lock) {
    }

    private void addColumnList(StringBuffer buffer, HsqlAliasInfo aliasInfo) {
        if (this._cols.size() == 0) {
            buffer.append("1");
            return;
        }
        int i = 0;
        i = 0;
        while (i < this._cols.size()) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(this.getColumnString((HsqlColumn)this._cols.elementAt(i), aliasInfo));
            ++i;
        }
        if (this._select != null) {
            if (i > 0) {
                buffer.append(",").append(this._select);
            } else {
                buffer.append(this._select);
            }
        }
    }

    private String getColumnString(HsqlColumn column, HsqlAliasInfo aliasInfo) {
        String tableName = column.getTableName();
        String columnName = column.getColumnName();
        if (aliasInfo.tableExists(tableName)) {
            tableName = aliasInfo.getAnAliasFor(tableName);
        }
        return tableName + "." + columnName;
    }

    private String getConditionString(HsqlCondition condition, HsqlAliasInfo aliasInfo) {
        return this.getColumnString(condition.getColumn(), aliasInfo) + condition.getOperator() + condition.getValue();
    }

    private boolean addWhereOrAnd(StringBuffer buffer, boolean first) {
        if (first) {
            buffer.append(" WHERE ");
        } else {
            buffer.append(" AND ");
        }
        return false;
    }

    final class HsqlAliasInfo {
        private int _count = 1;
        private final Hashtable _hash;

        public HsqlAliasInfo(Vector joins) {
            this._hash = this.getRepeatedTablesInOuterJoinsHash(joins);
        }

        private Hashtable getRepeatedTablesInOuterJoinsHash(Vector joins) {
            Hashtable hash = new Hashtable();
            Hashtable countHash = this.getTableCountInOuterJoinsHash(joins);
            Enumeration keys = countHash.keys();
            while (keys.hasMoreElements()) {
                String table = (String)keys.nextElement();
                Vector vec = (Vector)countHash.get(table);
                if (vec.size() <= 1) continue;
                Hashtable temp = new Hashtable();
                Enumeration joinenum = vec.elements();
                while (joinenum.hasMoreElements()) {
                    temp.put(joinenum.nextElement(), "a" + this._count++);
                }
                hash.put(table, temp);
            }
            return hash;
        }

        private Hashtable getTableCountInOuterJoinsHash(Vector joins) {
            Hashtable hash = new Hashtable();
            JDBCQueryExpression.Join join = null;
            int i = 0;
            while (i < joins.size()) {
                join = (JDBCQueryExpression.Join)joins.elementAt(i);
                if (join.outer) {
                    this.addTableCount(hash, join.leftTable, join);
                    this.addTableCount(hash, join.rightTable, join);
                }
                ++i;
            }
            return hash;
        }

        private void addTableCount(Hashtable hash, String table, JDBCQueryExpression.Join join) {
            Vector vec = null;
            if (hash.containsKey(table)) {
                vec = (Vector)hash.get(table);
            } else {
                vec = new Vector();
                hash.put(table, vec);
            }
            vec.addElement(join);
        }

        public Enumeration getTables() {
            return this._hash.keys();
        }

        public boolean tableExists(String table) {
            return this._hash.containsKey(table);
        }

        public String getAnAliasFor(String table) {
            Hashtable hash = (Hashtable)this._hash.get(table);
            return hash == null ? null : (String)hash.elements().nextElement();
        }

        public String getAliasFor(String table, JDBCQueryExpression.Join join) {
            Hashtable hash = (Hashtable)this._hash.get(table);
            return hash == null ? null : (String)hash.get(join);
        }

        public Hashtable getAliasHash(String table) {
            return (Hashtable)this._hash.get(table);
        }
    }
}

