/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import org.exolab.javasource.JSourceWriter;
import org.exolab.javasource.LineFormatter;

public class JComment {
    public static final short AUTO_STYLE = 0;
    public static final short BLOCK_STYLE = 1;
    public static final short LINE_STYLE = 2;
    public static final short HEADER_STYLE = 3;
    public static final short JAVADOC_STYLE = 4;
    private static final String START_BLOCK = "/*";
    private static final String END_BLOCK = " */";
    private static final String START_JAVADOC = "/**";
    private static final String END_JAVADOC = " */";
    private static final String ASTERIX_PREFIX = " * ";
    private static final String LINE_COMMENT_PREFIX = "// ";
    private static final String SPACE_PREFIX = " ";
    private short style = 0;
    private StringBuffer _comment = new StringBuffer();
    protected static final int MAX_LENGTH = 65;

    public JComment() {
    }

    public JComment(short style) {
        this();
        this.style = style;
    }

    public void appendComment(String comment) {
        this._comment.append(comment);
    }

    public void print(JSourceWriter jsw) {
        if (jsw == null) {
            return;
        }
        LineFormatter formatter = null;
        short currentIndent = jsw.getIndentSize();
        int maxLength = 65 - currentIndent;
        if (maxLength <= 17) {
            maxLength = 32;
        }
        int resolvedStyle = this.style;
        if (this.style == 0) {
            int nbrLines = this._comment.length() / maxLength;
            resolvedStyle = nbrLines > 2 ? 1 : 2;
        }
        String prefix = null;
        String start = null;
        String end = null;
        switch (resolvedStyle) {
            case 1: {
                start = START_BLOCK;
                end = " */";
                prefix = SPACE_PREFIX;
                break;
            }
            case 3: {
                start = START_BLOCK;
                end = " */";
                prefix = ASTERIX_PREFIX;
                break;
            }
            case 4: {
                start = START_JAVADOC;
                end = " */";
                prefix = ASTERIX_PREFIX;
                break;
            }
            default: {
                prefix = LINE_COMMENT_PREFIX;
            }
        }
        if (start != null) {
            jsw.writeln(start);
        }
        formatter = new LineFormatter(this._comment.toString(), maxLength, prefix);
        while (formatter.hasMoreLines()) {
            jsw.writeln(formatter.nextLine());
        }
        if (end != null) {
            jsw.writeln(end);
        }
        jsw.flush();
    }

    public void setComment(String comment) {
        this._comment.setLength(0);
        this._comment.append(comment);
    }

    public void setStyle(short style) {
        this.style = style;
    }

    public String toString() {
        return "";
    }
}

