/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import org.apache.catalina.loader.StandardClassLoader;
import org.apache.tomcat.util.compat.JdkCompat;

public final class ClassLoaderFactory {
    private static int debug = 0;
    private static final JdkCompat jdkCompat = JdkCompat.getJdkCompat();

    public static int getDebug() {
        return debug;
    }

    public static void setDebug(int newDebug) {
        debug = newDebug;
    }

    public static ClassLoader createClassLoader(File[] unpacked, File[] packed, ClassLoader parent) throws Exception {
        return ClassLoaderFactory.createClassLoader(unpacked, packed, null, parent);
    }

    public static ClassLoader createClassLoader(File[] unpacked, File[] packed, URL[] urls, ClassLoader parent) throws Exception {
        int i;
        if (debug >= 1) {
            ClassLoaderFactory.log("Creating new class loader");
        }
        ArrayList<String> list = new ArrayList<String>();
        if (unpacked != null) {
            for (i = 0; i < unpacked.length; ++i) {
                File file = unpacked[i];
                if (!file.exists() || !file.canRead()) continue;
                if (debug >= 1) {
                    ClassLoaderFactory.log("  Including directory or JAR " + file.getAbsolutePath());
                }
                URL url = new URL("file", null, file.getCanonicalPath() + File.separator);
                list.add(url.toString());
            }
        }
        if (packed != null) {
            for (i = 0; i < packed.length; ++i) {
                File directory = packed[i];
                if (!directory.isDirectory() || !directory.exists() || !directory.canRead()) continue;
                String[] filenames = directory.list();
                for (int j = 0; j < filenames.length; ++j) {
                    String filename = filenames[j].toLowerCase();
                    if (!filename.endsWith(".jar")) continue;
                    File file = new File(directory, filenames[j]);
                    if (debug >= 1) {
                        ClassLoaderFactory.log("  Including jar file " + file.getAbsolutePath());
                    }
                    URL url = new URL("file", null, file.getCanonicalPath());
                    if (jdkCompat.isJava15()) {
                        if (url.toString().endsWith("xml-apis.jar") || url.toString().endsWith("xercesImpl.jar")) continue;
                        list.add(url.toString());
                        continue;
                    }
                    list.add(url.toString());
                }
            }
        }
        if (urls != null) {
            for (i = 0; i < urls.length; ++i) {
                list.add(urls[i].toString());
            }
        }
        String[] array = list.toArray(new String[list.size()]);
        StandardClassLoader classLoader = null;
        classLoader = parent == null ? new StandardClassLoader(array) : new StandardClassLoader(array, parent);
        classLoader.setDelegate(true);
        return classLoader;
    }

    private static void log(String message) {
        System.out.print("ClassLoaderFactory:  ");
        System.out.println(message);
    }

    private static void log(String message, Throwable exception) {
        ClassLoaderFactory.log(message);
        exception.printStackTrace(System.out);
    }
}

