/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.RunRecoveryException;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.utilint.PropUtil;

public class Transaction {
    private Txn txn;
    private Environment env;
    private String name;

    Transaction(Environment env, Txn txn, String name) {
        this.env = env;
        this.txn = txn;
        this.name = name;
    }

    public void abort() throws DatabaseException {
        this.checkEnv();
        this.env.removeReferringHandle(this);
        this.txn.abort();
    }

    public long getId() throws DatabaseException {
        return this.txn.getId();
    }

    public void commit() throws DatabaseException {
        this.checkEnv();
        this.env.removeReferringHandle(this);
        this.txn.commit();
    }

    public void commitSync() throws DatabaseException {
        this.checkEnv();
        this.env.removeReferringHandle(this);
        this.txn.commit(true);
    }

    public void commitNoSync() throws DatabaseException {
        this.checkEnv();
        this.env.removeReferringHandle(this);
        this.txn.commit(false);
    }

    public void setTxnTimeout(long timeOut) throws DatabaseException {
        this.checkEnv();
        this.txn.setTxnTimeout(PropUtil.microsToMillis(timeOut));
    }

    public void setLockTimeout(long timeOut) throws DatabaseException {
        this.checkEnv();
        this.txn.setLockTimeout(PropUtil.microsToMillis(timeOut));
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<Transaction id=\"");
        sb.append(this.txn.getId()).append("\"");
        if (this.name != null) {
            sb.append(" name=\"");
            sb.append(this.name).append("\"");
        }
        sb.append(">");
        return sb.toString();
    }

    Locker getLocker() {
        return this.txn;
    }

    private void checkEnv() throws RunRecoveryException {
        this.env.getEnvironmentImpl().checkIfInvalid();
    }
}

