/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.cleaner.FileRetryInfo;
import com.sleepycat.je.cleaner.FileSelector;
import com.sleepycat.je.cleaner.UtilizationProfile;
import com.sleepycat.je.cleaner.UtilizationSelector;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.EnvironmentStatsInternal;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.log.CleanerFileReader;
import com.sleepycat.je.log.LogFileNotFoundException;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.DIN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.tree.WithRootLatched;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.utilint.DaemonThread;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.PropUtil;
import com.sleepycat.je.utilint.Tracer;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Cleaner
extends DaemonThread {
    private static final String CLEAN_IN = "CleanIN:";
    private static final String CLEAN_LN = "CleanLN:";
    private static final String CLEAN_DELTA = "CleanDelta:";
    private EnvironmentImpl env;
    private long lockTimeout;
    private Set filesToDelete;
    private int nCleanerRuns = 0;
    private int nCleanerDeletions = 0;
    private int nINsCleaned = 0;
    private int nINsMigrated = 0;
    private int nLNsCleaned = 0;
    private int nLNsDead = 0;
    private int nLNsLocked = 0;
    private int nLNsMigrated = 0;
    private int nDeltasCleaned = 0;
    private int nEntriesRead = 0;
    private long nRepeatIteratorReads = 0L;
    private int nINsCleanedThisRun = 0;
    private int nINsMigratedThisRun = 0;
    private int nLNsCleanedThisRun = 0;
    private int nLNsDeadThisRun = 0;
    private int nLNsLockedThisRun = 0;
    private int nLNsMigratedThisRun = 0;
    private int nDeltasCleanedThisRun = 0;
    private int nEntriesReadThisRun;
    private long nRepeatIteratorReadsThisRun;
    private boolean expunge = false;
    private long maxDiskSpace;
    private long diskSpaceTolerance;
    private int minFilesToDelete;
    private FileSelector fileSelector;
    private UtilizationProfile profile;
    private Level detailedTraceLevel;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Cleaner(EnvironmentImpl env, long waitTime, String name, UtilizationProfile profile) throws DatabaseException {
        super(waitTime, name, env);
        this.env = env;
        this.profile = profile;
        this.maxDiskSpace = env.getConfigManager().getLong(EnvironmentParams.MAX_DISK_SPACE);
        this.lockTimeout = PropUtil.microsToMillis(env.getConfigManager().getLong(EnvironmentParams.CLEANER_LOCK_TIMEOUT));
        this.expunge = env.getConfigManager().getBoolean(EnvironmentParams.CLEANER_REMOVE);
        int diskTolerancePct = env.getConfigManager().getInt(EnvironmentParams.CLEANER_DISK_SPACE_TOLERANCE);
        this.diskSpaceTolerance = this.maxDiskSpace * (long)diskTolerancePct / 100L;
        this.minFilesToDelete = env.getConfigManager().getInt(EnvironmentParams.CLEANER_MIN_FILES_TO_DELETE);
        this.fileSelector = new UtilizationSelector(env, profile);
        this.filesToDelete = new HashSet();
        this.detailedTraceLevel = Tracer.parseLevel(env, EnvironmentParams.JE_LOGGING_LEVEL_CLEANER);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<Cleaner name=\"").append(this.name).append("\"/>");
        return sb.toString();
    }

    public void addToQueue(Object o) throws DatabaseException {
        throw new DatabaseException("Cleaner.addToQueue should never be called.");
    }

    public void loadStats(StatsConfig config, EnvironmentStatsInternal stat) throws DatabaseException {
        stat.setNCleanerRuns(this.nCleanerRuns);
        stat.setNCleanerDeletions(this.nCleanerDeletions);
        stat.setNINsCleaned(this.nINsCleaned);
        stat.setNINsMigrated(this.nINsMigrated);
        stat.setNLNsCleaned(this.nLNsCleaned);
        stat.setNLNsDead(this.nLNsDead);
        stat.setNLNsLocked(this.nLNsLocked);
        stat.setNLNsMigrated(this.nLNsMigrated);
        stat.setNDeltasCleaned(this.nDeltasCleaned);
        stat.setNCleanerEntriesRead(this.nEntriesRead);
        stat.setNRepeatIteratorReads(this.nRepeatIteratorReads);
        if (config.getClear()) {
            this.nCleanerRuns = 0;
            this.nCleanerDeletions = 0;
            this.nINsCleaned = 0;
            this.nINsMigrated = 0;
            this.nLNsCleaned = 0;
            this.nLNsDead = 0;
            this.nLNsLocked = 0;
            this.nLNsMigrated = 0;
            this.nDeltasCleaned = 0;
            this.nEntriesRead = 0;
            this.nRepeatIteratorReads = 0L;
        }
    }

    public synchronized void clearEnv() {
        this.env = null;
    }

    protected int nDeadlockRetries() throws DatabaseException {
        return this.env.getConfigManager().getInt(EnvironmentParams.CLEANER_DEADLOCK_RETRY);
    }

    private boolean interruptCleaning() {
        return false;
    }

    public void onWakeup() throws DatabaseException {
        this.doClean(true, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int doClean(boolean invokedFromDaemon, boolean cleanMultipleFiles, boolean forceAggressive) throws DatabaseException {
        if (this.env.isClosed()) {
            return 0;
        }
        nOriginalLogFiles = this.profile.getNumberOfFiles();
        anyProgress = false;
        nFilesCleaned = 0;
        while (true) {
            block19: {
                if (nFilesCleaned >= nOriginalLogFiles) {
                    return nFilesCleaned;
                }
                if (this.isShutdownRequested()) {
                    return nFilesCleaned;
                }
                var8_9 = this.filesToDelete;
                synchronized (var8_9) {
                    fileRetryInfo = this.fileSelector.getFileToClean(this.filesToDelete, forceAggressive != false || this.isNearDiskBudget(true) != false);
                    ** if (fileRetryInfo != null) goto lbl16
                }
lbl15:
                // 1 sources

                return nFilesCleaned;
lbl16:
                // 1 sources

                if (!this.env.getFileManager().lockEnvironment(false, true)) {
                    return nFilesCleaned;
                }
                this.resetPerRunCounters();
                finished = false;
                fileNum = null;
                fileNumValue = 0L;
                canDeleteFile = false;
                try {
                    try {
                        ++this.nCleanerRuns;
                        if (!Cleaner.$assertionsDisabled && Latch.countLatchesHeld() != 0) {
                            throw new AssertionError();
                        }
                        fileNum = fileRetryInfo.getFileNumber();
                        fileNumValue = fileNum;
                        Tracer.trace(Level.INFO, this.env, "CleanerRun " + this.nCleanerRuns + " on file " + "0x" + Long.toHexString(fileNumValue) + " begins");
                        pendingLsns = fileRetryInfo.getPendingLsns();
                        if (pendingLsns != null && this.processPending(pendingLsns, fileRetryInfo)) {
                            anyProgress = true;
                        }
                        if (!fileRetryInfo.isFileFullyProcessed()) {
                            cm = this.env.getConfigManager();
                            readBufferSize = cm.getInt(EnvironmentParams.LOG_ITERATOR_READ_SIZE);
                            cleanerFileReader = new CleanerFileReader(this.env, readBufferSize, startLsn = fileRetryInfo.getFirstUnprocessedLsn(), fileNum);
                            if (this.processFile(cleanerFileReader, fileRetryInfo)) {
                                anyProgress = true;
                            }
                            this.nRepeatIteratorReadsThisRun = cleanerFileReader.getNRepeatIteratorReads();
                        }
                        if (fileRetryInfo.canFileBeDeleted()) {
                            var14_15 = this.filesToDelete;
                            synchronized (var14_15) {
                                this.filesToDelete.add(fileNum);
                            }
                            canDeleteFile = true;
                            ++nFilesCleaned;
                        }
                        this.accumulatePerRunCounters();
                        finished = true;
                        if (cleanMultipleFiles) break block19;
                        var20_19 = null;
                        fileRetryInfo.endProcessing(canDeleteFile);
                    }
                    catch (IOException IOE) {
                        Tracer.trace(this.env, "Cleaner", "doClean", "", IOE);
                        throw new DatabaseException(IOE);
                    }
                }
                catch (Throwable var19_20) {
                    var20_19 = null;
                    fileRetryInfo.endProcessing(canDeleteFile);
                    this.env.getFileManager().releaseExclusiveLock();
                    Tracer.trace(Level.SEVERE, this.env, "CleanerRun " + this.nCleanerRuns + " on file " + (fileNum == null ? "none" : "0x" + Long.toHexString(fileNum)) + " invokedFromDaemon=" + invokedFromDaemon + " finished=" + finished + " canDelete=" + canDeleteFile + " nEntriesRead=" + this.nEntriesReadThisRun + " nINsCleaned=" + this.nINsCleanedThisRun + " nINsMigrated=" + this.nINsMigratedThisRun + " nLNsCleaned=" + this.nLNsCleanedThisRun + " nLNsDead=" + this.nLNsDeadThisRun + " nLNsMigrated=" + this.nLNsMigratedThisRun + " nLNsLocked=" + this.nLNsLockedThisRun + " nDeltasCleaned= " + this.nDeltasCleanedThisRun);
                    throw var19_20;
                }
                this.env.getFileManager().releaseExclusiveLock();
                Tracer.trace(Level.SEVERE, this.env, "CleanerRun " + this.nCleanerRuns + " on file " + (fileNum == null ? "none" : "0x" + Long.toHexString(fileNum)) + " invokedFromDaemon=" + invokedFromDaemon + " finished=" + finished + " canDelete=" + canDeleteFile + " nEntriesRead=" + this.nEntriesReadThisRun + " nINsCleaned=" + this.nINsCleanedThisRun + " nINsMigrated=" + this.nINsMigratedThisRun + " nLNsCleaned=" + this.nLNsCleanedThisRun + " nLNsDead=" + this.nLNsDeadThisRun + " nLNsMigrated=" + this.nLNsMigratedThisRun + " nLNsLocked=" + this.nLNsLockedThisRun + " nDeltasCleaned= " + this.nDeltasCleanedThisRun);
                return nFilesCleaned;
            }
            var20_19 = null;
            fileRetryInfo.endProcessing(canDeleteFile);
            this.env.getFileManager().releaseExclusiveLock();
            Tracer.trace(Level.SEVERE, this.env, "CleanerRun " + this.nCleanerRuns + " on file " + (fileNum == null ? "none" : "0x" + Long.toHexString(fileNum)) + " invokedFromDaemon=" + invokedFromDaemon + " finished=" + finished + " canDelete=" + canDeleteFile + " nEntriesRead=" + this.nEntriesReadThisRun + " nINsCleaned=" + this.nINsCleanedThisRun + " nINsMigrated=" + this.nINsMigratedThisRun + " nLNsCleaned=" + this.nLNsCleanedThisRun + " nLNsDead=" + this.nLNsDeadThisRun + " nLNsMigrated=" + this.nLNsMigratedThisRun + " nLNsLocked=" + this.nLNsLockedThisRun + " nDeltasCleaned= " + this.nDeltasCleanedThisRun);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getCleanedFiles(boolean getAll) {
        Set set = this.filesToDelete;
        synchronized (set) {
            int minFiles;
            int n = minFiles = getAll ? 1 : this.minFilesToDelete;
            if (this.filesToDelete.size() < minFiles) {
                return null;
            }
            return new HashSet(this.filesToDelete);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCleanedFiles(Set cleanedFiles) throws DatabaseException {
        int nFilesDeleted = 0;
        try {
            Iterator i = cleanedFiles.iterator();
            while (i.hasNext()) {
                Long fileNum = (Long)i.next();
                long fileNumValue = fileNum;
                Set set = this.filesToDelete;
                synchronized (set) {
                    if (!$assertionsDisabled && !this.filesToDelete.contains(fileNum)) {
                        throw new AssertionError();
                    }
                }
                try {
                    if (this.expunge) {
                        this.env.getFileManager().deleteFile(fileNumValue);
                    } else {
                        this.env.getFileManager().renameFile(fileNumValue, ".del");
                    }
                }
                catch (IOException e) {
                    Tracer.trace(this.env, "Cleaner", "deleteCleanedFiles", "", e);
                    throw new DatabaseException(e);
                }
                this.profile.removeFile(fileNum);
                set = this.filesToDelete;
                synchronized (set) {
                    this.filesToDelete.remove(fileNum);
                }
                ++nFilesDeleted;
                ++this.nCleanerDeletions;
            }
        }
        finally {
            Tracer.trace(Level.SEVERE, this.env, "CleanerRun checkpoint complete nFilesDeleted=" + nFilesDeleted);
        }
    }

    public boolean isNearDiskBudget(boolean calcIfNecessary) throws DatabaseException {
        long size = this.profile.getTotalLogSize(calcIfNecessary);
        return size < 0L || this.maxDiskSpace < size || this.maxDiskSpace - size <= this.diskSpaceTolerance;
    }

    private boolean processPending(DbLsn[] pendingLsns, FileRetryInfo fileRetryInfo) throws DatabaseException, IOException {
        DbTree dbMapTree = this.env.getDbMapTree();
        TreeLocation location = new TreeLocation();
        LogManager logManager = this.env.getLogManager();
        boolean anyProgress = false;
        for (int i = 0; i < pendingLsns.length; ++i) {
            DbLsn lsn = pendingLsns[i];
            if (this.interruptCleaning()) break;
            LogEntry entry = logManager.getLogEntry(lsn);
            ++this.nEntriesRead;
            if (entry instanceof LNLogEntry) {
                LNLogEntry lnEntry = (LNLogEntry)entry;
                LN targetLN = lnEntry.getLN();
                long nodeId = targetLN.getNodeId();
                DatabaseId dbId = lnEntry.getDbId();
                Key key = lnEntry.getKey();
                Key dupKey = lnEntry.getDupKey();
                DatabaseImpl db = dbMapTree.getDb(dbId, this.lockTimeout);
                if (!this.processLN(targetLN, db, key, dupKey, lsn, location)) continue;
                fileRetryInfo.setObsoleteLN(lsn, nodeId);
                anyProgress = true;
                continue;
            }
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)entry.getClass().getName());
            }
        }
        return anyProgress;
    }

    private boolean processFile(CleanerFileReader reader, FileRetryInfo fileRetryInfo) throws DatabaseException, IOException {
        DbTree dbMapTree = this.env.getDbMapTree();
        TreeLocation location = new TreeLocation();
        boolean anyProgress = false;
        boolean interrupted = false;
        while (reader.readNextEntry()) {
            ++this.nEntriesRead;
            DbLsn lsn = reader.getLastLsn();
            fileRetryInfo.setFirstUnprocessedLsn(lsn);
            if (this.interruptCleaning()) {
                interrupted = true;
                break;
            }
            if (reader.isLN()) {
                LN targetLN = reader.getLN();
                long nodeId = targetLN.getNodeId();
                if (fileRetryInfo.isObsoleteLN(lsn, nodeId)) continue;
                DatabaseId dbId = reader.getDatabaseId();
                Key key = reader.getKey();
                Key dupKey = reader.getDupTreeKey();
                DatabaseImpl db = dbMapTree.getDb(dbId, this.lockTimeout);
                if (this.processLN(targetLN, db, key, dupKey, lsn, location)) {
                    fileRetryInfo.setObsoleteLN(lsn, nodeId);
                    anyProgress = true;
                    continue;
                }
                fileRetryInfo.setPendingLN(lsn, nodeId);
                continue;
            }
            if (reader.isIN()) {
                IN targetIN = reader.getIN();
                DatabaseId dbId = reader.getDatabaseId();
                DatabaseImpl db = dbMapTree.getDb(dbId, this.lockTimeout);
                targetIN.setDatabase(db);
                this.processIN(targetIN, db, lsn);
                anyProgress = true;
                continue;
            }
            if (reader.isRoot()) {
                this.env.rewriteMapTreeRoot(lsn);
                anyProgress = true;
                continue;
            }
            if (!reader.isDelta()) continue;
            DatabaseId dbId = reader.getDatabaseId();
            DatabaseImpl db = dbMapTree.getDb(dbId, this.lockTimeout);
            this.processDelta(reader, db, lsn);
            anyProgress = true;
        }
        if (!interrupted) {
            fileRetryInfo.setFileFullyProcessed();
        }
        this.nEntriesReadThisRun = reader.getNumRead();
        return anyProgress;
    }

    private boolean processLN(LN lnClone, DatabaseImpl db, Key key, Key dupKey, DbLsn logLsn, TreeLocation location) throws DatabaseException {
        boolean bl;
        LN lnInTree;
        boolean lnIsDupCountLN;
        boolean cleaned;
        boolean insPinned;
        DIN parentDIN;
        BasicLocker locker;
        boolean completed;
        boolean migrated;
        boolean obsolete;
        block33: {
            ChildReference ref;
            block32: {
                block31: {
                    block30: {
                        obsolete = false;
                        migrated = false;
                        completed = false;
                        locker = null;
                        parentDIN = null;
                        insPinned = false;
                        if (db != null && !db.getIsDeleted()) break block30;
                        obsolete = true;
                        completed = true;
                        boolean bl2 = true;
                        Object var24_16 = null;
                        this.unPinAndRelease(parentDIN, insPinned);
                        this.unPinAndRelease(location.bin, insPinned);
                        if (locker != null) {
                            locker.operationEnd();
                        }
                        this.trace(this.detailedTraceLevel, CLEAN_LN, lnClone, logLsn, completed, obsolete, migrated);
                        return bl2;
                    }
                    cleaned = true;
                    ++this.nLNsCleanedThisRun;
                    Tree tree = db.getTree();
                    if (!$assertionsDisabled && tree == null) {
                        throw new AssertionError();
                    }
                    boolean found = tree.getParentBINForChildLN(location, key, dupKey, lnClone, false, true, false);
                    lnIsDupCountLN = lnClone.containsDuplicates();
                    if (found) break block31;
                    obsolete = true;
                    ++this.nLNsDeadThisRun;
                    completed = true;
                    boolean bl3 = cleaned;
                    Object var24_17 = null;
                    this.unPinAndRelease(parentDIN, insPinned);
                    this.unPinAndRelease(location.bin, insPinned);
                    if (locker != null) {
                        locker.operationEnd();
                    }
                    this.trace(this.detailedTraceLevel, CLEAN_LN, lnClone, logLsn, completed, obsolete, migrated);
                    return bl3;
                }
                ref = location.bin.getEntry(location.index);
                if (!ref.isKnownDeleted()) break block32;
                ++this.nLNsDeadThisRun;
                obsolete = true;
                completed = true;
                boolean bl4 = cleaned;
                Object var24_18 = null;
                this.unPinAndRelease(parentDIN, insPinned);
                this.unPinAndRelease(location.bin, insPinned);
                if (locker != null) {
                    locker.operationEnd();
                }
                this.trace(this.detailedTraceLevel, CLEAN_LN, lnClone, logLsn, completed, obsolete, migrated);
                return bl4;
            }
            IN lnParent = null;
            if (lnIsDupCountLN) {
                parentDIN = (DIN)ref.fetchTarget(db, location.bin);
                parentDIN.latch();
                ref = parentDIN.getDupCountLNRef();
                lnParent = parentDIN;
            } else {
                lnParent = location.bin;
            }
            lnInTree = (LN)ref.fetchTarget(db, lnParent);
            insPinned = true;
            if (lnIsDupCountLN) {
                parentDIN.setEvictionProhibited(true);
                parentDIN.releaseLatch();
            }
            location.bin.setEvictionProhibited(true);
            location.bin.releaseLatch();
            locker = new BasicLocker(this.env);
            locker.setLockTimeout(this.lockTimeout);
            LockGrantType lock = locker.nonBlockingReadLock(lnInTree);
            if (lock != LockGrantType.DENIED) break block33;
            DbLsn abortLsn = locker.getOwnerAbortLsn(lnInTree.getNodeId());
            if (abortLsn != null && abortLsn != DbLsn.NULL_LSN && abortLsn.compareTo(logLsn) > 0) {
                ++this.nLNsDeadThisRun;
                obsolete = true;
            } else {
                ++this.nLNsLockedThisRun;
                cleaned = false;
            }
            completed = true;
            boolean bl5 = cleaned;
            Object var24_19 = null;
            this.unPinAndRelease(parentDIN, insPinned);
            this.unPinAndRelease(location.bin, insPinned);
            if (locker != null) {
                locker.operationEnd();
            }
            this.trace(this.detailedTraceLevel, CLEAN_LN, lnClone, logLsn, completed, obsolete, migrated);
            return bl5;
        }
        try {
            Node n;
            location.bin.latch();
            location.bin.setEvictionProhibited(false);
            ChildReference newRef = location.bin.getEntry(location.index);
            if (lnIsDupCountLN && (n = newRef.fetchTarget(db, location.bin)) instanceof DIN) {
                parentDIN = (DIN)n;
                parentDIN.latch();
                newRef = parentDIN.getDupCountLNRef();
                parentDIN.setEvictionProhibited(false);
            }
            insPinned = false;
            if (newRef.getTarget() == lnInTree) {
                if (lnInTree.isDeleted()) {
                    if (!$assertionsDisabled && lnIsDupCountLN) {
                        throw new AssertionError();
                    }
                    location.bin.setKnownDeletedLeaveTarget(location.index);
                    ++this.nLNsDeadThisRun;
                    obsolete = true;
                } else if (newRef.getLsn().equals(logLsn)) {
                    DbLsn newLNLsn = this.migrateLN(lnInTree, db, key, logLsn, locker);
                    if (lnIsDupCountLN) {
                        parentDIN.updateDupCountLNRef(newLNLsn);
                    } else {
                        location.bin.updateEntry(location.index, newLNLsn);
                    }
                    migrated = true;
                } else {
                    ++this.nLNsDeadThisRun;
                    obsolete = true;
                }
            } else {
                cleaned = false;
            }
            completed = true;
            bl = cleaned;
            Object var24_20 = null;
        }
        catch (DatabaseException DBE) {
            try {
                DBE.printStackTrace();
                Tracer.trace(this.env, "com.sleepycat.je.cleaner.Cleaner", "processLN", "Exception thrown: ", DBE);
                throw DBE;
            }
            catch (Throwable throwable) {
                Object var24_21 = null;
                this.unPinAndRelease(parentDIN, insPinned);
                this.unPinAndRelease(location.bin, insPinned);
                if (locker != null) {
                    locker.operationEnd();
                }
                this.trace(this.detailedTraceLevel, CLEAN_LN, lnClone, logLsn, completed, obsolete, migrated);
                throw throwable;
            }
        }
        this.unPinAndRelease(parentDIN, insPinned);
        this.unPinAndRelease(location.bin, insPinned);
        if (locker != null) {
            locker.operationEnd();
        }
        this.trace(this.detailedTraceLevel, CLEAN_LN, lnClone, logLsn, completed, obsolete, migrated);
        return bl;
    }

    private void unPinAndRelease(IN in, boolean isPinned) throws DatabaseException {
        if (in != null) {
            if (isPinned) {
                if (!in.getLatch().isOwner()) {
                    in.latch();
                }
                in.setEvictionProhibited(false);
                in.releaseLatch();
            } else if (in.getLatch().isOwner()) {
                in.releaseLatch();
            }
        }
    }

    private DbLsn migrateLN(LN ln, DatabaseImpl db, Key key, DbLsn oldLsn, Locker locker) throws DatabaseException {
        DbLsn newLsn = ln.log(this.env, db.getId(), key, oldLsn, locker);
        ++this.nLNsMigratedThisRun;
        return newLsn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processIN(IN inClone, DatabaseImpl db, DbLsn lsn) throws DatabaseException {
        boolean obsolete = false;
        boolean dirtied = false;
        boolean completed = false;
        try {
            if (db == null || db.getIsDeleted()) {
                obsolete = true;
                completed = true;
                return;
            }
            Tree tree = db.getTree();
            if (!$assertionsDisabled && tree == null) {
                throw new AssertionError();
            }
            IN inInTree = this.findINInTree(tree, db, inClone, lsn);
            if (inInTree == null) {
                ++this.nINsCleanedThisRun;
                obsolete = true;
            } else {
                ++this.nINsMigratedThisRun;
                inInTree.setDirty(true);
                inInTree.setCleanedSinceLastLog();
                inInTree.releaseLatch();
                dirtied = true;
            }
            completed = true;
        }
        finally {
            this.trace(this.detailedTraceLevel, CLEAN_IN, inClone, lsn, completed, obsolete, dirtied);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IN findINInTree(Tree tree, DatabaseImpl db, IN inClone, DbLsn lsn) throws DatabaseException {
        IN iN;
        block10: {
            ChildReference ref;
            SearchResult result;
            block8: {
                IN iN2;
                block9: {
                    block6: {
                        IN iN3;
                        block7: {
                            if (inClone.isDbRoot()) {
                                IN rootIN = this.isRoot(tree, db, inClone, lsn);
                                if (rootIN == null) {
                                    return null;
                                }
                                return rootIN;
                            }
                            inClone.latch();
                            result = null;
                            try {
                                result = tree.getParentINForChildIN(inClone, true);
                                if (result.exactParentFound) break block6;
                                iN3 = null;
                                Object var11_9 = null;
                                if (result == null || !result.exactParentFound) break block7;
                            }
                            catch (Throwable throwable) {
                                block11: {
                                    Object var11_12 = null;
                                    if (result == null || !result.exactParentFound) break block11;
                                    result.parent.releaseLatch();
                                }
                                throw throwable;
                            }
                            result.parent.releaseLatch();
                        }
                        return iN3;
                    }
                    ref = result.parent.getEntry(result.index);
                    int compareVal = ref.getLsn().compareTo(lsn);
                    if (compareVal <= 0) break block8;
                    iN2 = null;
                    Object var11_10 = null;
                    if (result == null || !result.exactParentFound) break block9;
                    result.parent.releaseLatch();
                }
                return iN2;
            }
            IN in = (IN)ref.fetchTarget(db, result.parent);
            in.latch();
            iN = in;
            Object var11_11 = null;
            if (result == null || !result.exactParentFound) break block10;
            result.parent.releaseLatch();
        }
        return iN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDelta(CleanerFileReader cleanerReader, DatabaseImpl db, DbLsn lsn) throws DatabaseException {
        IN owningBIN;
        boolean completed;
        boolean dirtied;
        boolean obsolete;
        block11: {
            obsolete = false;
            dirtied = false;
            completed = false;
            owningBIN = null;
            try {
                if (db != null && !db.getIsDeleted()) break block11;
                obsolete = true;
                completed = true;
                ++this.nDeltasCleanedThisRun;
                this.trace(this.detailedTraceLevel, CLEAN_DELTA, owningBIN, lsn, completed, obsolete, dirtied);
                return;
            }
            catch (Throwable throwable) {
                this.trace(this.detailedTraceLevel, CLEAN_DELTA, owningBIN, lsn, completed, obsolete, dirtied);
                throw throwable;
            }
        }
        IN reconstructed = null;
        try {
            reconstructed = cleanerReader.getReconstructedIN();
        }
        catch (LogFileNotFoundException e) {
            obsolete = true;
            completed = true;
            ++this.nDeltasCleanedThisRun;
            this.trace(this.detailedTraceLevel, CLEAN_DELTA, owningBIN, lsn, completed, obsolete, dirtied);
            return;
        }
        if (reconstructed == null) {
            obsolete = true;
        } else {
            Tree tree = db.getTree();
            if (!$assertionsDisabled && tree == null) {
                throw new AssertionError();
            }
            owningBIN = this.findDeltaInTree(tree, db, reconstructed, lsn);
            if (owningBIN == null) {
                obsolete = true;
            } else {
                ++this.nINsMigratedThisRun;
                owningBIN.setDirty(true);
                owningBIN.releaseLatch();
                dirtied = true;
            }
        }
        ++this.nDeltasCleanedThisRun;
        completed = true;
        this.trace(this.detailedTraceLevel, CLEAN_DELTA, owningBIN, lsn, completed, obsolete, dirtied);
    }

    private IN findDeltaInTree(Tree tree, DatabaseImpl db, IN reconstructed, DbLsn lsn) throws DatabaseException {
        reconstructed.latch();
        SearchResult result = tree.getParentINForChildIN(reconstructed, true);
        if (!result.exactParentFound) {
            return null;
        }
        BIN binInTree = (BIN)result.parent.getEntry(result.index).fetchTarget(db, result.parent);
        binInTree.latch();
        result.parent.releaseLatch();
        DbLsn lastDeltaLsn = binInTree.getLastDeltaVersion();
        if (lastDeltaLsn != null && lastDeltaLsn.compareTo(lsn) <= 0) {
            return binInTree;
        }
        binInTree.releaseLatch();
        return null;
    }

    private IN isRoot(Tree tree, DatabaseImpl db, IN inClone, DbLsn lsn) throws DatabaseException {
        RootDoWork rdw = new RootDoWork(db, inClone, lsn);
        return tree.withRootLatched(rdw);
    }

    private void resetPerRunCounters() {
        this.nINsCleanedThisRun = 0;
        this.nINsMigratedThisRun = 0;
        this.nLNsCleanedThisRun = 0;
        this.nLNsDeadThisRun = 0;
        this.nLNsMigratedThisRun = 0;
        this.nLNsLockedThisRun = 0;
        this.nDeltasCleanedThisRun = 0;
        this.nEntriesReadThisRun = 0;
        this.nRepeatIteratorReadsThisRun = 0L;
    }

    private void accumulatePerRunCounters() {
        this.nINsCleaned += this.nINsCleanedThisRun;
        this.nINsMigrated += this.nINsMigratedThisRun;
        this.nLNsCleaned += this.nLNsCleanedThisRun;
        this.nLNsDead += this.nLNsDeadThisRun;
        this.nLNsMigrated += this.nLNsMigratedThisRun;
        this.nLNsLocked += this.nLNsLockedThisRun;
        this.nDeltasCleaned += this.nDeltasCleanedThisRun;
        this.nRepeatIteratorReads += this.nRepeatIteratorReadsThisRun;
    }

    private void trace(Level level, String action, Node node, DbLsn logLsn, boolean completed, boolean obsolete, boolean dirtiedMigrated) {
        Logger logger = this.env.getLogger();
        if (logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(action);
            if (node != null) {
                sb.append(" node=");
                sb.append(node.getNodeId());
            }
            sb.append(" logLsn=");
            sb.append(logLsn.getNoFormatString());
            sb.append(" complete=").append(completed);
            sb.append(" obsolete=").append(obsolete);
            sb.append(" dirtiedOrMigrated=").append(dirtiedMigrated);
            logger.log(level, sb.toString());
        }
    }

    static {
        $assertionsDisabled = !Cleaner.class.desiredAssertionStatus();
    }

    private static class RootDoWork
    implements WithRootLatched {
        private DatabaseImpl db;
        private IN inClone;
        private DbLsn lsn;

        RootDoWork(DatabaseImpl db, IN inClone, DbLsn lsn) {
            this.db = db;
            this.inClone = inClone;
            this.lsn = lsn;
        }

        public IN doWork(ChildReference root) throws DatabaseException {
            if (root == null || ((IN)root.fetchTarget(this.db, null)).getNodeId() != this.inClone.getNodeId()) {
                return null;
            }
            if (root.getLsn().compareTo(this.lsn) <= 0) {
                IN rootIN = (IN)root.fetchTarget(this.db, null);
                rootIN.latch();
                return rootIN;
            }
            return null;
        }
    }
}

