/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.LockNotGrantedException;
import com.sleepycat.je.LockStats;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.BINReference;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.Lock;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockManager;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.TxnManager;
import com.sleepycat.je.utilint.DbLsn;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class Locker {
    private static final String DEBUG_NAME = Locker.class.getName();
    protected EnvironmentImpl envImpl;
    protected LockManager lockManager;
    protected long id;
    private String name;
    private boolean dirtyReadDefault;
    protected boolean defaultNoWait;
    protected long lockTimeOutMillis;
    private long txnTimeOutMillis;
    private long txnStartMillis;
    private Lock waitingFor;
    protected Map deleteInfo;
    protected Map handleLockToHandleMap;
    protected Map handleToHandleLockMap;

    public Locker(EnvironmentImpl envImpl, boolean dirtyReadDefault, boolean noWait) throws DatabaseException {
        TxnManager txnManager = envImpl.getTxnManager();
        this.id = this.generateId(txnManager);
        this.envImpl = envImpl;
        this.lockManager = txnManager.getLockManager();
        this.dirtyReadDefault = dirtyReadDefault;
        this.waitingFor = null;
        this.defaultNoWait = noWait;
        this.lockTimeOutMillis = envImpl.getLockTimeout();
        this.txnTimeOutMillis = envImpl.getTxnTimeout();
        this.txnStartMillis = this.txnTimeOutMillis != 0L ? System.currentTimeMillis() : 0L;
        this.name = Thread.currentThread().getName();
    }

    Locker() {
    }

    protected abstract long generateId(TxnManager var1);

    public long getId() {
        return this.id;
    }

    public synchronized long getLockTimeout() {
        return this.lockTimeOutMillis;
    }

    public synchronized void setLockTimeout(long timeOutMillis) {
        this.lockTimeOutMillis = timeOutMillis;
    }

    public synchronized void setTxnTimeout(long timeOutMillis) {
        this.txnTimeOutMillis = timeOutMillis;
        this.txnStartMillis = System.currentTimeMillis();
    }

    public boolean isDirtyReadDefault() {
        return this.dirtyReadDefault;
    }

    Lock getWaitingFor() {
        return this.waitingFor;
    }

    void setWaitingFor(Lock lock) {
        this.waitingFor = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockGrantType readLock(LN ln) throws DatabaseException {
        long timeout;
        Locker locker = this;
        synchronized (locker) {
            timeout = this.lockTimeOutMillis;
        }
        long nodeId = ln.getNodeId();
        return this.lockManager.lock(nodeId, this, LockType.READ, timeout, this.defaultNoWait);
    }

    public LockGrantType nonBlockingReadLock(LN ln) throws DatabaseException {
        long nodeId = ln.getNodeId();
        try {
            return this.lockManager.lock(nodeId, this, LockType.READ, 0L, true);
        }
        catch (LockNotGrantedException e) {
            return LockGrantType.DENIED;
        }
    }

    public abstract LockResult writeLock(LN var1, DatabaseImpl var2) throws DatabaseException;

    public void releaseLock(LN ln) throws DatabaseException {
        this.lockManager.release(ln.getNodeId(), this);
    }

    public void demoteLock(long nodeId) throws DatabaseException {
        this.lockManager.demote(nodeId, this);
    }

    public abstract boolean isTransactional();

    public abstract Locker newInstance() throws DatabaseException;

    public abstract boolean sharesLocksWith(Locker var1);

    public abstract void operationEnd() throws DatabaseException;

    public abstract void operationEnd(boolean var1) throws DatabaseException;

    public abstract void setHandleLockOwner(boolean var1, Database var2, boolean var3) throws DatabaseException;

    public void operationEnd(OperationStatus status) throws DatabaseException {
        this.operationEnd(status == OperationStatus.SUCCESS);
    }

    public abstract void registerCursor(CursorImpl var1) throws DatabaseException;

    public abstract void unRegisterCursor(CursorImpl var1) throws DatabaseException;

    public abstract DbLsn getAbortLsn(long var1) throws DatabaseException;

    public abstract boolean getAbortKnownDeleted(long var1) throws DatabaseException;

    public abstract void setIsDeletedAtCommit(DatabaseImpl var1) throws DatabaseException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeleteInfo(BIN bin, Key deletedKey) throws DatabaseException {
        Locker locker = this;
        synchronized (locker) {
            Long nodeId;
            BINReference binRef;
            if (this.deleteInfo == null) {
                this.deleteInfo = new HashMap();
            }
            if ((binRef = (BINReference)this.deleteInfo.get(nodeId = new Long(bin.getNodeId()))) == null) {
                binRef = bin.createReference();
                this.deleteInfo.put(nodeId, binRef);
            }
            binRef.addDeletedKey(deletedKey);
        }
    }

    abstract void addLock(long var1, Lock var3, LockType var4, LockGrantType var5) throws DatabaseException;

    public abstract boolean createdNode(long var1) throws DatabaseException;

    abstract void removeLock(long var1, Lock var3) throws DatabaseException;

    abstract void moveWriteToReadLock(long var1, Lock var3) throws DatabaseException;

    public abstract LockStats collectStats(LockStats var1) throws DatabaseException;

    boolean isTimedOut() throws DatabaseException {
        long diff;
        return this.txnStartMillis != 0L && (diff = System.currentTimeMillis() - this.txnStartMillis) > this.txnTimeOutMillis;
    }

    long getTxnTimeOut() {
        return this.txnTimeOutMillis;
    }

    long getTxnStartMillis() {
        return this.txnStartMillis;
    }

    void unregisterHandle(Database dbHandle) {
        if (this.handleToHandleLockMap != null) {
            this.handleToHandleLockMap.remove(dbHandle);
        }
    }

    public void addToHandleMaps(Long handleLockId, Database databaseHandle) {
        HashSet<Database> dbHandleSet = null;
        if (this.handleLockToHandleMap == null) {
            this.handleLockToHandleMap = new Hashtable();
            this.handleToHandleLockMap = new Hashtable();
        } else {
            dbHandleSet = (HashSet<Database>)this.handleLockToHandleMap.get(handleLockId);
        }
        if (dbHandleSet == null) {
            dbHandleSet = new HashSet<Database>();
            this.handleLockToHandleMap.put(handleLockId, dbHandleSet);
        }
        dbHandleSet.add(databaseHandle);
        this.handleToHandleLockMap.put(databaseHandle, handleLockId);
    }

    public boolean isHandleLockTransferrable() {
        return true;
    }

    void transferHandleLockToHandle(Database dbHandle) throws DatabaseException {
        BasicLocker holderTxn = new BasicLocker(this.envImpl);
        this.transferHandleLock(dbHandle, holderTxn, true);
    }

    public void transferHandleLock(Database dbHandle, Locker destLocker, boolean demoteToRead) throws DatabaseException {
        Long handleLockId;
        if (DbInternal.dbGetDatabaseImpl(dbHandle) != null && (handleLockId = (Long)this.handleToHandleLockMap.get(dbHandle)) != null) {
            long nodeId = handleLockId;
            this.rememberHandleWriteLock(handleLockId);
            this.lockManager.transfer(nodeId, this, destLocker, demoteToRead);
            destLocker.addToHandleMaps(handleLockId, dbHandle);
            Set dbHandleSet = (Set)this.handleLockToHandleMap.get(handleLockId);
            Iterator iter = dbHandleSet.iterator();
            while (iter.hasNext()) {
                if ((Database)iter.next() != dbHandle) continue;
                iter.remove();
                break;
            }
            if (dbHandleSet.size() == 0) {
                this.handleLockToHandleMap.remove(handleLockId);
            }
            DbInternal.dbSetHandleLocker(dbHandle, destLocker);
        }
    }

    protected void rememberHandleWriteLock(Long lockId) {
    }

    public String toString() {
        return Long.toString(this.id) + "_" + this.name;
    }

    public void dumpLockTable() throws DatabaseException {
        this.lockManager.dump();
    }

    public String getName() {
        return this.name;
    }
}

