/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.log.LogReadable;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.LogWritable;
import com.sleepycat.je.tree.TreeUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class DbLsn
implements Comparable,
LogWritable,
LogReadable {
    static final long INT_MASK = 0xFFFFFFFFL;
    private long lsn;
    public static final DbLsn NULL_LSN = new DbLsn(-1L, 0L);

    public DbLsn() {
        this.lsn = -1L;
    }

    public DbLsn(long fileNumber, long fileOffset) {
        this.lsn = fileOffset & 0xFFFFFFFFL | (fileNumber & 0xFFFFFFFFL) << 32;
    }

    public long getFileNumber() {
        return this.lsn >> 32 & 0xFFFFFFFFL;
    }

    public long getFileOffset() {
        return this.lsn & 0xFFFFFFFFL;
    }

    private int compareLong(long l1, long l2) {
        if (l1 < l2) {
            return -1;
        }
        if (l1 > l2) {
            return 1;
        }
        return 0;
    }

    public int compareTo(Object o) {
        long thisFileNumber;
        if (o == null || o.equals(NULL_LSN) || this.equals(NULL_LSN)) {
            throw new NullPointerException();
        }
        DbLsn argLsn = (DbLsn)o;
        long argFileNumber = argLsn.getFileNumber();
        if (argFileNumber == (thisFileNumber = this.getFileNumber())) {
            return this.compareLong(this.getFileOffset(), argLsn.getFileOffset());
        }
        return this.compareLong(thisFileNumber, argFileNumber);
    }

    public String toString() {
        return "<DbLsn val=\"0x" + Long.toHexString(this.getFileNumber()) + "/0x" + Long.toHexString(this.getFileOffset()) + "\"/>";
    }

    public String getNoFormatString() {
        return "0x" + Long.toHexString(this.getFileNumber()) + "/0x" + Long.toHexString(this.getFileOffset());
    }

    public String dumpString(int nSpaces) {
        StringBuffer sb = new StringBuffer();
        sb.append(TreeUtils.indent(nSpaces));
        sb.append(this.toString());
        return sb.toString();
    }

    public int hashCode() {
        return new Long(this.lsn).hashCode();
    }

    public long getNoCleaningDistance(DbLsn other, long logFileSize) {
        long otherFile;
        long diff = 0L;
        long myFile = this.getFileNumber();
        if (other == null) {
            other = new DbLsn(0L, 0L);
        }
        diff = myFile == (otherFile = other.getFileNumber()) ? Math.abs(this.getFileOffset() - other.getFileOffset()) : (myFile > otherFile ? this.calcDiff(myFile - otherFile, logFileSize, this, other) : this.calcDiff(otherFile - myFile, logFileSize, other, this));
        return diff;
    }

    public long getWithCleaningDistance(FileManager fileManager, DbLsn other, long logFileSize) {
        int otherFileIdx;
        Object[] fileNums;
        int myFileIdx;
        long otherFile;
        long diff = 0L;
        long myFile = this.getFileNumber();
        if (other == null) {
            other = new DbLsn(0L, 0L);
        }
        diff = myFile == (otherFile = other.getFileNumber()) ? Math.abs(this.getFileOffset() - other.getFileOffset()) : ((myFileIdx = Arrays.binarySearch(fileNums = fileManager.getAllFileNumbers(), new Long(myFile))) > (otherFileIdx = Arrays.binarySearch(fileNums, new Long(otherFile))) ? this.calcDiff(myFileIdx - otherFileIdx, logFileSize, this, other) : this.calcDiff(otherFileIdx - myFileIdx, logFileSize, other, this));
        return diff;
    }

    private long calcDiff(long fileDistance, long logFileSize, DbLsn laterLsn, DbLsn earlierLsn) {
        long diff = fileDistance * logFileSize;
        diff += laterLsn.getFileOffset();
        return diff -= earlierLsn.getFileOffset();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DbLsn)) {
            return false;
        }
        return this.lsn == ((DbLsn)obj).lsn;
    }

    public int getLogSize() {
        return LogUtils.getLongLogSize();
    }

    public void writeToLog(ByteBuffer logBuffer) {
        LogUtils.writeLong(logBuffer, this.lsn);
    }

    public void readFromLog(ByteBuffer itemBuffer) {
        this.lsn = LogUtils.readLong(itemBuffer);
    }

    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append(this.toString());
    }

    public boolean logEntryIsTransactional() {
        return false;
    }

    public long getTransactionId() {
        return 0L;
    }
}

