/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.contrib.palette;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.tapestry.BaseComponent;
import net.sf.tapestry.IAsset;
import net.sf.tapestry.IComponent;
import net.sf.tapestry.IEngine;
import net.sf.tapestry.IForm;
import net.sf.tapestry.IMarkupWriter;
import net.sf.tapestry.IRender;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.IScript;
import net.sf.tapestry.IScriptSource;
import net.sf.tapestry.RequestContext;
import net.sf.tapestry.RequestCycleException;
import net.sf.tapestry.ScriptException;
import net.sf.tapestry.ScriptSession;
import net.sf.tapestry.components.Block;
import net.sf.tapestry.contrib.palette.SortMode;
import net.sf.tapestry.form.Form;
import net.sf.tapestry.form.FormEventType;
import net.sf.tapestry.form.IFormComponent;
import net.sf.tapestry.form.IPropertySelectionModel;
import net.sf.tapestry.html.Body;

public class Palette
extends BaseComponent
implements IFormComponent {
    private static final int DEFAULT_ROWS = 10;
    private static final int MAP_SIZE = 7;
    private static final String DEFAULT_TABLE_CLASS = "tapestry-palette";
    private List _selected;
    private IPropertySelectionModel _model;
    private SortMode _sort = SortMode.NONE;
    private int _rows = 10;
    private String _tableClass = "tapestry-palette";
    private Block _selectedTitleBlock;
    private Block _availableTitleBlock;
    private IAsset _selectImage;
    private IAsset _selectDisabledImage;
    private IAsset _deselectImage;
    private IAsset _deselectDisabledImage;
    private IAsset _upImage;
    private IAsset _upDisabledImage;
    private IAsset _downImage;
    private IAsset _downDisabledImage;
    private IForm _form;
    private String _name;
    private Map _symbols;
    private IMarkupWriter _availableWriter;
    private IMarkupWriter _selectedWriter;
    private IScript _script;

    public void finishLoad() {
        this._selectedTitleBlock = (Block)this.getComponent("defaultSelectedTitleBlock");
        this._availableTitleBlock = (Block)this.getComponent("defaultAvailableTitleBlock");
        this._selectImage = this.getAsset("Select");
        this._selectDisabledImage = this.getAsset("SelectDisabled");
        this._deselectImage = this.getAsset("Deselect");
        this._deselectDisabledImage = this.getAsset("DeselectDisabled");
        this._upImage = this.getAsset("Up");
        this._upDisabledImage = this.getAsset("UpDisabled");
        this._downImage = this.getAsset("Down");
        this._downDisabledImage = this.getAsset("DownDisabled");
    }

    public String getName() {
        return this._name;
    }

    public IForm getForm() {
        return this._form;
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
        this._form = Form.get((IRequestCycle)this.getPage().getRequestCycle());
        if (this._form == null) {
            throw new RequestCycleException("Palette component must be wrapped by a Form.", (IComponent)this);
        }
        this._name = this._form.getElementId((IComponent)this);
        if (this._form.isRewinding()) {
            this.handleSubmission(cycle);
            return;
        }
        if (cycle.isRewinding()) {
            return;
        }
        String formName = this._form.getName();
        this._symbols = new HashMap(7);
        this.runScript(cycle);
        this._form.addEventHandler(FormEventType.SUBMIT, (String)this._symbols.get("formSubmitFunctionName"));
        this.bufferSelects(writer);
        super.renderComponent(writer, cycle);
    }

    protected void cleanupAfterRender(IRequestCycle cycle) {
        this._availableWriter = null;
        this._selectedWriter = null;
        this._form = null;
        this._symbols = null;
        super.cleanupAfterRender(cycle);
    }

    private void runScript(IRequestCycle cycle) throws RequestCycleException {
        ScriptSession session;
        Body body;
        if (this._script == null) {
            IEngine engine = this.getPage().getEngine();
            IScriptSource source = engine.getScriptSource();
            this._script = source.getScript("/net/sf/tapestry/contrib/palette/Palette.script");
        }
        if ((body = Body.get((IRequestCycle)cycle)) == null) {
            throw new RequestCycleException("Palette component must be wrapped by a Body.", (IComponent)this);
        }
        this.setImage(body, cycle, "selectImage", this._selectImage);
        this.setImage(body, cycle, "selectDisabledImage", this._selectDisabledImage);
        this.setImage(body, cycle, "deselectImage", this._deselectImage);
        this.setImage(body, cycle, "deselectDisabledImage", this._deselectDisabledImage);
        if (this._sort == SortMode.USER) {
            this.setImage(body, cycle, "upImage", this._upImage);
            this.setImage(body, cycle, "upDisabledImage", this._upDisabledImage);
            this.setImage(body, cycle, "downImage", this._downImage);
            this.setImage(body, cycle, "downDisabledImage", this._downDisabledImage);
        }
        this._symbols.put("palette", this);
        try {
            session = this._script.execute(this._symbols);
        }
        catch (ScriptException ex) {
            throw new RequestCycleException((IComponent)this, (Throwable)ex);
        }
        body.process(session);
    }

    private void setImage(Body body, IRequestCycle cycle, String symbolName, IAsset asset) {
        String URL2 = asset.buildURL(cycle);
        String reference = body.getPreloadedImageReference(URL2);
        this._symbols.put(symbolName, reference);
    }

    public Map getSymbols() {
        return this._symbols;
    }

    private void bufferSelects(IMarkupWriter writer) {
        Set selectedSet = this._selected == null ? Collections.EMPTY_SET : new HashSet(this._selected);
        this._selectedWriter = writer.getNestedWriter();
        this._availableWriter = writer.getNestedWriter();
        this._selectedWriter.begin("select");
        this._selectedWriter.attribute("multiple");
        this._selectedWriter.attribute("size", this._rows);
        this._selectedWriter.attribute("name", this._name);
        this._selectedWriter.println();
        this._availableWriter.begin("select");
        this._availableWriter.attribute("multiple");
        this._availableWriter.attribute("size", this._rows);
        this._availableWriter.attribute("name", (String)this._symbols.get("availableName"));
        this._availableWriter.println();
        int count = this._model.getOptionCount();
        int i = 0;
        while (i < count) {
            IMarkupWriter w = this._availableWriter;
            Object optionValue = this._model.getOption(i);
            if (selectedSet.contains(optionValue)) {
                w = this._selectedWriter;
            }
            w.beginEmpty("option");
            w.attribute("value", this._model.getValue(i));
            w.print(this._model.getLabel(i));
            w.println();
            ++i;
        }
        this._selectedWriter.end();
        this._availableWriter.end();
    }

    public IRender getAvailableSelectDelegate() {
        return new IRender(){

            public void render(IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
                Palette.this._availableWriter.close();
                Palette.this._availableWriter = null;
            }
        };
    }

    public IRender getSelectedSelectDelegate() {
        return new IRender(){

            public void render(IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
                Palette.this._selectedWriter.close();
                Palette.this._selectedWriter = null;
            }
        };
    }

    private void handleSubmission(IRequestCycle cycle) throws RequestCycleException {
        RequestContext context = cycle.getRequestContext();
        String[] values = context.getParameters(this._name);
        if (values == null || values.length == 0) {
            return;
        }
        this._selected = new ArrayList(values.length);
        int i = 0;
        while (i < values.length) {
            String value = values[i];
            Object option = this._model.translateValue(value);
            this._selected.add(option);
            ++i;
        }
    }

    public boolean isSortUser() {
        return this._sort == SortMode.USER;
    }

    public String getDisplayName() {
        return null;
    }

    public Block getAvailableTitleBlock() {
        return this._availableTitleBlock;
    }

    public void setAvailableTitleBlock(Block availableTitleBlock) {
        this._availableTitleBlock = availableTitleBlock;
    }

    public IAsset getDeselectDisabledImage() {
        return this._deselectDisabledImage;
    }

    public void setDeselectDisabledImage(IAsset deselectDisabledImage) {
        this._deselectDisabledImage = deselectDisabledImage;
    }

    public IAsset getDeselectImage() {
        return this._deselectImage;
    }

    public void setDeselectImage(IAsset deselectImage) {
        this._deselectImage = deselectImage;
    }

    public IAsset getDownDisabledImage() {
        return this._downDisabledImage;
    }

    public void setDownDisabledImage(IAsset downDisabledImage) {
        this._downDisabledImage = downDisabledImage;
    }

    public IAsset getDownImage() {
        return this._downImage;
    }

    public void setDownImage(IAsset downImage) {
        this._downImage = downImage;
    }

    public IPropertySelectionModel getModel() {
        return this._model;
    }

    public void setModel(IPropertySelectionModel model) {
        this._model = model;
    }

    public int getRows() {
        return this._rows;
    }

    public void setRows(int rows) {
        this._rows = rows;
    }

    public IAsset getSelectDisabledImage() {
        return this._selectDisabledImage;
    }

    public void setSelectDisabledImage(IAsset selectDisabledImage) {
        this._selectDisabledImage = selectDisabledImage;
    }

    public Block getSelectedTitleBlock() {
        return this._selectedTitleBlock;
    }

    public void setSelectedTitleBlock(Block selectedTitleBlock) {
        this._selectedTitleBlock = selectedTitleBlock;
    }

    public IAsset getSelectImage() {
        return this._selectImage;
    }

    public void setSelectImage(IAsset selectImage) {
        this._selectImage = selectImage;
    }

    public SortMode getSort() {
        return this._sort;
    }

    public void setSort(SortMode sort) {
        this._sort = sort;
    }

    public String getTableClass() {
        return this._tableClass;
    }

    public void setTableClass(String tableClass) {
        this._tableClass = tableClass;
    }

    public IAsset getUpDisabledImage() {
        return this._upDisabledImage;
    }

    public void setUpDisabledImage(IAsset upDisabledImage) {
        this._upDisabledImage = upDisabledImage;
    }

    public IAsset getUpImage() {
        return this._upImage;
    }

    public void setUpImage(IAsset upImage) {
        this._upImage = upImage;
    }

    public boolean isDisabled() {
        return false;
    }

    public List getSelected() {
        return this._selected;
    }

    public void setSelected(List selected) {
        this._selected = selected;
    }
}

