/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.contrib.table.components;

import net.sf.tapestry.ComponentAddress;
import net.sf.tapestry.IBinding;
import net.sf.tapestry.IComponent;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.RequestCycleException;
import net.sf.tapestry.contrib.table.components.AbstractTableViewComponent;
import net.sf.tapestry.contrib.table.model.ITableModelSource;

public class TablePages
extends AbstractTableViewComponent {
    private static final int DEFAULT_PAGE_COUNT = 7;
    private IBinding m_objPagesDisplayedBinding = null;
    private int m_nDisplayPage;

    public IBinding getPagesDisplayedBinding() {
        return this.m_objPagesDisplayedBinding;
    }

    public void setPagesDisplayedBinding(IBinding PagesDisplayedBinding) {
        this.m_objPagesDisplayedBinding = PagesDisplayedBinding;
    }

    public int getPagesDisplayed() {
        IBinding objBinding = this.getPagesDisplayedBinding();
        if (objBinding == null || objBinding.getObject() == null) {
            return 7;
        }
        return objBinding.getInt();
    }

    public int getDisplayPage() {
        return this.m_nDisplayPage;
    }

    public void setDisplayPage(int displayPage) {
        this.m_nDisplayPage = displayPage;
    }

    public int getCurrentPage() throws RequestCycleException {
        return this.getTableModelSource().getTableModel().getPagingState().getCurrentPage() + 1;
    }

    public int getPageCount() throws RequestCycleException {
        return this.getTableModelSource().getTableModel().getPageCount();
    }

    public boolean getCondBack() throws RequestCycleException {
        return this.getCurrentPage() > 1;
    }

    public boolean getCondFwd() throws RequestCycleException {
        return this.getCurrentPage() < this.getPageCount();
    }

    public boolean getCondCurrent() throws RequestCycleException {
        return this.getDisplayPage() == this.getCurrentPage();
    }

    public int getStartPage() throws RequestCycleException {
        int nFirstPage;
        int nLeftMargin;
        int nStart;
        int nCurrent = this.getCurrentPage();
        int nPagesDisplayed = this.getPagesDisplayed();
        int nRightMargin = nPagesDisplayed / 2;
        int nStop = nCurrent + nRightMargin;
        int nLastPage = this.getPageCount();
        int nLeftAddon = 0;
        if (nStop > nLastPage) {
            nLeftAddon = nStop - nLastPage;
        }
        if ((nStart = nCurrent - (nLeftMargin = (nPagesDisplayed - 1) / 2 + nLeftAddon)) < (nFirstPage = 1)) {
            nStart = nFirstPage;
        }
        return nStart;
    }

    public int getStopPage() throws RequestCycleException {
        int nLastPage;
        int nRightMargin;
        int nStop;
        int nCurrent = this.getCurrentPage();
        int nPagesDisplayed = this.getPagesDisplayed();
        int nLeftMargin = (nPagesDisplayed - 1) / 2;
        int nStart = nCurrent - nLeftMargin;
        int nFirstPage = 1;
        int nRightAddon = 0;
        if (nStart < nFirstPage) {
            nRightAddon = nFirstPage - nStart;
        }
        if ((nStop = nCurrent + (nRightMargin = nPagesDisplayed / 2 + nRightAddon)) > (nLastPage = this.getPageCount())) {
            nStop = nLastPage;
        }
        return nStop;
    }

    public Integer[] getPageList() throws RequestCycleException {
        int nStart = this.getStartPage();
        int nStop = this.getStopPage();
        Integer[] arrPages = new Integer[nStop - nStart + 1];
        int i = nStart;
        while (i <= nStop) {
            arrPages[i - nStart] = new Integer(i);
            ++i;
        }
        return arrPages;
    }

    public Object[] getFirstPageContext() throws RequestCycleException {
        ComponentAddress objAddress = new ComponentAddress((IComponent)this.getTableModelSource());
        return new Object[]{objAddress, new Integer(1)};
    }

    public Object[] getLastPageContext() throws RequestCycleException {
        ComponentAddress objAddress = new ComponentAddress((IComponent)this.getTableModelSource());
        return new Object[]{objAddress, new Integer(this.getPageCount())};
    }

    public Object[] getBackPageContext() throws RequestCycleException {
        ComponentAddress objAddress = new ComponentAddress((IComponent)this.getTableModelSource());
        return new Object[]{objAddress, new Integer(this.getCurrentPage() - 1)};
    }

    public Object[] getFwdPageContext() throws RequestCycleException {
        ComponentAddress objAddress = new ComponentAddress((IComponent)this.getTableModelSource());
        return new Object[]{objAddress, new Integer(this.getCurrentPage() + 1)};
    }

    public Object[] getDisplayPageContext() throws RequestCycleException {
        ComponentAddress objAddress = new ComponentAddress((IComponent)this.getTableModelSource());
        return new Object[]{objAddress, new Integer(this.m_nDisplayPage)};
    }

    public void changePage(IRequestCycle objCycle) throws RequestCycleException {
        Object[] arrParameters = objCycle.getServiceParameters();
        if (arrParameters.length != 2 && !(arrParameters[0] instanceof ComponentAddress) && !(arrParameters[1] instanceof Integer)) {
            return;
        }
        ComponentAddress objAddress = (ComponentAddress)arrParameters[0];
        ITableModelSource objSource = (ITableModelSource)objAddress.findComponent(objCycle);
        this.setCurrentPage(objSource, (Integer)arrParameters[1]);
        objSource.fireObservedStateChange();
    }

    public void setCurrentPage(ITableModelSource objSource, int nPage) throws RequestCycleException {
        objSource.getTableModel().getPagingState().setCurrentPage(nPage - 1);
    }
}

