/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.contrib.table.components;

import java.io.Serializable;
import net.sf.tapestry.BaseComponent;
import net.sf.tapestry.IBinding;
import net.sf.tapestry.IMarkupWriter;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.RequestCycleException;
import net.sf.tapestry.contrib.table.model.ITableModel;
import net.sf.tapestry.contrib.table.model.ITableModelSource;
import net.sf.tapestry.contrib.table.model.ITableSessionStateManager;
import net.sf.tapestry.contrib.table.model.ITableSessionStoreManager;
import net.sf.tapestry.contrib.table.model.common.FullTableSessionStateManager;
import net.sf.tapestry.event.PageDetachListener;
import net.sf.tapestry.event.PageEvent;
import net.sf.tapestry.event.PageRenderListener;

public class TableView
extends BaseComponent
implements PageDetachListener,
PageRenderListener,
ITableModelSource {
    private static ITableSessionStateManager DEFAULT_SESSION_STATE_MANAGER = new FullTableSessionStateManager();
    private IBinding m_objTableModelBinding = null;
    private IBinding m_objTableSessionStateManagerBinding = null;
    private IBinding m_objTableSessionStoreManagerBinding = null;
    private IBinding m_objElementBinding = null;
    private Serializable m_objSessionState;
    private ITableModel m_objTableModel;

    public TableView() {
        this.init();
    }

    public void pageDetached(PageEvent objEvent) {
        this.init();
    }

    private void init() {
        this.m_objSessionState = null;
        this.m_objTableModel = null;
    }

    protected void finishLoad() {
        super.finishLoad();
        this.getPage().addPageDetachListener((PageDetachListener)this);
        this.getPage().addPageRenderListener((PageRenderListener)this);
    }

    public void reset() {
        this.m_objTableModel = null;
        this.storeSessionState(null);
    }

    public IBinding getTableModelBinding() {
        return this.m_objTableModelBinding;
    }

    public void setTableModelBinding(IBinding tableModelBinding) {
        this.m_objTableModelBinding = tableModelBinding;
    }

    public ITableModel getTableModel() {
        if (this.m_objTableModel == null) {
            Serializable objState = this.loadSessionState();
            this.m_objTableModel = this.getTableSessionStateManager().recreateTableModel(objState);
        }
        if (this.m_objTableModel == null) {
            IBinding objBinding = this.getTableModelBinding();
            this.m_objTableModel = (ITableModel)objBinding.getObject();
        }
        return this.m_objTableModel;
    }

    public void fireObservedStateChange() {
        this.saveSessionState();
    }

    public IBinding getTableSessionStateManagerBinding() {
        return this.m_objTableSessionStateManagerBinding;
    }

    public void setTableSessionStateManagerBinding(IBinding tableSessionStateManagerBinding) {
        this.m_objTableSessionStateManagerBinding = tableSessionStateManagerBinding;
    }

    public ITableSessionStateManager getTableSessionStateManager() {
        IBinding objBinding = this.getTableSessionStateManagerBinding();
        if (objBinding == null || objBinding.getObject() == null) {
            return DEFAULT_SESSION_STATE_MANAGER;
        }
        return (ITableSessionStateManager)objBinding.getObject();
    }

    public IBinding getTableSessionStoreManagerBinding() {
        return this.m_objTableSessionStoreManagerBinding;
    }

    public void setTableSessionStoreManagerBinding(IBinding tableSessionStoreManagerBinding) {
        this.m_objTableSessionStoreManagerBinding = tableSessionStoreManagerBinding;
    }

    public ITableSessionStoreManager getTableSessionStoreManager() {
        IBinding objBinding = this.getTableSessionStoreManagerBinding();
        if (objBinding == null) {
            return null;
        }
        return (ITableSessionStoreManager)objBinding.getObject();
    }

    public Serializable getSessionState() {
        return this.m_objSessionState;
    }

    public void setSessionState(Serializable sessionState) {
        this.m_objSessionState = sessionState;
    }

    public void updateSessionState(Serializable sessionState) {
        this.setSessionState(sessionState);
        this.fireObservedChange("sessionState", sessionState);
    }

    protected Serializable loadSessionState() {
        ITableSessionStoreManager objManager = this.getTableSessionStoreManager();
        if (objManager != null) {
            return objManager.loadState(this.getPage().getRequestCycle());
        }
        return this.getSessionState();
    }

    protected void saveSessionState() {
        ITableModel objModel = this.getTableModel();
        Serializable objState = this.getTableSessionStateManager().getSessionState(objModel);
        this.storeSessionState(objState);
    }

    protected void storeSessionState(Serializable objState) {
        ITableSessionStoreManager objManager = this.getTableSessionStoreManager();
        if (objManager != null) {
            objManager.saveState(this.getPage().getRequestCycle(), objState);
        } else {
            this.updateSessionState(objState);
        }
    }

    public void pageBeginRender(PageEvent objEvent) {
        if (objEvent.getRequestCycle().isRewinding()) {
            return;
        }
        this.saveSessionState();
    }

    public void pageEndRender(PageEvent objEvent) {
    }

    public IBinding getElementBinding() {
        return this.m_objElementBinding;
    }

    public void setElementBinding(IBinding elementBinding) {
        this.m_objElementBinding = elementBinding;
    }

    public String getElement() {
        IBinding objElementBinding = this.getElementBinding();
        if (objElementBinding == null || objElementBinding.getObject() == null) {
            return "table";
        }
        return objElementBinding.getString();
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
        Object objOldValue = cycle.getAttribute("net.sf.tapestry.contrib.table.model.ITableModelSource");
        cycle.setAttribute("net.sf.tapestry.contrib.table.model.ITableModelSource", (Object)this);
        super.renderComponent(writer, cycle);
        cycle.setAttribute("net.sf.tapestry.contrib.table.model.ITableModelSource", objOldValue);
    }
}

