/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.contrib.table.model.simple;

import java.io.Serializable;
import java.util.Comparator;
import net.sf.tapestry.INamespace;
import net.sf.tapestry.IPage;
import net.sf.tapestry.IRender;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.contrib.table.model.ITableColumn;
import net.sf.tapestry.contrib.table.model.ITableModelSource;
import net.sf.tapestry.contrib.table.model.simple.ISimpleTableColumnRenderer;
import net.sf.tapestry.valid.RenderString;

public abstract class SimpleTableColumn
implements ITableColumn,
Serializable {
    private String m_strColumnName;
    private String m_strDisplayName;
    private boolean m_bSortable;
    private Comparator m_objComparator;

    public SimpleTableColumn(String strColumnName) {
        this(strColumnName, strColumnName);
    }

    public SimpleTableColumn(String strColumnName, boolean bSortable) {
        this(strColumnName, strColumnName, bSortable);
    }

    public SimpleTableColumn(String strColumnName, String strDisplayName) {
        this(strColumnName, strDisplayName, false);
    }

    public SimpleTableColumn(String strColumnName, String strDisplayName, boolean bSortable) {
        this.m_strColumnName = strColumnName;
        this.m_strDisplayName = strDisplayName;
        this.m_bSortable = bSortable;
        this.setComparator(new DefaultComparator());
    }

    public String getColumnName() {
        return this.m_strColumnName;
    }

    public String getDisplayName() {
        return this.m_strDisplayName;
    }

    public boolean getSortable() {
        return this.m_bSortable;
    }

    public Comparator getComparator() {
        return this.m_objComparator;
    }

    protected void setComparator(Comparator objComparator) {
        this.m_objComparator = objComparator;
    }

    public Object getColumnValue(Object objRow) {
        return objRow.toString();
    }

    public IRender getColumnRenderer(IRequestCycle objCycle, ITableModelSource objSource) {
        INamespace objNamespace = objSource.getNamespace();
        String strNamespace = objNamespace.getExtendedId();
        strNamespace = strNamespace == null ? "" : strNamespace + ":";
        IPage objPage = objCycle.getPage(strNamespace + "SimpleTableColumnPage");
        ISimpleTableColumnRenderer objRenderer = (ISimpleTableColumnRenderer)objPage.getComponent("tableColumnComponent");
        objRenderer.initializeColumnRenderer(this, objSource);
        return objRenderer;
    }

    public IRender getValueRenderer(IRequestCycle objCycle, ITableModelSource objSource, Object objRow) {
        return new RenderString(this.getColumnValue(objRow).toString());
    }

    private class DefaultComparator
    implements Comparator,
    Serializable {
        private DefaultComparator() {
        }

        public int compare(Object objRow1, Object objRow2) {
            Object objValue1 = SimpleTableColumn.this.getColumnValue(objRow1);
            Object objValue2 = SimpleTableColumn.this.getColumnValue(objRow2);
            if (!(objValue1 instanceof Comparable) || !(objValue2 instanceof Comparable)) {
                return 0;
            }
            return ((Comparable)objValue1).compareTo(objValue2);
        }
    }
}

