/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry;

import java.io.OutputStream;
import java.util.EventListener;
import java.util.Locale;
import javax.swing.event.EventListenerList;
import net.sf.tapestry.ApplicationRuntimeException;
import net.sf.tapestry.BaseComponent;
import net.sf.tapestry.IComponent;
import net.sf.tapestry.IEngine;
import net.sf.tapestry.IMarkupWriter;
import net.sf.tapestry.IPage;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.PageRecorderCommitException;
import net.sf.tapestry.RequestCycleException;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.event.ChangeObserver;
import net.sf.tapestry.event.PageCleanupListener;
import net.sf.tapestry.event.PageDetachListener;
import net.sf.tapestry.event.PageEvent;
import net.sf.tapestry.event.PageRenderListener;
import net.sf.tapestry.util.StringSplitter;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class AbstractPage
extends BaseComponent
implements IPage {
    private static final Logger LOG = LogManager.getLogger((Class)(class$net$sf$tapestry$AbstractPage == null ? (class$net$sf$tapestry$AbstractPage = AbstractPage.class$("net.sf.tapestry.AbstractPage")) : class$net$sf$tapestry$AbstractPage));
    private ChangeObserver _changeObserver;
    private IEngine _engine;
    private Object _visit;
    private String _name;
    private IRequestCycle _requestCycle;
    private Locale _locale;
    private EventListenerList _listenerList;
    static /* synthetic */ Class class$net$sf$tapestry$AbstractPage;
    static /* synthetic */ Class class$net$sf$tapestry$event$PageDetachListener;
    static /* synthetic */ Class class$net$sf$tapestry$event$PageRenderListener;
    static /* synthetic */ Class class$net$sf$tapestry$event$PageCleanupListener;

    public AbstractPage() {
        this.initialize();
    }

    public abstract IMarkupWriter getResponseWriter(OutputStream var1);

    public void detach() {
        this.firePageDetached();
        this.initialize();
        this._engine = null;
        this._visit = null;
        this._changeObserver = null;
        this._requestCycle = null;
    }

    protected void initialize() {
    }

    public IEngine getEngine() {
        return this._engine;
    }

    public ChangeObserver getChangeObserver() {
        return this._changeObserver;
    }

    public String getExtendedId() {
        return this._name;
    }

    public String getIdPath() {
        return null;
    }

    public Locale getLocale() {
        return this._locale;
    }

    public void setLocale(Locale value) {
        if (this._locale != null) {
            throw new ApplicationRuntimeException(Tapestry.getString("AbstractPage.attempt-to-change-locale"));
        }
        this._locale = value;
    }

    public String getName() {
        return this._name;
    }

    public IPage getPage() {
        return this;
    }

    public IComponent getNestedComponent(String path) {
        if (path == null) {
            return this;
        }
        StringSplitter splitter = new StringSplitter('.');
        IComponent current = this;
        String[] elements = splitter.splitToArray(path);
        int i = 0;
        while (i < elements.length) {
            current = current.getComponent(elements[i]);
            ++i;
        }
        return current;
    }

    public void attach(IEngine value) {
        if (this._engine != null) {
            LOG.error((Object)(this + " attach(" + value + "), but engine = " + this._engine));
        }
        this._engine = value;
    }

    public void renderPage(IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
        try {
            try {
                this.firePageBeginRender();
                this.beginResponse(writer, cycle);
                if (!cycle.isRewinding()) {
                    cycle.commitPageChanges();
                }
                this.render(writer, cycle);
            }
            catch (PageRecorderCommitException ex) {
                throw new RequestCycleException(ex.getMessage(), null, ex);
            }
            Object var5_3 = null;
            this.firePageEndRender();
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.firePageEndRender();
            throw throwable;
        }
    }

    public void setChangeObserver(ChangeObserver value) {
        this._changeObserver = value;
    }

    public void setName(String value) {
        if (this._name != null) {
            throw new ApplicationRuntimeException(Tapestry.getString("AbstractPage.attempt-to-change-name"));
        }
        this._name = value;
    }

    public void validate(IRequestCycle cycle) throws RequestCycleException {
    }

    public void beginResponse(IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
    }

    public IRequestCycle getRequestCycle() {
        return this._requestCycle;
    }

    public void setRequestCycle(IRequestCycle value) {
        this._requestCycle = value;
    }

    public void cleanupPage() {
        this.firePageCleanup();
    }

    public Object getVisit() {
        if (this._visit == null) {
            this._visit = this._engine.getVisit(this._requestCycle);
        }
        return this._visit;
    }

    public void addPageDetachListener(PageDetachListener listener) {
        this.addListener(class$net$sf$tapestry$event$PageDetachListener == null ? (class$net$sf$tapestry$event$PageDetachListener = AbstractPage.class$("net.sf.tapestry.event.PageDetachListener")) : class$net$sf$tapestry$event$PageDetachListener, listener);
    }

    private void addListener(Class listenerClass, EventListener listener) {
        if (this._listenerList == null) {
            this._listenerList = new EventListenerList();
        }
        this._listenerList.add(listenerClass, listener);
    }

    private void removeListener(Class listenerClass, EventListener listener) {
        if (this._listenerList != null) {
            this._listenerList.remove(listenerClass, listener);
        }
    }

    public void addPageRenderListener(PageRenderListener listener) {
        this.addListener(class$net$sf$tapestry$event$PageRenderListener == null ? (class$net$sf$tapestry$event$PageRenderListener = AbstractPage.class$("net.sf.tapestry.event.PageRenderListener")) : class$net$sf$tapestry$event$PageRenderListener, listener);
    }

    public void addPageCleanupListener(PageCleanupListener listener) {
        this.addListener(class$net$sf$tapestry$event$PageCleanupListener == null ? (class$net$sf$tapestry$event$PageCleanupListener = AbstractPage.class$("net.sf.tapestry.event.PageCleanupListener")) : class$net$sf$tapestry$event$PageCleanupListener, listener);
    }

    protected void firePageDetached() {
        if (this._listenerList == null) {
            return;
        }
        PageEvent event = null;
        Object[] listeners = this._listenerList.getListenerList();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] == (class$net$sf$tapestry$event$PageDetachListener == null ? AbstractPage.class$("net.sf.tapestry.event.PageDetachListener") : class$net$sf$tapestry$event$PageDetachListener)) {
                PageDetachListener l = (PageDetachListener)listeners[i + 1];
                if (event == null) {
                    event = new PageEvent(this, this._requestCycle);
                }
                l.pageDetached(event);
            }
            i += 2;
        }
    }

    protected void firePageBeginRender() {
        if (this._listenerList == null) {
            return;
        }
        PageEvent event = null;
        Object[] listeners = this._listenerList.getListenerList();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] == (class$net$sf$tapestry$event$PageRenderListener == null ? AbstractPage.class$("net.sf.tapestry.event.PageRenderListener") : class$net$sf$tapestry$event$PageRenderListener)) {
                PageRenderListener l = (PageRenderListener)listeners[i + 1];
                if (event == null) {
                    event = new PageEvent(this, this._requestCycle);
                }
                l.pageBeginRender(event);
            }
            i += 2;
        }
    }

    protected void firePageEndRender() {
        if (this._listenerList == null) {
            return;
        }
        PageEvent event = null;
        Object[] listeners = this._listenerList.getListenerList();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] == (class$net$sf$tapestry$event$PageRenderListener == null ? AbstractPage.class$("net.sf.tapestry.event.PageRenderListener") : class$net$sf$tapestry$event$PageRenderListener)) {
                PageRenderListener l = (PageRenderListener)listeners[i + 1];
                if (event == null) {
                    event = new PageEvent(this, this._requestCycle);
                }
                l.pageEndRender(event);
            }
            i += 2;
        }
    }

    protected void firePageCleanup() {
        if (this._listenerList == null) {
            return;
        }
        PageEvent event = null;
        Object[] listeners = this._listenerList.getListenerList();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] == (class$net$sf$tapestry$event$PageCleanupListener == null ? AbstractPage.class$("net.sf.tapestry.event.PageCleanupListener") : class$net$sf$tapestry$event$PageCleanupListener)) {
                PageCleanupListener l = (PageCleanupListener)listeners[i + 1];
                if (event == null) {
                    event = new PageEvent(this, null);
                }
                l.pageCleanup(event);
            }
            i += 2;
        }
    }

    public void removePageCleanupListener(PageCleanupListener listener) {
        this.removeListener(class$net$sf$tapestry$event$PageCleanupListener == null ? (class$net$sf$tapestry$event$PageCleanupListener = AbstractPage.class$("net.sf.tapestry.event.PageCleanupListener")) : class$net$sf$tapestry$event$PageCleanupListener, listener);
    }

    public void removePageDetachListener(PageDetachListener listener) {
        this.removeListener(class$net$sf$tapestry$event$PageDetachListener == null ? (class$net$sf$tapestry$event$PageDetachListener = AbstractPage.class$("net.sf.tapestry.event.PageDetachListener")) : class$net$sf$tapestry$event$PageDetachListener, listener);
    }

    public void removePageRenderListener(PageRenderListener listener) {
        this.removeListener(class$net$sf$tapestry$event$PageRenderListener == null ? (class$net$sf$tapestry$event$PageRenderListener = AbstractPage.class$("net.sf.tapestry.event.PageRenderListener")) : class$net$sf$tapestry$event$PageRenderListener, listener);
    }

    public void beginPageRender() {
        this.firePageBeginRender();
    }

    public void endPageRender() {
        this.firePageEndRender();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

