/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.tapestry.AbstractComponent;
import net.sf.tapestry.BodylessComponentException;
import net.sf.tapestry.IBinding;
import net.sf.tapestry.IComponent;
import net.sf.tapestry.IMarkupWriter;
import net.sf.tapestry.IPageLoader;
import net.sf.tapestry.IPageSource;
import net.sf.tapestry.IRender;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.ITemplateSource;
import net.sf.tapestry.NoSuchComponentException;
import net.sf.tapestry.PageLoaderException;
import net.sf.tapestry.RequestCycleException;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.parse.ComponentTemplate;
import net.sf.tapestry.parse.TemplateToken;
import net.sf.tapestry.parse.TokenType;
import net.sf.tapestry.spec.ComponentSpecification;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class BaseComponent
extends AbstractComponent {
    private static final Logger LOG = LogManager.getLogger((Class)(class$net$sf$tapestry$BaseComponent == null ? (class$net$sf$tapestry$BaseComponent = BaseComponent.class$("net.sf.tapestry.BaseComponent")) : class$net$sf$tapestry$BaseComponent));
    private int _outerCount = 0;
    private static final int OUTER_INIT_SIZE = 5;
    private IRender[] _outer;
    static /* synthetic */ Class class$net$sf$tapestry$BaseComponent;

    private void addOuter(IRender element) {
        if (this._outer == null) {
            this._outer = new IRender[5];
            this._outer[0] = element;
            this._outerCount = 1;
            return;
        }
        if (this._outerCount == this._outer.length) {
            IRender[] newOuter = new IRender[this._outer.length * 2];
            System.arraycopy(this._outer, 0, newOuter, 0, this._outerCount);
            this._outer = newOuter;
        }
        this._outer[this._outerCount++] = element;
    }

    private void readTemplate(IRequestCycle cycle, IPageLoader loader) throws PageLoaderException {
        HashSet seenIds = new HashSet();
        IPageSource pageSource = loader.getEngine().getPageSource();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this + " reading template"));
        }
        ITemplateSource source = loader.getTemplateSource();
        ComponentTemplate componentTemplate = source.getTemplate(cycle, this);
        int count = componentTemplate.getTokenCount();
        IComponent[] componentStack = new IComponent[count];
        IComponent activeComponent = null;
        int stackx = 0;
        int i = 0;
        while (i < count) {
            TemplateToken token = componentTemplate.getToken(i);
            TokenType type = token.getType();
            if (type == TokenType.TEXT) {
                this.addText(activeComponent, token);
            } else if (type == TokenType.OPEN) {
                IComponent component = this.addStartComponent(activeComponent, token, pageSource, seenIds);
                componentStack[stackx++] = activeComponent;
                activeComponent = component;
            } else if (type == TokenType.CLOSE) {
                try {
                    activeComponent = componentStack[--stackx];
                }
                catch (IndexOutOfBoundsException ex) {
                    throw new PageLoaderException(Tapestry.getString("BaseComponent.unbalanced-close-tags"), this);
                }
            } else if (type == TokenType.LOCALIZATION) {
                this.addStringLocalization(activeComponent, token);
            }
            ++i;
        }
        if (stackx != 0) {
            throw new PageLoaderException(Tapestry.getString("BaseComponent.unbalance-open-tags"), this);
        }
        this.checkAllComponentsReferenced(seenIds);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this + " finished reading template"));
        }
    }

    private void addStringLocalization(IComponent activeComponent, TemplateToken token) {
        LocalizedStringRender renderer = new LocalizedStringRender(token.getId(), token.getAttributes());
        if (activeComponent == null) {
            this.addOuter(renderer);
        } else {
            activeComponent.addBody(renderer);
        }
    }

    private IComponent addStartComponent(IComponent activeComponent, TemplateToken token, IPageSource pageSource, Set seenIds) throws PageLoaderException, BodylessComponentException {
        String id = token.getId();
        IComponent component = null;
        try {
            component = this.getComponent(id);
        }
        catch (NoSuchComponentException ex) {
            throw new PageLoaderException(Tapestry.getString("BaseComponent.undefined-embedded-component", this.getExtendedId(), id), this, (Throwable)ex);
        }
        if (seenIds.contains(id)) {
            throw new PageLoaderException(Tapestry.getString("BaseComponent.multiple-component-references", this.getExtendedId(), id), this);
        }
        seenIds.add(id);
        if (activeComponent == null) {
            this.addOuter(component);
        } else {
            if (!activeComponent.getSpecification().getAllowBody()) {
                throw new BodylessComponentException(activeComponent);
            }
            activeComponent.addBody(component);
        }
        this.addStaticBindings(component, token.getAttributes(), pageSource);
        return component;
    }

    private void addText(IComponent activeComponent, TemplateToken token) throws BodylessComponentException {
        IRender element = token.getRender();
        if (activeComponent == null) {
            this.addOuter(element);
        } else {
            if (!activeComponent.getSpecification().getAllowBody()) {
                throw new BodylessComponentException(activeComponent);
            }
            activeComponent.addBody(element);
        }
    }

    private void addStaticBindings(IComponent component, Map attributes, IPageSource pageSource) {
        if (attributes == null || attributes.isEmpty()) {
            return;
        }
        ComponentSpecification spec = component.getSpecification();
        boolean rejectInformal = !spec.getAllowInformalParameters();
        Iterator i = attributes.entrySet().iterator();
        while (i.hasNext()) {
            boolean isFormal;
            Map.Entry e = i.next();
            String name = (String)e.getKey();
            boolean bl = isFormal = spec.getParameter(name) != null;
            if (isFormal ? component.getBinding(name) != null : rejectInformal || spec.isReservedParameterName(name)) continue;
            String value = (String)e.getValue();
            IBinding binding = pageSource.getStaticBinding(value);
            component.setBinding(name, binding);
        }
    }

    private void checkAllComponentsReferenced(Set seenIds) throws PageLoaderException {
        Map components = this.getComponents();
        Set ids = components.keySet();
        if (seenIds.containsAll(ids)) {
            return;
        }
        ids = new HashSet(ids);
        ids.removeAll(seenIds);
        int count = ids.size();
        String key = count == 1 ? "BaseComponent.missing-component-spec-single" : "BaseComponent.missing-component-spec-multi";
        StringBuffer buffer = new StringBuffer(Tapestry.getString(key, this.getExtendedId()));
        Iterator i = ids.iterator();
        int j = 1;
        while (i.hasNext()) {
            if (j == 1) {
                buffer.append(' ');
            } else if (j == count) {
                buffer.append(' ');
                buffer.append(Tapestry.getString("BaseComponent.and"));
                buffer.append(' ');
            } else {
                buffer.append(", ");
            }
            buffer.append(i.next());
            ++j;
        }
        buffer.append('.');
        LOG.error((Object)buffer.toString());
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Begin render " + this.getExtendedId()));
        }
        int i = 0;
        while (i < this._outerCount) {
            this._outer[i].render(writer, cycle);
            ++i;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("End render " + this.getExtendedId()));
        }
    }

    public void finishLoad(IRequestCycle cycle, IPageLoader loader, ComponentSpecification specification) throws PageLoaderException {
        this.readTemplate(cycle, loader);
        this.finishLoad();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class LocalizedStringRender
    implements IRender {
        private String _key;
        private Map _attributes;

        private LocalizedStringRender(String key, Map attributes) {
            this._key = key;
            this._attributes = attributes;
        }

        public void render(IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
            if (cycle.isRewinding()) {
                return;
            }
            if (this._attributes != null) {
                writer.begin("span");
                Iterator i = this._attributes.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    String attributeName = (String)entry.getKey();
                    String attributeValue = (String)entry.getValue();
                    writer.attribute(attributeName, attributeValue);
                }
            }
            writer.print(BaseComponent.this.getString(this._key));
            if (this._attributes != null) {
                writer.end();
            }
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer("LocalizedStringRender@");
            buffer.append(Integer.toHexString(this.hashCode()));
            buffer.append('[');
            buffer.append(this._key);
            if (this._attributes != null) {
                buffer.append(' ');
                buffer.append(this._attributes);
            }
            buffer.append(']');
            return buffer.toString();
        }
    }
}

