/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry;

import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import javax.servlet.http.HttpServletResponse;
import net.sf.tapestry.Tapestry;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class ResponseOutputStream
extends OutputStream {
    private static final Logger LOG = LogManager.getLogger((Class)(class$net$sf$tapestry$ResponseOutputStream == null ? (class$net$sf$tapestry$ResponseOutputStream = ResponseOutputStream.class$("net.sf.tapestry.ResponseOutputStream")) : class$net$sf$tapestry$ResponseOutputStream));
    public static final int DEFAULT_SIZE = 2000;
    private int _pos;
    private int _maxSize;
    private byte[] _buffer;
    private String _contentType;
    private HttpServletResponse _response;
    private OutputStream _out;
    private boolean _discard = false;
    static /* synthetic */ Class class$net$sf$tapestry$ResponseOutputStream;

    public ResponseOutputStream(HttpServletResponse response) {
        this(response, 2000);
    }

    public ResponseOutputStream(HttpServletResponse response, int maxSize) {
        this._response = response;
        this._maxSize = maxSize;
    }

    public void close() throws IOException {
    }

    public void flush() throws IOException {
        try {
            if (this._out != null) {
                this._out.flush();
            }
        }
        catch (SocketException ex) {
            LOG.debug((Object)"Socket exception.");
        }
    }

    public void forceFlush() throws IOException {
        if (this._out == null) {
            if (this._buffer == null) {
                return;
            }
            this.open();
        }
        try {
            this._out.flush();
        }
        catch (SocketException ex) {
            LOG.debug((Object)"Socket exception.");
        }
    }

    public String getContentType() {
        return this._contentType;
    }

    public boolean getDiscard() {
        return this._discard;
    }

    private void open() throws IOException {
        if (this._contentType == null) {
            throw new IOException(Tapestry.getString("ResponseOutputStream.content-type-not-set"));
        }
        this._response.setContentType(this._contentType);
        this._out = this._response.getOutputStream();
        this.innerWrite(this._buffer, 0, this._pos);
        this._pos = 0;
        this._buffer = null;
    }

    public void reset() throws IOException {
        this._pos = 0;
        this._discard = false;
    }

    public void setBufferSize(int value) throws IOException {
        if (value < this._pos) {
            this.open();
            return;
        }
        this._maxSize = value;
    }

    public void setContentType(String value) {
        this._contentType = value;
    }

    public void setDiscard(boolean value) {
        this._discard = value;
    }

    private void innerWrite(byte[] b, int off, int len) throws IOException {
        if (b == null || len == 0 || this._discard) {
            return;
        }
        try {
            this._out.write(b, off, len);
        }
        catch (SocketException ex) {
            LOG.debug((Object)"Socket exception.");
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (len == 0 || this._discard) {
            return;
        }
        if (this._out != null) {
            this._out.write(b, off, len);
            return;
        }
        if (this._pos + len >= this._maxSize) {
            this.open();
            this.innerWrite(b, off, len);
            return;
        }
        if (this._buffer == null) {
            this._buffer = new byte[this._maxSize];
        }
        System.arraycopy(b, off, this._buffer, this._pos, len);
        this._pos += len;
    }

    public void write(int b) throws IOException {
        if (this._discard) {
            return;
        }
        byte[] tiny = new byte[]{(byte)b};
        this.write(tiny, 0, 1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

