/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import net.sf.tapestry.IBinding;
import net.sf.tapestry.IComponent;
import net.sf.tapestry.spec.ComponentSpecification;
import net.sf.tapestry.util.AdaptorRegistry;
import net.sf.tapestry.util.StringSplitter;

public final class Tapestry {
    public static final String VERSION = Tapestry.readVersion();
    private static ResourceBundle _strings;
    private static final Map _localeMap;
    private static final AdaptorRegistry _booleanAdaptors;
    private static AdaptorRegistry _iteratorAdaptors;
    private static final String UNKNOWN_VERSION = "Unknown";
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$Iterator;
    static /* synthetic */ Class class$net$sf$tapestry$Tapestry;

    private Tapestry() {
    }

    public static boolean isNull(String value) {
        if (value == null) {
            return true;
        }
        if (value.length() == 0) {
            return true;
        }
        return value.trim().length() == 0;
    }

    public static void copyInformalBindings(IComponent source, IComponent destination) {
        Collection names = source.getBindingNames();
        if (names == null) {
            return;
        }
        ComponentSpecification specification = source.getSpecification();
        Iterator i = names.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            if (specification.getParameter(name) != null) continue;
            IBinding binding = source.getBinding(name);
            destination.setBinding(name, binding);
        }
    }

    public static boolean evaluateBoolean(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> valueClass = value.getClass();
        if (valueClass.isArray()) {
            Object[] array = (Object[])value;
            return array.length > 0;
        }
        BoolAdaptor adaptor = (BoolAdaptor)_booleanAdaptors.getAdaptor(valueClass);
        return adaptor.coerce(value);
    }

    public static Iterator coerceToIterator(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> valueClass = value.getClass();
        if (valueClass.isArray()) {
            Object[] array = (Object[])value;
            if (array.length == 0) {
                return null;
            }
            List<Object> l = Arrays.asList(array);
            return l.iterator();
        }
        IteratorAdaptor adaptor = (IteratorAdaptor)_iteratorAdaptors.getAdaptor(valueClass);
        return adaptor.coerce(value);
    }

    public static Locale getLocale(String s) {
        Locale result = null;
        Map map = _localeMap;
        synchronized (map) {
            result = (Locale)_localeMap.get(s);
        }
        if (result == null) {
            StringSplitter splitter = new StringSplitter('_');
            String[] terms = splitter.splitToArray(s);
            switch (terms.length) {
                case 1: {
                    result = new Locale(terms[0], "");
                    break;
                }
                case 2: {
                    result = new Locale(terms[0], terms[1]);
                    break;
                }
                case 3: {
                    result = new Locale(terms[0], terms[1], terms[2]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unable to convert '" + s + "' to a Locale.");
                }
            }
            Map map2 = _localeMap;
            synchronized (map2) {
                _localeMap.put(s, result);
            }
        }
        return result;
    }

    public static void close(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static String getString(String key, Object[] args) {
        if (_strings == null) {
            _strings = ResourceBundle.getBundle("net.sf.tapestry.TapestryStrings");
        }
        String pattern = _strings.getString(key);
        if (args == null) {
            return pattern;
        }
        return MessageFormat.format(pattern, args);
    }

    public static String getString(String key) {
        return Tapestry.getString(key, null);
    }

    public static String getString(String key, Object arg) {
        return Tapestry.getString(key, new Object[]{arg});
    }

    public static String getString(String key, Object arg1, Object arg2) {
        return Tapestry.getString(key, new Object[]{arg1, arg2});
    }

    public static String getString(String key, Object arg1, Object arg2, Object arg3) {
        return Tapestry.getString(key, new Object[]{arg1, arg2, arg3});
    }

    private static final String readVersion() {
        Properties props = new Properties();
        try {
            InputStream in = (class$net$sf$tapestry$Tapestry == null ? (class$net$sf$tapestry$Tapestry = Tapestry.class$("net.sf.tapestry.Tapestry")) : class$net$sf$tapestry$Tapestry).getResourceAsStream("Version.properties");
            if (in == null) {
                return UNKNOWN_VERSION;
            }
            props.load(in);
            in.close();
            return props.getProperty("framework.version", UNKNOWN_VERSION);
        }
        catch (IOException ex) {
            return UNKNOWN_VERSION;
        }
    }

    public static int size(Collection c) {
        if (c == null) {
            return 0;
        }
        return c.size();
    }

    public static int size(Object[] array) {
        if (array == null) {
            return 0;
        }
        return array.length;
    }

    public static Object[] convertMapToArray(Map map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        Set entries = map.entrySet();
        Object[] result = new Object[2 * entries.size()];
        int x = 0;
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            result[x++] = entry.getKey();
            result[x++] = entry.getValue();
        }
        return result;
    }

    public static Map convertArrayToMap(Object[] array) {
        if (array == null || array.length == 0) {
            return null;
        }
        if (array.length % 2 != 0) {
            throw new IllegalArgumentException(Tapestry.getString("Tapestry.even-sized-array"));
        }
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        int x = 0;
        while (x < array.length) {
            Object key = array[x++];
            Object value = array[x++];
            result.put(key, value);
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _localeMap = new HashMap();
        Locale[] locales = Locale.getAvailableLocales();
        int i = 0;
        while (i < locales.length) {
            _localeMap.put(locales[i].toString(), locales[i]);
            ++i;
        }
        _booleanAdaptors = new AdaptorRegistry();
        _booleanAdaptors.register(class$java$lang$Boolean == null ? (class$java$lang$Boolean = Tapestry.class$("java.lang.Boolean")) : class$java$lang$Boolean, new BooleanAdaptor());
        _booleanAdaptors.register(class$java$lang$Number == null ? (class$java$lang$Number = Tapestry.class$("java.lang.Number")) : class$java$lang$Number, new NumberAdaptor());
        _booleanAdaptors.register(class$java$util$Collection == null ? (class$java$util$Collection = Tapestry.class$("java.util.Collection")) : class$java$util$Collection, new CollectionAdaptor());
        _booleanAdaptors.register(class$java$lang$String == null ? (class$java$lang$String = Tapestry.class$("java.lang.String")) : class$java$lang$String, new StringAdaptor());
        _booleanAdaptors.register(class$java$lang$Object == null ? (class$java$lang$Object = Tapestry.class$("java.lang.Object")) : class$java$lang$Object, new BoolAdaptor(){

            public boolean coerce(Object value) {
                return true;
            }
        });
        _iteratorAdaptors = new AdaptorRegistry();
        _iteratorAdaptors.register(class$java$util$Iterator == null ? (class$java$util$Iterator = Tapestry.class$("java.util.Iterator")) : class$java$util$Iterator, new IteratorAdaptor(){

            public Iterator coerce(Object value) {
                return (Iterator)value;
            }
        });
        _iteratorAdaptors.register(class$java$util$Collection == null ? (class$java$util$Collection = Tapestry.class$("java.util.Collection")) : class$java$util$Collection, new IteratorAdaptor(){

            public Iterator coerce(Object value) {
                Collection c = (Collection)value;
                if (c.size() == 0) {
                    return null;
                }
                return c.iterator();
            }
        });
        _iteratorAdaptors.register(class$java$lang$Object == null ? (class$java$lang$Object = Tapestry.class$("java.lang.Object")) : class$java$lang$Object, new IteratorAdaptor(){

            public Iterator coerce(Object value) {
                return Collections.singleton(value).iterator();
            }
        });
    }

    private static abstract class IteratorAdaptor {
        private IteratorAdaptor() {
        }

        public abstract Iterator coerce(Object var1);
    }

    private static class StringAdaptor
    extends BoolAdaptor {
        private StringAdaptor() {
        }

        public boolean coerce(Object value) {
            String s = (String)value;
            if (s.length() == 0) {
                return false;
            }
            char[] data = s.toCharArray();
            try {
                int i = 0;
                while (true) {
                    char ch;
                    if (!Character.isWhitespace(ch = data[i])) {
                        return true;
                    }
                    ++i;
                }
            }
            catch (IndexOutOfBoundsException ex) {
                return false;
            }
        }
    }

    private static class CollectionAdaptor
    extends BoolAdaptor {
        private CollectionAdaptor() {
        }

        public boolean coerce(Object value) {
            Collection c = (Collection)value;
            return c.size() > 0;
        }
    }

    private static class NumberAdaptor
    extends BoolAdaptor {
        private NumberAdaptor() {
        }

        public boolean coerce(Object value) {
            Number n = (Number)value;
            return n.intValue() > 0;
        }
    }

    private static class BooleanAdaptor
    extends BoolAdaptor {
        private BooleanAdaptor() {
        }

        public boolean coerce(Object value) {
            Boolean b = (Boolean)value;
            return b;
        }
    }

    private static abstract class BoolAdaptor {
        private BoolAdaptor() {
        }

        public abstract boolean coerce(Object var1);
    }
}

