/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.bean;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.tapestry.ApplicationRuntimeException;
import net.sf.tapestry.IBeanProvider;
import net.sf.tapestry.IComponent;
import net.sf.tapestry.IEngine;
import net.sf.tapestry.IResourceResolver;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.bean.IBeanInitializer;
import net.sf.tapestry.event.PageDetachListener;
import net.sf.tapestry.event.PageEvent;
import net.sf.tapestry.event.PageRenderListener;
import net.sf.tapestry.spec.BeanLifecycle;
import net.sf.tapestry.spec.BeanSpecification;
import net.sf.tapestry.spec.ComponentSpecification;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class BeanProvider
implements IBeanProvider,
PageDetachListener,
PageRenderListener {
    private static final Logger LOG = LogManager.getLogger((Class)(class$net$sf$tapestry$bean$BeanProvider == null ? (class$net$sf$tapestry$bean$BeanProvider = BeanProvider.class$("net.sf.tapestry.bean.BeanProvider")) : class$net$sf$tapestry$bean$BeanProvider));
    private boolean _registeredForDetach = false;
    private boolean _registeredForRender = false;
    private IComponent _component;
    private IResourceResolver _resolver;
    private Map _beans;
    private Set _beanNames;
    static /* synthetic */ Class class$net$sf$tapestry$bean$BeanProvider;

    public BeanProvider(IComponent component) {
        this._component = component;
        IEngine engine = component.getPage().getEngine();
        this._resolver = engine.getResourceResolver();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Created BeanProvider for " + component));
        }
    }

    public Collection getBeanNames() {
        if (this._beanNames == null) {
            Collection c = this._component.getSpecification().getBeanNames();
            this._beanNames = c == null || c.isEmpty() ? Collections.EMPTY_SET : Collections.unmodifiableSet(new HashSet(c));
        }
        return this._beanNames;
    }

    public IComponent getComponent() {
        return this._component;
    }

    public Object getBean(String name) {
        Object bean = null;
        if (this._beans != null) {
            bean = this._beans.get(name);
        }
        if (bean != null) {
            return bean;
        }
        BeanSpecification spec = this._component.getSpecification().getBeanSpecification(name);
        if (spec == null) {
            throw new ApplicationRuntimeException(Tapestry.getString("BeanProvider.bean-not-defined", this._component.getExtendedId(), name));
        }
        bean = this.instantiateBean(spec);
        BeanLifecycle lifecycle = spec.getLifecycle();
        if (lifecycle == BeanLifecycle.NONE) {
            return bean;
        }
        if (this._beans == null) {
            this._beans = new HashMap();
        }
        this._beans.put(name, bean);
        if (lifecycle == BeanLifecycle.REQUEST && !this._registeredForDetach) {
            this._component.getPage().addPageDetachListener(this);
            this._registeredForDetach = true;
        }
        if (lifecycle == BeanLifecycle.RENDER && !this._registeredForRender) {
            this._component.getPage().addPageRenderListener(this);
            this._registeredForRender = true;
        }
        return bean;
    }

    private Object instantiateBean(BeanSpecification spec) {
        String className = spec.getClassName();
        Object bean = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Instantiating instance of " + className));
        }
        Class beanClass = this._resolver.findClass(className);
        try {
            bean = beanClass.newInstance();
        }
        catch (IllegalAccessException ex) {
            throw new ApplicationRuntimeException(ex);
        }
        catch (InstantiationException ex) {
            throw new ApplicationRuntimeException(ex);
        }
        List initializers = spec.getInitializers();
        if (initializers == null) {
            return bean;
        }
        Iterator i = initializers.iterator();
        while (i.hasNext()) {
            IBeanInitializer iz = (IBeanInitializer)i.next();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Initializing property " + iz.getPropertyName()));
            }
            iz.setBeanProperty(this, bean);
        }
        return bean;
    }

    public void pageDetached(PageEvent event) {
        this.removeBeans(BeanLifecycle.REQUEST);
    }

    private void removeBeans(BeanLifecycle lifecycle) {
        if (this._beans == null) {
            return;
        }
        ComponentSpecification spec = null;
        Iterator i = this._beans.entrySet().iterator();
        while (i.hasNext()) {
            BeanSpecification s;
            Map.Entry e = i.next();
            String name = (String)e.getKey();
            if (spec == null) {
                spec = this._component.getSpecification();
            }
            if ((s = spec.getBeanSpecification(name)).getLifecycle() != lifecycle) continue;
            Object bean = e.getValue();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Removing " + lifecycle.getEnumerationId() + " bean " + name + ": " + bean));
            }
            i.remove();
        }
    }

    public IResourceResolver getResourceResolver() {
        return this._resolver;
    }

    public void pageBeginRender(PageEvent event) {
    }

    public void pageEndRender(PageEvent event) {
        this.removeBeans(BeanLifecycle.RENDER);
    }

    public boolean canProvideBean(String name) {
        return this.getBeanNames().contains(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

