/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.bean;

import java.lang.reflect.Field;
import net.sf.tapestry.ApplicationRuntimeException;
import net.sf.tapestry.IBeanProvider;
import net.sf.tapestry.IResourceResolver;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.bean.AbstractBeanInitializer;

public class FieldBeanInitializer
extends AbstractBeanInitializer {
    protected String _fieldName;
    protected Object _fieldValue;
    private boolean _fieldResolved = false;

    public FieldBeanInitializer(String propertyName, String fieldName) {
        super(propertyName);
        this._fieldName = fieldName;
    }

    public void setBeanProperty(IBeanProvider provider, Object bean) {
        IResourceResolver resolver = provider.getResourceResolver();
        if (!this._fieldResolved) {
            this.resolveField(resolver);
        }
        this.setBeanProperty(resolver, bean, this._fieldValue);
    }

    private synchronized void resolveField(IResourceResolver resolver) {
        if (this._fieldResolved) {
            return;
        }
        int dotx = this._fieldName.lastIndexOf(46);
        if (dotx < 0) {
            throw new ApplicationRuntimeException(Tapestry.getString("invalid-field-name", this._fieldName));
        }
        String className = this._fieldName.substring(0, dotx);
        String simpleFieldName = this._fieldName.substring(dotx + 1);
        if (className.indexOf(46) < 0) {
            className = "java.lang." + className;
        }
        Class targetClass = null;
        try {
            targetClass = resolver.findClass(className);
        }
        catch (Throwable t) {
            throw new ApplicationRuntimeException(Tapestry.getString("unable-to-resolve-class", className), t);
        }
        Field field = null;
        try {
            field = targetClass.getField(simpleFieldName);
        }
        catch (NoSuchFieldException ex) {
            throw new ApplicationRuntimeException(Tapestry.getString("field-not-defined", this._fieldName), ex);
        }
        try {
            this._fieldValue = field.get(null);
        }
        catch (IllegalAccessException ex) {
            throw new ApplicationRuntimeException(Tapestry.getString("illegal-field-access", this._fieldName), ex);
        }
        catch (NullPointerException ex) {
            throw new ApplicationRuntimeException(Tapestry.getString("field-is-instance", this._fieldName), ex);
        }
        this._fieldResolved = true;
    }
}

