/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.binding;

import net.sf.tapestry.BindingException;
import net.sf.tapestry.IBinding;
import net.sf.tapestry.NullValueForBindingException;
import net.sf.tapestry.ReadOnlyBindingException;
import net.sf.tapestry.Tapestry;

public abstract class AbstractBinding
implements IBinding {
    public boolean getBoolean() {
        return Tapestry.evaluateBoolean(this.getObject());
    }

    public int getInt() {
        Object raw = this.getObject();
        if (raw == null) {
            throw new NullValueForBindingException(this);
        }
        if (raw instanceof Number) {
            return ((Number)raw).intValue();
        }
        if (raw instanceof Boolean) {
            return (Boolean)raw != false ? 1 : 0;
        }
        return Integer.parseInt((String)raw);
    }

    public double getDouble() {
        Object raw = this.getObject();
        if (raw == null) {
            throw new NullValueForBindingException(this);
        }
        if (raw instanceof Number) {
            return ((Number)raw).doubleValue();
        }
        if (raw instanceof Boolean) {
            return (Boolean)raw != false ? 1.0 : 0.0;
        }
        return Double.parseDouble((String)raw);
    }

    public String getString() {
        Object value = this.getObject();
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public void setBoolean(boolean value) {
        throw new ReadOnlyBindingException(this);
    }

    public void setInt(int value) {
        throw new ReadOnlyBindingException(this);
    }

    public void setDouble(double value) {
        throw new ReadOnlyBindingException(this);
    }

    public void setString(String value) {
        throw new ReadOnlyBindingException(this);
    }

    public void setObject(Object value) {
        throw new ReadOnlyBindingException(this);
    }

    public boolean isInvariant() {
        return true;
    }

    public Object getObject(String parameterName, Class type) {
        Object result = this.getObject();
        if (result == null) {
            return result;
        }
        if (type.isAssignableFrom(result.getClass())) {
            return result;
        }
        String key = type.isInterface() ? "AbstractBinding.wrong-interface" : "AbstractBinding.wrong-type";
        String message = Tapestry.getString(key, parameterName, result, type.getName());
        throw new BindingException(message, this);
    }

    public abstract Class getType();

    public abstract Object getObject();
}

