/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.components;

import java.text.Format;
import net.sf.tapestry.AbstractComponent;
import net.sf.tapestry.IMarkupWriter;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.RequestCycleException;
import net.sf.tapestry.Tapestry;

public class Insert
extends AbstractComponent {
    private Object _value;
    private Format _format;
    private String _styleClass;
    private boolean _raw;

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
        if (cycle.isRewinding()) {
            return;
        }
        if (this._value == null) {
            return;
        }
        String insert = null;
        if (this._format == null) {
            insert = this._value.toString();
        } else {
            try {
                insert = this._format.format(this._value);
            }
            catch (Exception ex) {
                throw new RequestCycleException(Tapestry.getString("Insert.unable-to-format", this._value), this, ex);
            }
        }
        if (this._styleClass != null) {
            writer.begin("span");
            writer.attribute("class", this._styleClass);
        }
        if (this._raw) {
            writer.printRaw(insert);
        } else {
            writer.print(insert);
        }
        if (this._styleClass != null) {
            writer.end();
        }
    }

    public Object getValue() {
        return this._value;
    }

    public void setValue(Object value) {
        this._value = value;
    }

    public Format getFormat() {
        return this._format;
    }

    public void setFormat(Format format) {
        this._format = format;
    }

    public String getStyleClass() {
        return this._styleClass;
    }

    public void setStyleClass(String styleClass) {
        this._styleClass = styleClass;
    }

    public boolean getRaw() {
        return this._raw;
    }

    public void setRaw(boolean raw) {
        this._raw = raw;
    }
}

