/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.engine;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import net.sf.tapestry.ApplicationRuntimeException;
import net.sf.tapestry.Gesture;
import net.sf.tapestry.IAction;
import net.sf.tapestry.IComponent;
import net.sf.tapestry.IEngineServiceView;
import net.sf.tapestry.IPage;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.RequestCycleException;
import net.sf.tapestry.ResponseOutputStream;
import net.sf.tapestry.StaleSessionException;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.engine.AbstractService;

public class ActionService
extends AbstractService {
    public Gesture buildGesture(IRequestCycle cycle, IComponent component, Object[] parameters) {
        IPage responsePage;
        if (parameters == null || parameters.length != 1) {
            throw new IllegalArgumentException(Tapestry.getString("service-single-parameter", "action"));
        }
        IPage componentPage = component.getPage();
        int length = componentPage == (responsePage = cycle.getPage()) ? 3 : 4;
        String[] serviceContext = new String[length];
        int i = 0;
        serviceContext[i++] = responsePage.getName();
        serviceContext[i++] = (String)parameters[0];
        if (componentPage != responsePage) {
            serviceContext[i++] = componentPage.getName();
        }
        serviceContext[i++] = component.getIdPath();
        return this.assembleGesture(cycle, "action", serviceContext, null, true);
    }

    public boolean service(IEngineServiceView engine, IRequestCycle cycle, ResponseOutputStream output) throws RequestCycleException, ServletException, IOException {
        HttpSession session;
        IAction action = null;
        int count = 0;
        String[] serviceContext = this.getServiceContext(cycle.getRequestContext());
        if (serviceContext != null) {
            count = serviceContext.length;
        }
        if (count != 3 && count != 4) {
            throw new ApplicationRuntimeException(Tapestry.getString("AbstractEngine.action-context-parameters"));
        }
        int i = 0;
        String pageName = serviceContext[i++];
        String targetActionId = serviceContext[i++];
        String componentPageName = count == 3 ? pageName : serviceContext[i++];
        String targetIdPath = serviceContext[i++];
        IPage page = cycle.getPage(pageName);
        IPage componentPage = cycle.getPage(componentPageName);
        IComponent component = componentPage.getNestedComponent(targetIdPath);
        try {
            action = (IAction)component;
        }
        catch (ClassCastException ex) {
            throw new RequestCycleException(Tapestry.getString("AbstractEngine.action-component-wrong-type", component.getExtendedId()), component, ex);
        }
        if (action.getRequiresSession() && ((session = cycle.getRequestContext().getSession()) == null || session.isNew())) {
            throw new StaleSessionException();
        }
        page.validate(cycle);
        cycle.setPage(page);
        cycle.rewindPage(targetActionId, action);
        engine.renderResponse(cycle, output);
        return true;
    }

    public String getName() {
        return "action";
    }
}

