/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.engine;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.tapestry.ApplicationRuntimeException;
import net.sf.tapestry.IMarkupWriter;
import net.sf.tapestry.INamespace;
import net.sf.tapestry.IRenderDescription;
import net.sf.tapestry.IResourceResolver;
import net.sf.tapestry.ISpecificationSource;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.engine.Namespace;
import net.sf.tapestry.parse.SpecificationParser;
import net.sf.tapestry.spec.ComponentSpecification;
import net.sf.tapestry.spec.IApplicationSpecification;
import net.sf.tapestry.spec.ILibrarySpecification;
import net.sf.tapestry.spec.LibrarySpecification;
import net.sf.tapestry.util.StringSplitter;
import net.sf.tapestry.util.xml.DocumentParseException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class DefaultSpecificationSource
implements ISpecificationSource,
IRenderDescription {
    private static final Logger LOG = LogManager.getLogger((Class)(class$net$sf$tapestry$engine$DefaultSpecificationSource == null ? (class$net$sf$tapestry$engine$DefaultSpecificationSource = DefaultSpecificationSource.class$("net.sf.tapestry.engine.DefaultSpecificationSource")) : class$net$sf$tapestry$engine$DefaultSpecificationSource));
    private IResourceResolver _resolver;
    private IApplicationSpecification _specification;
    private SpecificationParser _parser;
    private INamespace _applicationNamespace;
    private INamespace _frameworkNamespace;
    private Map _componentCache = new HashMap();
    private Map _pageCache = new HashMap();
    private Map _libraryCache = new HashMap();
    private Map _namespaceCache = new HashMap();
    static /* synthetic */ Class class$net$sf$tapestry$engine$DefaultSpecificationSource;

    public DefaultSpecificationSource(IResourceResolver resolver, IApplicationSpecification specification) {
        this._resolver = resolver;
        this._specification = specification;
    }

    public void reset() {
        this._componentCache.clear();
        this._pageCache.clear();
        this._libraryCache.clear();
        this._namespaceCache.clear();
        this._applicationNamespace = null;
        this._frameworkNamespace = null;
    }

    public ComponentSpecification getSpecification(String type) {
        return this.getComponentSpecification(type);
    }

    protected ComponentSpecification parseSpecification(String resourcePath, boolean asPage) {
        ComponentSpecification result = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Parsing component specification " + resourcePath));
        }
        InputStream inputStream = this.openSpecification(resourcePath);
        SpecificationParser parser = this.getParser();
        try {
            block6: {
                try {
                    if (asPage) {
                        result = this._parser.parsePageSpecification(inputStream, resourcePath);
                        break block6;
                    }
                    result = this._parser.parseComponentSpecification(inputStream, resourcePath);
                }
                catch (DocumentParseException ex) {
                    throw new ApplicationRuntimeException(Tapestry.getString("DefaultSpecificationSource.unable-to-parse-specification", resourcePath), ex);
                }
            }
            Object var8_6 = null;
            this.close(inputStream);
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.close(inputStream);
            throw throwable;
        }
        result.setSpecificationResourcePath(resourcePath);
        return result;
    }

    protected ILibrarySpecification parseLibrarySpecification(String resourcePath) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Parsing library specification " + resourcePath));
        }
        InputStream inputStream = this.openSpecification(resourcePath);
        SpecificationParser parser = this.getParser();
        try {
            try {
                ILibrarySpecification iLibrarySpecification = this.getParser().parseLibrarySpecification(inputStream, resourcePath, this._resolver);
                Object var6_6 = null;
                this.close(inputStream);
                return iLibrarySpecification;
            }
            catch (DocumentParseException ex) {
                throw new ApplicationRuntimeException(Tapestry.getString("DefaultSpecificationSource.unable-to-parse-specification", resourcePath), ex);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.close(inputStream);
            throw throwable;
        }
    }

    private InputStream openSpecification(String resourcePath) {
        URL URL2 = this._resolver.getResource(resourcePath);
        if (URL2 == null) {
            throw new ApplicationRuntimeException(Tapestry.getString("DefaultSpecificationSource.unable-to-locate-specification", resourcePath));
        }
        try {
            return URL2.openStream();
        }
        catch (IOException ex) {
            throw new ApplicationRuntimeException(Tapestry.getString("DefaultSpecificationSource.unable-to-open-specification", resourcePath), ex);
        }
    }

    private void close(InputStream stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("DefaultSpecificationSource@");
        buffer.append(Integer.toHexString(this.hashCode()));
        buffer.append('[');
        if (this._componentCache != null) {
            Map map = this._componentCache;
            synchronized (map) {
                buffer.append(this._componentCache.keySet());
            }
        }
        buffer.append(']');
        return buffer.toString();
    }

    public synchronized void renderDescription(IMarkupWriter writer) {
        writer.print("DefaultSpecificationSource[");
        this.writeCacheDescription(writer, "page", this._pageCache);
        writer.beginEmpty("br");
        writer.println();
        this.writeCacheDescription(writer, "component", this._componentCache);
        writer.print("]");
        writer.println();
    }

    private void writeCacheDescription(IMarkupWriter writer, String name, Map cache) {
        Set keySet = cache.keySet();
        writer.print(Tapestry.size(keySet));
        writer.print(" cached ");
        writer.print(name);
        writer.print(" specifications:");
        boolean first = true;
        Iterator i = keySet.iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (first) {
                writer.begin("ul");
                first = false;
            }
            writer.begin("li");
            writer.print(key);
            writer.end();
        }
        if (!first) {
            writer.end();
        }
    }

    public synchronized ComponentSpecification getComponentSpecification(String resourcePath) {
        ComponentSpecification result = (ComponentSpecification)this._componentCache.get(resourcePath);
        if (result == null) {
            result = this.parseSpecification(resourcePath, false);
            this._componentCache.put(resourcePath, result);
        }
        return result;
    }

    public synchronized ComponentSpecification getPageSpecification(String resourcePath) {
        ComponentSpecification result = (ComponentSpecification)this._pageCache.get(resourcePath);
        if (result == null) {
            result = this.parseSpecification(resourcePath, true);
            this._pageCache.put(resourcePath, result);
        }
        return result;
    }

    public synchronized ILibrarySpecification getLibrarySpecification(String resourcePath) {
        ILibrarySpecification result = (LibrarySpecification)this._libraryCache.get(resourcePath);
        if (result == null) {
            result = this.parseLibrarySpecification(resourcePath);
            this._libraryCache.put(resourcePath, result);
        }
        return result;
    }

    public synchronized INamespace getNamespace(String id) {
        INamespace result = (INamespace)this._namespaceCache.get(id);
        if (result == null) {
            result = this.findNamespace(id);
            this._namespaceCache.put(id, result);
        }
        return result;
    }

    private synchronized SpecificationParser getParser() {
        if (this._parser == null) {
            this._parser = new SpecificationParser();
        }
        return this._parser;
    }

    public synchronized INamespace getApplicationNamespace() {
        if (this._applicationNamespace == null) {
            this._applicationNamespace = new Namespace(null, null, this._specification, this);
        }
        return this._applicationNamespace;
    }

    public synchronized INamespace getFrameworkNamespace() {
        if (this._frameworkNamespace == null) {
            ILibrarySpecification ls = this.getLibrarySpecification("/net/sf/tapestry/Framework.library");
            this._frameworkNamespace = new Namespace("framework", null, ls, this);
        }
        return this._frameworkNamespace;
    }

    private INamespace findNamespace(String id) {
        StringSplitter splitter = new StringSplitter('.');
        String[] idPath = splitter.splitToArray(id);
        INamespace n = this.getApplicationNamespace();
        int i = 0;
        while (i < idPath.length) {
            n = n.getChildNamespace(idPath[i]);
            ++i;
        }
        return n;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

