/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.engine;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.tapestry.ApplicationRuntimeException;
import net.sf.tapestry.INamespace;
import net.sf.tapestry.ISpecificationSource;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.spec.ComponentSpecification;
import net.sf.tapestry.spec.ILibrarySpecification;

public class Namespace
implements INamespace {
    private ILibrarySpecification _specification;
    private ISpecificationSource _specificationSource;
    private String _id;
    private String _extendedId;
    private INamespace _parent;
    private boolean _frameworkNamespace;
    private boolean _applicationNamespace;
    private Map _pages = new HashMap();
    private Map _components = new HashMap();
    private Map _children = new HashMap();

    public Namespace(String id, INamespace parent, ILibrarySpecification specification, ISpecificationSource specificationSource) {
        this._id = id;
        this._parent = parent;
        this._specification = specification;
        this._specificationSource = specificationSource;
        this._applicationNamespace = this._id == null;
        this._frameworkNamespace = "framework".equals(this._id);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("Namespace@");
        buffer.append(Integer.toHexString(this.hashCode()));
        buffer.append('[');
        if (this._applicationNamespace) {
            buffer.append("<application>");
        } else {
            buffer.append(this.getExtendedId());
        }
        buffer.append(']');
        return buffer.toString();
    }

    public String getId() {
        return this._id;
    }

    public String getExtendedId() {
        if (this._applicationNamespace) {
            return null;
        }
        if (this._extendedId == null) {
            this._extendedId = this.buildExtendedId();
        }
        return this._extendedId;
    }

    public INamespace getParentNamespace() {
        return this._parent;
    }

    public synchronized INamespace getChildNamespace(String id) {
        INamespace result = (INamespace)this._children.get(id);
        if (result == null) {
            result = this.createNamespace(id);
            this._children.put(id, result);
        }
        return result;
    }

    public List getChildIds() {
        return this._specification.getLibraryIds();
    }

    public synchronized ComponentSpecification getPageSpecification(String name) {
        ComponentSpecification result = (ComponentSpecification)this._pages.get(name);
        if (result == null && (result = this.locatePageSpecification(name)) != null) {
            this._pages.put(name, result);
        }
        return result;
    }

    public List getPageNames() {
        return this._specification.getPageNames();
    }

    public synchronized ComponentSpecification getComponentSpecification(String alias) {
        ComponentSpecification result = (ComponentSpecification)this._components.get(alias);
        if (result == null) {
            result = this.locateComponentSpecification(alias);
            this._components.put(alias, result);
        }
        return result;
    }

    public List getComponentAliases() {
        return this._specification.getComponentAliases();
    }

    public String getServiceClassName(String name) {
        return this._specification.getServiceClassName(name);
    }

    public List getServiceNames() {
        return this._specification.getServiceNames();
    }

    public ILibrarySpecification getSpecification() {
        return this._specification;
    }

    private String buildExtendedId() {
        if (this._parent == null) {
            return this._id;
        }
        String parentId = this._parent.getExtendedId();
        if (parentId == null) {
            return this._id;
        }
        return parentId + "." + this._id;
    }

    private String getNamespaceId() {
        if (this._frameworkNamespace) {
            return Tapestry.getString("Namespace.framework-namespace");
        }
        if (this._applicationNamespace) {
            return Tapestry.getString("Namespace.application-namespace");
        }
        return Tapestry.getString("Namespace.nested-namespace", this.getExtendedId());
    }

    private ComponentSpecification locatePageSpecification(String name) {
        String path = this._specification.getPageSpecificationPath(name);
        if (path == null) {
            throw new ApplicationRuntimeException(Tapestry.getString("Namespace.no-such-page", name, this.getNamespaceId()));
        }
        return this._specificationSource.getPageSpecification(path);
    }

    private ComponentSpecification locateComponentSpecification(String alias) {
        String path = this._specification.getComponentSpecificationPath(alias);
        if (path == null) {
            throw new ApplicationRuntimeException(Tapestry.getString("Namespace.no-such-alias", alias, this.getNamespaceId()));
        }
        return this._specificationSource.getComponentSpecification(path);
    }

    private INamespace createNamespace(String id) {
        String path = this._specification.getLibrarySpecificationPath(id);
        if (path == null) {
            throw new ApplicationRuntimeException(Tapestry.getString("Namespace.library-id-not-found", id, this.getNamespaceId()));
        }
        ILibrarySpecification ls = this._specificationSource.getLibrarySpecification(path);
        return new Namespace(id, this, ls, this._specificationSource);
    }

    public boolean containsAlias(String alias) {
        return this._specification.getComponentSpecificationPath(alias) != null;
    }

    public boolean containsPage(String name) {
        return this._specification.getPageSpecificationPath(name) != null;
    }
}

