/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.engine;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import net.sf.tapestry.ApplicationRuntimeException;
import net.sf.tapestry.IComponent;
import net.sf.tapestry.IEngine;
import net.sf.tapestry.IEngineService;
import net.sf.tapestry.IForm;
import net.sf.tapestry.IMarkupWriter;
import net.sf.tapestry.IMonitor;
import net.sf.tapestry.IPage;
import net.sf.tapestry.IPageRecorder;
import net.sf.tapestry.IPageSource;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.ISpecificationSource;
import net.sf.tapestry.PageLoaderException;
import net.sf.tapestry.PageRecorderCommitException;
import net.sf.tapestry.RenderRewoundException;
import net.sf.tapestry.RequestContext;
import net.sf.tapestry.RequestCycleException;
import net.sf.tapestry.StaleLinkException;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.engine.NullWriter;
import net.sf.tapestry.event.ChangeObserver;
import net.sf.tapestry.event.ObservedChangeEvent;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class RequestCycle
implements IRequestCycle,
ChangeObserver {
    private static final Logger LOG = LogManager.getLogger((Class)(class$net$sf$tapestry$engine$RequestCycle == null ? (class$net$sf$tapestry$engine$RequestCycle = RequestCycle.class$("net.sf.tapestry.engine.RequestCycle")) : class$net$sf$tapestry$engine$RequestCycle));
    private IPage _page;
    private IEngine _engine;
    private IEngineService _service;
    private RequestContext _requestContext;
    private IMonitor _monitor;
    private HttpServletResponse _response;
    private Map _loadedPages;
    private Map _loadedRecorders;
    private boolean _rewinding = false;
    private Map _attributes;
    private int _actionId;
    private int _targetActionId;
    private IComponent _targetComponent;
    private Object[] _serviceParameters;
    static /* synthetic */ Class class$net$sf$tapestry$engine$RequestCycle;

    public RequestCycle(IEngine engine, RequestContext requestContext, IMonitor monitor) {
        this._engine = engine;
        this._requestContext = requestContext;
        this._monitor = monitor;
    }

    public void cleanup() {
        if (this._loadedPages == null) {
            return;
        }
        IPageSource source = this._engine.getPageSource();
        Iterator i = this._loadedPages.values().iterator();
        while (i.hasNext()) {
            IPage page = (IPage)i.next();
            source.releasePage(page);
        }
        this._loadedPages = null;
        this._loadedRecorders = null;
    }

    public IEngineService getService() {
        return this._service;
    }

    public void setService(IEngineService value) {
        this._service = value;
    }

    public String encodeURL(String URL2) {
        if (this._response == null) {
            this._response = this._requestContext.getResponse();
        }
        return this._response.encodeURL(URL2);
    }

    public IEngine getEngine() {
        return this._engine;
    }

    public Object getAttribute(String name) {
        if (this._attributes == null) {
            return null;
        }
        return this._attributes.get(name);
    }

    public IMonitor getMonitor() {
        return this._monitor;
    }

    public String getNextActionId() {
        return Integer.toHexString(++this._actionId);
    }

    public IPage getPage() {
        return this._page;
    }

    public IPage getPage(String name) {
        IPage result = null;
        if (name == null) {
            throw new NullPointerException(Tapestry.getString("RequestCycle.invalid-null-name"));
        }
        if (this._monitor != null) {
            this._monitor.pageLoadBegin(name);
        }
        if (this._loadedPages != null) {
            result = (IPage)this._loadedPages.get(name);
        }
        if (result == null) {
            ISpecificationSource specSource = this._engine.getSpecificationSource();
            IPageSource pageSource = this._engine.getPageSource();
            try {
                result = pageSource.getPage(this, name, this._monitor);
            }
            catch (PageLoaderException ex) {
                throw new ApplicationRuntimeException(Tapestry.getString("RequestCycle.could-not-acquire-page", name), ex);
            }
            result.setRequestCycle(this);
            IPageRecorder recorder = this.getPageRecorder(name);
            if (recorder != null) {
                recorder.rollback(result);
                result.setChangeObserver(recorder);
                recorder.setLocked(false);
            } else {
                result.setChangeObserver(this);
            }
            if (this._loadedPages == null) {
                this._loadedPages = new HashMap();
            }
            this._loadedPages.put(name, result);
        }
        if (this._monitor != null) {
            this._monitor.pageLoadEnd(name);
        }
        return result;
    }

    protected IPageRecorder getPageRecorder(String name) {
        IPageRecorder result = null;
        if (this._loadedRecorders != null) {
            result = (IPageRecorder)this._loadedRecorders.get(name);
        }
        if (result != null) {
            return result;
        }
        result = this._engine.getPageRecorder(name);
        if (result == null) {
            return null;
        }
        if (this._loadedRecorders == null) {
            this._loadedRecorders = new HashMap();
        }
        this._loadedRecorders.put(name, result);
        return result;
    }

    private IPageRecorder createPageRecorder(String name) {
        IPageRecorder result = this.getPageRecorder(name);
        if (result == null) {
            result = this._engine.createPageRecorder(name, this);
            if (this._loadedRecorders == null) {
                this._loadedRecorders = new HashMap();
            }
            this._loadedRecorders.put(name, result);
        }
        return result;
    }

    public RequestContext getRequestContext() {
        return this._requestContext;
    }

    public boolean isRewinding() {
        return this._rewinding;
    }

    public boolean isRewound(IComponent component) throws StaleLinkException {
        if (!this._rewinding) {
            return false;
        }
        if (this._actionId != this._targetActionId) {
            return false;
        }
        if (component == this._targetComponent) {
            return true;
        }
        throw new StaleLinkException(component, Integer.toHexString(this._targetActionId), this._targetComponent.getExtendedId());
    }

    public void removeAttribute(String name) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing attribute " + name));
        }
        if (this._attributes == null) {
            return;
        }
        this._attributes.remove(name);
    }

    public void renderPage(IMarkupWriter writer) throws RequestCycleException {
        String pageName = null;
        if (this._monitor != null) {
            pageName = this._page.getName();
            this._monitor.pageRenderBegin(pageName);
        }
        this._rewinding = false;
        this._actionId = -1;
        this._targetActionId = 0;
        if (this._attributes != null) {
            this._attributes.clear();
        }
        try {
            try {
                this._page.renderPage(writer, this);
            }
            catch (RequestCycleException ex) {
                throw ex;
            }
            catch (ApplicationRuntimeException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new RequestCycleException(ex.getMessage(), this._page, ex);
            }
            Object var7_3 = null;
            this._actionId = 0;
            this._targetActionId = 0;
        }
        catch (Throwable throwable) {
            Object var7_4 = null;
            this._actionId = 0;
            this._targetActionId = 0;
            throw throwable;
        }
        if (this._monitor != null) {
            this._monitor.pageRenderEnd(pageName);
        }
    }

    public void rewindForm(IForm form, String targetActionId) throws RequestCycleException {
        IPage page = form.getPage();
        String pageName = null;
        if (this._monitor != null) {
            pageName = page.getName();
            this._monitor.pageRewindBegin(pageName);
        }
        this._rewinding = true;
        if (this._attributes != null) {
            this._attributes.clear();
        }
        this._targetActionId = Integer.parseInt(targetActionId, 16);
        this._actionId = this._targetActionId - 1;
        this._targetComponent = form;
        try {
            try {
                page.beginPageRender();
                form.rewind(NullWriter.getSharedInstance(), this);
                throw new StaleLinkException(Tapestry.getString("RequestCycle.form-rewind-failure", form.getExtendedId()), form);
            }
            catch (RenderRewoundException ex) {
                Object var9_6 = null;
                this._rewinding = false;
                this._actionId = 0;
                this._targetActionId = 0;
                this._targetComponent = null;
                page.endPageRender();
            }
            catch (RequestCycleException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new RequestCycleException(ex.getMessage(), page, ex);
            }
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            this._rewinding = false;
            this._actionId = 0;
            this._targetActionId = 0;
            this._targetComponent = null;
            page.endPageRender();
            throw throwable;
        }
        if (this._monitor != null) {
            this._monitor.pageRewindEnd(pageName);
        }
    }

    public void rewindPage(String targetActionId, IComponent targetComponent) throws RequestCycleException {
        String pageName = null;
        if (this._monitor != null) {
            pageName = this._page.getName();
            this._monitor.pageRewindBegin(pageName);
        }
        this._rewinding = true;
        if (this._attributes != null) {
            this._attributes.clear();
        }
        this._actionId = -1;
        this._targetActionId = Integer.parseInt(targetActionId, 16);
        this._targetComponent = targetComponent;
        try {
            try {
                this._page.renderPage(NullWriter.getSharedInstance(), this);
                throw new StaleLinkException(this._page, targetActionId, targetComponent.getExtendedId());
            }
            catch (RenderRewoundException ex) {
                Object var8_5 = null;
                this._rewinding = false;
                this._actionId = 0;
                this._targetActionId = 0;
                this._targetComponent = null;
            }
            catch (RequestCycleException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new RequestCycleException(ex.getMessage(), this._page, ex);
            }
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            this._rewinding = false;
            this._actionId = 0;
            this._targetActionId = 0;
            this._targetComponent = null;
            throw throwable;
        }
        if (this._monitor != null) {
            this._monitor.pageRewindEnd(pageName);
        }
    }

    public void setAttribute(String name, Object value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Set attribute " + name + " to " + value));
        }
        if (this._attributes == null) {
            this._attributes = new HashMap();
        }
        this._attributes.put(name, value);
    }

    public void setPage(IPage value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Set page to " + value));
        }
        this._page = value;
    }

    public void setPage(String name) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Set page to " + name));
        }
        this._page = this.getPage(name);
    }

    public void commitPageChanges() throws PageRecorderCommitException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Committing page changes");
        }
        if (this._loadedRecorders == null || this._loadedRecorders.isEmpty()) {
            return;
        }
        Iterator i = this._loadedRecorders.values().iterator();
        while (i.hasNext()) {
            IPageRecorder recorder = (IPageRecorder)i.next();
            recorder.commit();
        }
    }

    public void observeChange(ObservedChangeEvent event) {
        IPage page = event.getComponent().getPage();
        String pageName = page.getName();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Observed change in page " + pageName + "; creating page recorder."));
        }
        IPageRecorder recorder = this.createPageRecorder(pageName);
        page.setChangeObserver(recorder);
        recorder.observeChange(event);
    }

    public void discardPage(String name) {
        IPageRecorder recorder;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Discarding page " + name));
        }
        if ((recorder = this._engine.getPageRecorder(name)) == null) {
            this._page = this.getPage(name);
            recorder = this.createPageRecorder(name);
            this._page.setChangeObserver(recorder);
        }
        recorder.markForDiscard();
    }

    public Object[] getServiceParameters() {
        return this._serviceParameters;
    }

    public void setServiceParameters(Object[] serviceParameters) {
        this._serviceParameters = serviceParameters;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

