/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.engine;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.tapestry.ApplicationRuntimeException;
import net.sf.tapestry.IPageRecorder;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.engine.AbstractEngine;
import net.sf.tapestry.record.SimplePageRecorder;

public class SimpleEngine
extends AbstractEngine {
    private static final long serialVersionUID = -1658741363570905534L;
    private static final int MAP_SIZE = 3;
    private Map recorders;

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int count = in.readInt();
        if (count == 0) {
            return;
        }
        this.recorders = new HashMap(3);
        int i = 0;
        while (i < count) {
            String pageName = in.readUTF();
            SimplePageRecorder recorder = (SimplePageRecorder)in.readObject();
            this.recorders.put(pageName, recorder);
            ++i;
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        if (this.recorders == null) {
            out.writeInt(0);
            return;
        }
        out.writeInt(this.recorders.size());
        Iterator i = this.recorders.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            out.writeUTF((String)entry.getKey());
            out.writeObject(entry.getValue());
        }
    }

    protected void cleanupAfterRequest(IRequestCycle cycle) {
        if (this.recorders == null) {
            return;
        }
        Iterator i = this.recorders.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            IPageRecorder recorder = (IPageRecorder)entry.getValue();
            if (recorder.getHasChanges() && !recorder.isMarkedForDiscard()) continue;
            i.remove();
        }
    }

    public void forgetPage(String name) {
        if (this.recorders == null) {
            return;
        }
        IPageRecorder recorder = (IPageRecorder)this.recorders.get(name);
        if (recorder == null) {
            return;
        }
        if (recorder.isDirty()) {
            throw new ApplicationRuntimeException(Tapestry.getString("SimpleEngine.recorder-has-uncommited-changes", name));
        }
        this.recorders.remove(name);
    }

    public Collection getActivePageNames() {
        if (this.recorders == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableCollection(this.recorders.keySet());
    }

    public IPageRecorder getPageRecorder(String pageName) {
        if (this.recorders == null) {
            return null;
        }
        return (IPageRecorder)this.recorders.get(pageName);
    }

    public IPageRecorder createPageRecorder(String pageName, IRequestCycle cycle) {
        if (this.recorders == null) {
            this.recorders = new HashMap(3);
        } else if (this.recorders.containsKey(pageName)) {
            throw new ApplicationRuntimeException(Tapestry.getString("SimpleEngine.duplicate-page-recorder", pageName));
        }
        SimplePageRecorder result = new SimplePageRecorder();
        this.recorders.put(pageName, result);
        cycle.getRequestContext().createSession();
        this.setStateful();
        return result;
    }
}

