/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.form;

import net.sf.tapestry.IForm;
import net.sf.tapestry.IMarkupWriter;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.RequestCycleException;
import net.sf.tapestry.form.AbstractFormComponent;

public abstract class AbstractTextField
extends AbstractFormComponent {
    private int _displayWidth;
    private int _maximumLength;
    private boolean _hidden;
    private boolean _disabled;
    private String _name;

    public String getName() {
        return this._name;
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
        String value2;
        IForm form = this.getForm(cycle);
        boolean rewinding = form.isRewinding();
        if (!rewinding && cycle.isRewinding()) {
            return;
        }
        this._name = form.getElementId(this);
        if (rewinding) {
            if (!this._disabled) {
                String value2 = cycle.getRequestContext().getParameter(this._name);
                this.updateValue(value2);
            }
            return;
        }
        writer.beginEmpty("input");
        writer.attribute("type", this._hidden ? "password" : "text");
        if (this._disabled) {
            writer.attribute("disabled");
        }
        writer.attribute("name", this._name);
        if (this._displayWidth != 0) {
            writer.attribute("size", this._displayWidth);
        }
        if (this._maximumLength != 0) {
            writer.attribute("maxlength", this._maximumLength);
        }
        if ((value2 = this.readValue()) != null) {
            writer.attribute("value", value2);
        }
        this.generateAttributes(writer, cycle);
        this.beforeCloseTag(writer, cycle);
        writer.closeTag();
    }

    protected void beforeCloseTag(IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
    }

    protected abstract void updateValue(String var1) throws RequestCycleException;

    protected abstract String readValue() throws RequestCycleException;

    public boolean getHidden() {
        return this._hidden;
    }

    public void setHidden(boolean hidden) {
        this._hidden = hidden;
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public void setDisabled(boolean disabled) {
        this._disabled = disabled;
    }

    public int getDisplayWidth() {
        return this._displayWidth;
    }

    public void setDisplayWidth(int displayWidth) {
        this._displayWidth = displayWidth;
    }

    public int getMaximumLength() {
        return this._maximumLength;
    }

    public void setMaximumLength(int maximumLength) {
        this._maximumLength = maximumLength;
    }
}

