/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.form;

import java.util.ResourceBundle;
import net.sf.tapestry.form.IPropertySelectionModel;
import net.sf.tapestry.util.Enum;

public class EnumPropertySelectionModel
implements IPropertySelectionModel {
    private Enum[] options;
    private String[] labels;
    private String resourcePrefix;
    private ResourceBundle bundle;

    public EnumPropertySelectionModel(Enum[] options, ResourceBundle bundle, String resourcePrefix) {
        this.options = options;
        this.bundle = bundle;
        this.resourcePrefix = resourcePrefix;
    }

    public EnumPropertySelectionModel(Enum[] options, ResourceBundle bundle) {
        this.options = options;
        this.bundle = bundle;
    }

    public int getOptionCount() {
        return this.options.length;
    }

    public Object getOption(int index) {
        return this.options[index];
    }

    public String getLabel(int index) {
        if (this.labels == null) {
            this.readLabels();
        }
        return this.labels[index];
    }

    public String getValue(int index) {
        return Integer.toString(index);
    }

    public Object translateValue(String value) {
        int index = Integer.parseInt(value);
        return this.options[index];
    }

    private void readLabels() {
        this.labels = new String[this.options.length];
        int i = 0;
        while (i < this.options.length) {
            String enumerationId = this.options[i].getEnumerationId();
            String key = this.resourcePrefix == null ? enumerationId : this.resourcePrefix + "." + enumerationId;
            this.labels[i] = this.bundle.getString(key);
            ++i;
        }
    }
}

