/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.form;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.tapestry.AbstractComponent;
import net.sf.tapestry.IActionListener;
import net.sf.tapestry.IBinding;
import net.sf.tapestry.IForm;
import net.sf.tapestry.IMarkupWriter;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.RequestContext;
import net.sf.tapestry.RequestCycleException;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.form.Form;
import net.sf.tapestry.util.io.DataSqueezer;

public class ListEdit
extends AbstractComponent {
    private IBinding _valueBinding;
    private IBinding _indexBinding;
    private Object _source;
    private String _element;
    private IActionListener _listener;

    public void setValueBinding(IBinding value) {
        this._valueBinding = value;
    }

    public IBinding getValueBinding() {
        return this._valueBinding;
    }

    public void setIndexBinding(IBinding value) {
        this._indexBinding = value;
    }

    public IBinding getIndexBinding() {
        return this._indexBinding;
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
        int count;
        ISource source = null;
        RequestContext context = null;
        Object value = null;
        IForm form = Form.get(cycle);
        if (form == null) {
            throw new RequestCycleException(Tapestry.getString("must-be-wrapped-by-form", "ListEdit"), this);
        }
        boolean cycleRewinding = cycle.isRewinding();
        boolean formRewinding = form.isRewinding();
        if (cycleRewinding && !form.isRewinding()) {
            return;
        }
        String name = form.getElementId(this);
        if (!cycleRewinding) {
            source = this.getSourceData();
            count = source.getCount();
            writer.beginEmpty("input");
            writer.attribute("type", "hidden");
            writer.attribute("name", name);
            writer.attribute("value", count);
            writer.println();
        } else {
            context = cycle.getRequestContext();
            count = Integer.parseInt(context.getParameter(name));
        }
        int i = 0;
        while (i < count) {
            if (this._indexBinding != null) {
                this._indexBinding.setInt(i);
            }
            if (cycleRewinding) {
                value = this.extractValue(context, form.getElementId(this));
            } else {
                value = source.get(i);
                this.writeValue(writer, form.getElementId(this), value);
            }
            this._valueBinding.setObject(value);
            if (this._listener != null) {
                this._listener.actionTriggered(this, cycle);
            }
            if (this._element != null) {
                writer.begin(this._element);
                this.generateAttributes(writer, cycle);
            }
            this.renderBody(writer, cycle);
            if (this._element != null) {
                writer.end();
            }
            ++i;
        }
    }

    private void writeValue(IMarkupWriter writer, String name, Object value) throws RequestCycleException {
        String externalValue;
        try {
            externalValue = this.getDataSqueezer().squeeze(value);
        }
        catch (IOException ex) {
            throw new RequestCycleException(Tapestry.getString("ListEdit.unable-to-convert-value", value), this, ex);
        }
        writer.beginEmpty("input");
        writer.attribute("type", "hidden");
        writer.attribute("name", name);
        writer.attribute("value", externalValue);
        writer.println();
    }

    private Object extractValue(RequestContext context, String name) throws RequestCycleException {
        String value = context.getParameter(name);
        try {
            return this.getDataSqueezer().unsqueeze(value);
        }
        catch (IOException ex) {
            throw new RequestCycleException(Tapestry.getString("ListEdit.unable-to-convert-string", value), this, ex);
        }
    }

    private ISource getSourceData() throws RequestCycleException {
        if (this._source == null) {
            return new EmptySource();
        }
        if (this._source instanceof List) {
            return new ListSource((List)this._source);
        }
        if (this._source.getClass().isArray()) {
            return new ArraySource((Object[])this._source);
        }
        if (this._source instanceof Iterator) {
            Iterator i = (Iterator)this._source;
            ArrayList list = new ArrayList();
            while (i.hasNext()) {
                list.add(i.next());
            }
            return new ListSource(list);
        }
        throw new RequestCycleException(Tapestry.getString("ListEdit.unable-to-convert-source", this._source), this);
    }

    public String getElement() {
        return this._element;
    }

    public void setElement(String element) {
        this._element = element;
    }

    public void setSource(Object source) {
        this._source = source;
    }

    public Object getSource() {
        return this._source;
    }

    private DataSqueezer getDataSqueezer() {
        return this.getPage().getEngine().getDataSqueezer();
    }

    public IActionListener getListener() {
        return this._listener;
    }

    public void setListener(IActionListener listener) {
        this._listener = listener;
    }

    private static class EmptySource
    implements ISource {
        private EmptySource() {
        }

        public int getCount() {
            return 0;
        }

        public Object get(int index) {
            throw new IndexOutOfBoundsException("ListEdit.EmptySource contains no values.");
        }
    }

    private static class ListSource
    implements ISource {
        List _list;

        ListSource(List list) {
            this._list = list;
        }

        public int getCount() {
            return this._list.size();
        }

        public Object get(int index) {
            return this._list.get(index);
        }
    }

    private static class ArraySource
    implements ISource {
        Object[] _array;

        ArraySource(Object[] array) {
            this._array = array;
        }

        public int getCount() {
            return this._array.length;
        }

        public Object get(int index) {
            return this._array[index];
        }
    }

    private static interface ISource {
        public int getCount();

        public Object get(int var1);
    }
}

