/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.form;

import net.sf.tapestry.AbstractComponent;
import net.sf.tapestry.IBinding;
import net.sf.tapestry.IMarkupWriter;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.RequestCycleException;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.form.Select;

public class Option
extends AbstractComponent {
    private IBinding _selectedBinding;
    private String _label;

    public IBinding getSelectedBinding() {
        return this._selectedBinding;
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
        Select select = Select.get(cycle);
        if (select == null) {
            throw new RequestCycleException(Tapestry.getString("Option.must-be-contained-by-select"), this);
        }
        boolean rewinding = select.isRewinding();
        String value = select.getNextOptionId();
        if (rewinding) {
            if (!select.isDisabled()) {
                this._selectedBinding.setBoolean(select.isSelected(value));
            }
        } else {
            writer.beginEmpty("option");
            writer.attribute("value", value);
            if (this._selectedBinding.getBoolean()) {
                writer.attribute("selected");
            }
            this.generateAttributes(writer, cycle);
            if (this._label != null) {
                writer.print(this._label);
            }
            writer.println();
        }
    }

    public void setSelectedBinding(IBinding value) {
        this._selectedBinding = value;
    }

    public String getLabel() {
        return this._label;
    }

    public void setLabel(String label) {
        this._label = label;
    }
}

