/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.form;

import net.sf.tapestry.IForm;
import net.sf.tapestry.IMarkupWriter;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.RequestCycleException;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.form.AbstractFormComponent;
import net.sf.tapestry.form.IPropertySelectionModel;
import net.sf.tapestry.form.IPropertySelectionRenderer;
import net.sf.tapestry.form.RadioPropertySelectionRenderer;
import net.sf.tapestry.form.SelectPropertySelectionRenderer;

public class PropertySelection
extends AbstractFormComponent {
    private Object _value;
    private IPropertySelectionRenderer _renderer;
    private IPropertySelectionModel _model;
    private boolean _disabled;
    private String _name;
    private boolean _submitOnChange;
    public static final IPropertySelectionRenderer DEFAULT_SELECT_RENDERER = new SelectPropertySelectionRenderer();
    public static final IPropertySelectionRenderer DEFAULT_RADIO_RENDERER = new RadioPropertySelectionRenderer();

    public String getName() {
        return this._name;
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
        IForm form = this.getForm(cycle);
        if (form == null) {
            throw new RequestCycleException(Tapestry.getString("must-be-wrapped-by-form", "PropertySelection"), this);
        }
        boolean rewinding = form.isRewinding();
        this._name = form.getElementId(this);
        if (rewinding) {
            if (this._disabled) {
                return;
            }
            String optionValue = cycle.getRequestContext().getParameter(this._name);
            this._value = optionValue == null ? null : this._model.translateValue(optionValue);
            return;
        }
        if (this._renderer != null) {
            this.renderWithRenderer(writer, cycle, this._renderer);
            return;
        }
        writer.begin("select");
        writer.attribute("name", this._name);
        if (this._disabled) {
            writer.attribute("disabled");
        }
        if (this._submitOnChange) {
            writer.attribute("onchange", "javascript:this.form.submit();");
        }
        this.generateAttributes(writer, cycle);
        writer.println();
        int count = this._model.getOptionCount();
        boolean foundSelected = false;
        boolean selected = false;
        int i = 0;
        while (i < count) {
            Object option = this._model.getOption(i);
            if (!foundSelected && (selected = this.isEqual(option, this._value))) {
                foundSelected = true;
            }
            writer.begin("option");
            writer.attribute("value", this._model.getValue(i));
            if (selected) {
                writer.attribute("selected");
            }
            writer.print(this._model.getLabel(i));
            writer.end();
            writer.println();
            selected = false;
            ++i;
        }
        writer.end();
    }

    private void renderWithRenderer(IMarkupWriter writer, IRequestCycle cycle, IPropertySelectionRenderer renderer) throws RequestCycleException {
        renderer.beginRender(this, writer, cycle);
        int count = this._model.getOptionCount();
        boolean foundSelected = false;
        boolean selected = false;
        int i = 0;
        while (i < count) {
            Object option = this._model.getOption(i);
            if (!foundSelected && (selected = this.isEqual(option, this._value))) {
                foundSelected = true;
            }
            renderer.renderOption(this, writer, cycle, this._model, option, i, selected);
            selected = false;
            ++i;
        }
        renderer.endRender(this, writer, cycle);
    }

    private boolean isEqual(Object left, Object right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        return left.equals(right);
    }

    public void setDisabled(boolean disabled) {
        this._disabled = disabled;
    }

    public IPropertySelectionModel getModel() {
        return this._model;
    }

    public void setModel(IPropertySelectionModel model) {
        this._model = model;
    }

    public IPropertySelectionRenderer getRenderer() {
        return this._renderer;
    }

    public void setRenderer(IPropertySelectionRenderer renderer) {
        this._renderer = renderer;
    }

    public boolean getSubmitOnChange() {
        return this._submitOnChange;
    }

    public void setSubmitOnChange(boolean submitOnChange) {
        this._submitOnChange = submitOnChange;
    }

    public Object getValue() {
        return this._value;
    }

    public void setValue(Object value) {
        this._value = value;
    }
}

