/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.form;

import net.sf.tapestry.AbstractComponent;
import net.sf.tapestry.IMarkupWriter;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.RequestCycleException;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.form.RadioGroup;

public class Radio
extends AbstractComponent {
    private Object _value;
    private boolean _disabled;

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
        RadioGroup group = RadioGroup.get(cycle);
        if (group == null) {
            throw new RequestCycleException(Tapestry.getString("Radio.must-be-contained-by-group"), this);
        }
        boolean rewinding = group.isRewinding();
        int option = group.getNextOptionId();
        if (rewinding) {
            if (!this._disabled && group.isSelected(option)) {
                group.updateSelection(this._value);
            }
            return;
        }
        writer.beginEmpty("input");
        writer.attribute("type", "radio");
        writer.attribute("name", group.getName());
        if (group.isSelection(this._value)) {
            writer.attribute("checked");
        }
        if (this._disabled || group.isDisabled()) {
            writer.attribute("disabled");
        }
        writer.attribute("value", option);
        this.generateAttributes(writer, cycle);
    }

    public boolean getDisabled() {
        return this._disabled;
    }

    public void setDisabled(boolean disabled) {
        this._disabled = disabled;
    }

    public Object getValue() {
        return this._value;
    }

    public void setValue(Object value) {
        this._value = value;
    }
}

