/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.form;

import java.util.HashSet;
import java.util.Set;
import net.sf.tapestry.IForm;
import net.sf.tapestry.IMarkupWriter;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.RenderOnlyPropertyException;
import net.sf.tapestry.RequestContext;
import net.sf.tapestry.RequestCycleException;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.form.AbstractFormComponent;

public class Select
extends AbstractFormComponent {
    private boolean _multiple;
    private boolean _disabled;
    private boolean _rewinding;
    private boolean _rendering;
    private Set _selections;
    private int _nextOptionId;
    private String _name;
    private static final String ATTRIBUTE_NAME = "net.sf.tapestry.active.Select";

    public String getName() {
        return this._name;
    }

    public static Select get(IRequestCycle cycle) {
        return (Select)cycle.getAttribute(ATTRIBUTE_NAME);
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public boolean isMultiple() {
        return this._multiple;
    }

    public void setMultiple(boolean newValue) {
        this._multiple = newValue;
    }

    public boolean isRewinding() {
        if (!this._rendering) {
            throw new RenderOnlyPropertyException(this, "rewinding");
        }
        return this._rewinding;
    }

    public String getNextOptionId() {
        if (!this._rendering) {
            throw new RenderOnlyPropertyException(this, "nextOptionId");
        }
        return Integer.toString(this._nextOptionId++);
    }

    public boolean isSelected(String value) {
        if (this._selections == null) {
            return false;
        }
        return this._selections.contains(value);
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
        IForm form = this.getForm(cycle);
        if (cycle.getAttribute(ATTRIBUTE_NAME) != null) {
            throw new RequestCycleException(Tapestry.getString("Select.may-not-nest"), this);
        }
        this._rewinding = form.isRewinding();
        this._name = form.getElementId(this);
        cycle.setAttribute(ATTRIBUTE_NAME, this);
        if (this._rewinding) {
            this._selections = this.buildSelections(cycle, this._name);
        } else {
            writer.begin("select");
            writer.attribute("name", this._name);
            if (this._multiple) {
                writer.attribute("multiple");
            }
            if (this._disabled) {
                writer.attribute("disabled");
            }
            this.generateAttributes(writer, cycle);
        }
        this._rendering = true;
        this._nextOptionId = 0;
        this.renderBody(writer, cycle);
        if (!this._rewinding) {
            writer.end();
        }
        cycle.removeAttribute(ATTRIBUTE_NAME);
    }

    protected void cleanupAfterRender(IRequestCycle cycle) {
        this._rendering = false;
        this._selections = null;
        super.cleanupAfterRender(cycle);
    }

    private Set buildSelections(IRequestCycle cycle, String parameterName) {
        RequestContext context = cycle.getRequestContext();
        String[] parameters = context.getParameters(parameterName);
        if (parameters == null) {
            return null;
        }
        int length = parameters.length;
        if (parameters.length == 0) {
            return null;
        }
        int size = parameters.length > 30 ? 101 : 7;
        HashSet<String> result = new HashSet<String>(size);
        int i = 0;
        while (i < length) {
            result.add(parameters[i]);
            ++i;
        }
        return result;
    }
}

