/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.form;

import net.sf.tapestry.IActionListener;
import net.sf.tapestry.IBinding;
import net.sf.tapestry.IForm;
import net.sf.tapestry.IMarkupWriter;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.RequestCycleException;
import net.sf.tapestry.form.AbstractFormComponent;

public class Submit
extends AbstractFormComponent {
    private String _label;
    private IActionListener _listener;
    private boolean _disabled;
    private Object _tag;
    private IBinding _selectedBinding;
    private String _name;

    public String getName() {
        return this._name;
    }

    public void setSelectedBinding(IBinding value) {
        this._selectedBinding = value;
    }

    public IBinding getSelectedBinding() {
        return this._selectedBinding;
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
        IForm form = this.getForm(cycle);
        boolean rewinding = form.isRewinding();
        this._name = form.getElementId(this);
        if (rewinding) {
            if (this._disabled) {
                return;
            }
            String value = cycle.getRequestContext().getParameter(this._name);
            if (value == null) {
                return;
            }
            if (this._selectedBinding != null) {
                this._selectedBinding.setObject(this._tag);
            }
            if (this._listener != null) {
                this._listener.actionTriggered(this, cycle);
            }
            return;
        }
        writer.beginEmpty("input");
        writer.attribute("type", "submit");
        writer.attribute("name", this._name);
        if (this._disabled) {
            writer.attribute("disabled");
        }
        if (this._label != null) {
            writer.attribute("value", this._label);
        }
        this.generateAttributes(writer, cycle);
        writer.closeTag();
    }

    public String getLabel() {
        return this._label;
    }

    public void setLabel(String label) {
        this._label = label;
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public void setDisabled(boolean disabled) {
        this._disabled = disabled;
    }

    public IActionListener getListener() {
        return this._listener;
    }

    public void setListener(IActionListener listener) {
        this._listener = listener;
    }

    public Object getTag() {
        return this._tag;
    }

    public void setTag(Object tag) {
        this._tag = tag;
    }
}

