/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.html;

import java.io.OutputStream;
import net.sf.tapestry.AbstractMarkupWriter;
import net.sf.tapestry.IMarkupWriter;
import net.sf.tapestry.html.NestedHTMLWriter;

public class HTMLWriter
extends AbstractMarkupWriter {
    private static final String[] entities = new String[64];
    private static final boolean[] safe = new boolean[128];
    private static final String SAFE_CHARACTERS = "01234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ\t\n\r !\"#$%'()*+,-./:;=?@[\\]^_`{|}~";

    public HTMLWriter(String contentType, OutputStream outputStream) {
        super(safe, entities, contentType, outputStream);
    }

    protected HTMLWriter(String contentType) {
        super(safe, entities, contentType);
    }

    public HTMLWriter(OutputStream outputStream) {
        this("text/html; charset=utf-8", outputStream);
    }

    public IMarkupWriter getNestedWriter() {
        return new NestedHTMLWriter(this);
    }

    static {
        HTMLWriter.entities[34] = "&quot;";
        HTMLWriter.entities[60] = "&lt;";
        HTMLWriter.entities[62] = "&gt;";
        HTMLWriter.entities[38] = "&amp;";
        int length = SAFE_CHARACTERS.length();
        int i = 0;
        while (i < length) {
            HTMLWriter.safe[SAFE_CHARACTERS.charAt((int)i)] = true;
            ++i;
        }
    }
}

