/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.html;

import java.util.HashMap;
import net.sf.tapestry.AbstractComponent;
import net.sf.tapestry.IAsset;
import net.sf.tapestry.IEngine;
import net.sf.tapestry.IMarkupWriter;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.IScript;
import net.sf.tapestry.IScriptSource;
import net.sf.tapestry.RequestCycleException;
import net.sf.tapestry.RequiredParameterException;
import net.sf.tapestry.ScriptException;
import net.sf.tapestry.ScriptSession;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.components.IServiceLink;
import net.sf.tapestry.components.ServiceLinkEventType;
import net.sf.tapestry.html.Body;

public class Rollover
extends AbstractComponent {
    private IScript _parsedScript;
    private IAsset _image;
    private IAsset _blur;
    private IAsset _focus;
    private IAsset _disabled;

    protected String getAssetURL(IAsset asset, IRequestCycle cycle) throws RequestCycleException {
        if (asset == null) {
            return null;
        }
        return asset.buildURL(cycle);
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
        String imageURL = null;
        String focusURL = null;
        String blurURL = null;
        Object uniqueId = null;
        Object onMouseOverName = null;
        boolean dynamic = false;
        Object onMouseOutName = null;
        Object focusImageName = null;
        Object blurImageName = null;
        String imageName = null;
        Body body = Body.get(cycle);
        if (body == null) {
            throw new RequestCycleException(Tapestry.getString("Rollover.must-be-contained-by-body"), this);
        }
        IServiceLink serviceLink = (IServiceLink)cycle.getAttribute("net.sf.tapestry.active.IServiceLink");
        if (serviceLink == null) {
            throw new RequestCycleException(Tapestry.getString("Rollover.must-be-contained-by-link"), this);
        }
        if (cycle.isRewinding()) {
            return;
        }
        boolean linkDisabled = serviceLink.isDisabled();
        if (linkDisabled) {
            imageURL = this.getAssetURL(this._disabled, cycle);
            if (imageURL == null) {
                imageURL = this.getAssetURL(this._image, cycle);
            }
        } else {
            imageURL = this.getAssetURL(this._image, cycle);
            focusURL = this.getAssetURL(this._focus, cycle);
            blurURL = this.getAssetURL(this._blur, cycle);
            boolean bl = dynamic = focusURL != null || blurURL != null;
        }
        if (imageURL == null) {
            throw new RequiredParameterException(this, "image", null);
        }
        writer.beginEmpty("img");
        writer.attribute("src", imageURL);
        writer.attribute("border", 0);
        if (dynamic) {
            if (focusURL == null) {
                focusURL = imageURL;
            }
            if (blurURL == null) {
                blurURL = imageURL;
            }
            try {
                imageName = this.writeScript(body, serviceLink, focusURL, blurURL);
            }
            catch (ScriptException ex) {
                throw new RequestCycleException(this, (Throwable)ex);
            }
            writer.attribute("name", imageName);
        }
        this.generateAttributes(writer, cycle);
        writer.closeTag();
    }

    private IScript getParsedScript() {
        if (this._parsedScript == null) {
            IEngine engine = this.getPage().getEngine();
            IScriptSource source = engine.getScriptSource();
            this._parsedScript = source.getScript("/net/sf/tapestry/html/Rollover.script");
        }
        return this._parsedScript;
    }

    private String writeScript(Body body, IServiceLink link, String focusURL, String blurURL) throws ScriptException {
        String uniqueId = body.getUniqueId();
        String focusImageURL = body.getPreloadedImageReference(focusURL);
        String blurImageURL = body.getPreloadedImageReference(blurURL);
        HashMap<String, String> symbols = new HashMap<String, String>();
        symbols.put("uniqueId", uniqueId);
        symbols.put("focusImageURL", focusImageURL);
        symbols.put("blurImageURL", blurImageURL);
        ScriptSession session = this.getParsedScript().execute(symbols);
        body.process(session);
        link.addEventHandler(ServiceLinkEventType.MOUSE_OVER, (String)symbols.get("onMouseOverName"));
        link.addEventHandler(ServiceLinkEventType.MOUSE_OUT, (String)symbols.get("onMouseOutName"));
        String imageName = (String)symbols.get("imageName");
        return imageName;
    }

    public IAsset getBlur() {
        return this._blur;
    }

    public void setBlur(IAsset blur) {
        this._blur = blur;
    }

    public IAsset getDisabled() {
        return this._disabled;
    }

    public void setDisabled(IAsset disabled) {
        this._disabled = disabled;
    }

    public IAsset getFocus() {
        return this._focus;
    }

    public void setFocus(IAsset focus) {
        this._focus = focus;
    }

    public IAsset getImage() {
        return this._image;
    }

    public void setImage(IAsset image) {
        this._image = image;
    }
}

