/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.inspector;

import java.util.HashMap;
import javax.servlet.http.HttpSession;
import net.sf.tapestry.BaseComponent;
import net.sf.tapestry.Gesture;
import net.sf.tapestry.IDirect;
import net.sf.tapestry.IEngine;
import net.sf.tapestry.IEngineService;
import net.sf.tapestry.IMarkupWriter;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.IScript;
import net.sf.tapestry.IScriptSource;
import net.sf.tapestry.RequestCycleException;
import net.sf.tapestry.ScriptException;
import net.sf.tapestry.ScriptSession;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.html.Body;
import net.sf.tapestry.inspector.Inspector;

public class InspectorButton
extends BaseComponent
implements IDirect {
    private boolean _disabled = false;

    public void trigger(IRequestCycle cycle) throws RequestCycleException {
        Inspector inspector = (Inspector)cycle.getPage("framework:Inspector");
        inspector.inspect(this.getPage().getName(), cycle);
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
        if (this._disabled || cycle.isRewinding()) {
            return;
        }
        IEngine engine = this.getPage().getEngine();
        IScriptSource source = engine.getScriptSource();
        IScript script = source.getScript("/net/sf/tapestry/inspector/InspectorButton.script");
        HashMap<String, String> symbols = new HashMap<String, String>();
        IEngineService service = engine.getService("direct");
        Gesture g = service.buildGesture(cycle, this, null);
        symbols.put("URL", g.getURL());
        HttpSession session = cycle.getRequestContext().getSession();
        ScriptSession scriptSession = null;
        try {
            scriptSession = script.execute(symbols);
        }
        catch (ScriptException ex) {
            throw new RequestCycleException(this, (Throwable)ex);
        }
        Body body = Body.get(cycle);
        if (body == null) {
            throw new RequestCycleException(Tapestry.getString("InspectorButton.must-be-contained-by-body"), this);
        }
        body.process(scriptSession);
        super.renderComponent(writer, cycle);
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public void setDisabled(boolean disabled) {
        this._disabled = disabled;
    }
}

