/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.inspector;

import java.util.Iterator;
import java.util.Map;
import net.sf.tapestry.BaseComponent;
import net.sf.tapestry.Gesture;
import net.sf.tapestry.IComponent;
import net.sf.tapestry.IDirect;
import net.sf.tapestry.IEngineService;
import net.sf.tapestry.IMarkupWriter;
import net.sf.tapestry.IRender;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.ITemplateSource;
import net.sf.tapestry.RequestCycleException;
import net.sf.tapestry.inspector.Inspector;
import net.sf.tapestry.inspector.View;
import net.sf.tapestry.parse.ComponentTemplate;
import net.sf.tapestry.parse.TemplateToken;
import net.sf.tapestry.parse.TokenType;

public class ShowTemplate
extends BaseComponent
implements IDirect {
    public boolean getHasTemplate() {
        Inspector inspector = (Inspector)this.getPage();
        return inspector.getInspectedComponent() instanceof BaseComponent;
    }

    public IRender getTemplateDelegate() {
        return new IRender(){

            public void render(IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
                ShowTemplate.this.writeTemplate(writer, cycle);
            }
        };
    }

    private void writeTemplate(IMarkupWriter writer, IRequestCycle cycle) {
        ComponentTemplate template = null;
        Object[] context = null;
        IEngineService service = null;
        IComponent inspectedComponent = ((Inspector)this.getPage()).getInspectedComponent();
        ITemplateSource source = this.getPage().getEngine().getTemplateSource();
        try {
            template = source.getTemplate(cycle, inspectedComponent);
        }
        catch (Exception ex) {
            return;
        }
        writer.begin("pre");
        int count = template.getTokenCount();
        char[] data = template.getTemplateData();
        int i = 0;
        while (i < count) {
            TemplateToken token = template.getToken(i);
            if (token.getType() == TokenType.TEXT) {
                int start = token.getStartIndex();
                int end = token.getEndIndex();
                writer.print(data, start, end - start + 1);
            } else if (token.getType() == TokenType.CLOSE) {
                writer.begin("span");
                writer.attribute("class", "jwc-tag");
                writer.print("</");
                writer.print(token.getTag());
                writer.print(">");
                writer.end();
            } else if (token.getType() == TokenType.LOCALIZATION) {
                writer.begin("span");
                writer.attribute("class", "jwc-tag");
                writer.print("<span key=\"");
                writer.print(token.getId());
                writer.print('\"');
                Map attributes = token.getAttributes();
                if (attributes != null && !attributes.isEmpty()) {
                    Iterator it = attributes.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        String attributeName = (String)entry.getKey();
                        String attributeValue = (String)entry.getValue();
                        writer.print(' ');
                        writer.print(attributeName);
                        writer.print("=\"");
                        writer.print(attributeValue);
                        writer.print('\"');
                    }
                }
                writer.print('>');
                writer.begin("span");
                writer.attribute("class", "localized-string");
                writer.print(inspectedComponent.getString(token.getId()));
                writer.end();
                writer.print("</span>");
                writer.end();
            } else {
                if (service == null) {
                    service = cycle.getEngine().getService("direct");
                    context = new String[1];
                }
                String id = token.getId();
                IComponent embedded = inspectedComponent.getComponent(id);
                context[0] = embedded.getIdPath();
                Gesture g = service.buildGesture(cycle, this, context);
                writer.begin("span");
                writer.attribute("class", "jwc-tag");
                writer.print("<");
                writer.print(token.getTag());
                if (token.getTag().equalsIgnoreCase("jwc")) {
                    writer.print(" id=\"");
                } else {
                    writer.print(" jwcid=\"");
                }
                writer.begin("span");
                writer.attribute("class", "jwc-id");
                writer.begin("a");
                writer.attribute("href", g.getURL());
                writer.print(id);
                writer.end();
                writer.end();
                writer.print('\"');
                Map attributes = token.getAttributes();
                if (attributes != null) {
                    Iterator ii = attributes.entrySet().iterator();
                    while (ii.hasNext()) {
                        Map.Entry e = ii.next();
                        writer.print(' ');
                        writer.print(e.getKey().toString());
                        writer.print("=\"");
                        writer.print(e.getValue().toString());
                        writer.print('\"');
                    }
                }
                if (i + 1 < count && template.getToken(i + 1).getType() == TokenType.CLOSE) {
                    writer.print('/');
                    ++i;
                }
                writer.print('>');
                writer.end();
            }
            ++i;
        }
        writer.end();
    }

    public void trigger(IRequestCycle cycle) {
        Inspector inspector = (Inspector)this.getPage();
        Object[] parameters = cycle.getServiceParameters();
        inspector.selectComponent((String)parameters[0]);
        IComponent newComponent = inspector.getInspectedComponent();
        if (!(newComponent instanceof BaseComponent)) {
            inspector.setView(View.SPECIFICATION);
        }
    }
}

