/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.multipart;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LineInput
extends FilterInputStream {
    public static final int EOF = -1;
    public static final int CR = 13;
    public static final int LF = 10;

    protected LineInput(InputStream in) {
        super(in);
    }

    public String readLine() throws IOException {
        int b;
        ByteBuffer buffer = new ByteBuffer();
        while ((b = this.read()) != -1) {
            if (b == 13) {
                this.read();
                break;
            }
            if (b == 10) break;
            buffer.add((byte)b);
        }
        return buffer.getString();
    }

    private static class ByteBuffer {
        private int length = 0;
        private byte[] buffer = new byte[100];

        private ByteBuffer() {
        }

        public int getLength() {
            return this.length;
        }

        public byte[] getBuffer() {
            return this.buffer;
        }

        public void add(byte b) {
            if (this.length == this.buffer.length) {
                byte[] newBuffer = new byte[this.length * 2];
                System.arraycopy(this.buffer, 0, newBuffer, 0, this.length);
                this.buffer = newBuffer;
            }
            this.buffer[this.length++] = b;
        }

        public String getString() {
            return new String(this.buffer, 0, this.length);
        }
    }
}

