/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.multipart;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sf.tapestry.ApplicationRuntimeException;
import net.sf.tapestry.IUploadFile;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.multipart.IPart;
import net.sf.tapestry.multipart.LineInput;
import net.sf.tapestry.multipart.UploadOutputStream;
import net.sf.tapestry.multipart.UploadPart;
import net.sf.tapestry.multipart.ValuePart;
import net.sf.tapestry.util.StringSplitter;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class MultipartDecoder {
    private static final Logger LOG = LogManager.getLogger((Class)(class$net$sf$tapestry$multipart$MultipartDecoder == null ? (class$net$sf$tapestry$multipart$MultipartDecoder = MultipartDecoder.class$("net.sf.tapestry.multipart.MultipartDecoder")) : class$net$sf$tapestry$multipart$MultipartDecoder));
    public static final String MULTIPART_FORM_DATA_CONTENT_TYPE = "multipart/form-data";
    private static final String QUOTE = "\"";
    private Map partMap = new HashMap();
    private static final String BOUNDARY = "boundary=";
    private static StringSplitter splitter = new StringSplitter(';');
    private static final int CR = 13;
    private static final int LF = 10;
    private static final int SPECIAL = -2;
    static /* synthetic */ Class class$net$sf$tapestry$multipart$MultipartDecoder;

    public static boolean isMultipartRequest(HttpServletRequest request) {
        String contentType = request.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.startsWith(MULTIPART_FORM_DATA_CONTENT_TYPE);
    }

    public MultipartDecoder(HttpServletRequest request) {
        if (!MultipartDecoder.isMultipartRequest(request)) {
            throw new ApplicationRuntimeException(Tapestry.getString("MultipartDecoder.wrong-content-type", request.getContentType()));
        }
        this.decode(request);
    }

    private void close(InputStream stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void decode(HttpServletRequest request) {
        boolean debug = LOG.isDebugEnabled();
        String contentType = request.getContentType();
        int pos = contentType.indexOf(BOUNDARY);
        String boundaryString = "--" + contentType.substring(pos + BOUNDARY.length());
        byte[] boundary = (boundaryString + "--").getBytes();
        LineInput input = null;
        try {
            try {
                input = new LineInput((InputStream)request.getInputStream());
                this.checkForInitialBoundary(input, boundaryString);
                boolean last = false;
                while (!last) {
                    last = this.readNextPart(input, boundary);
                }
            }
            catch (IOException ex) {
                LOG.error((Object)Tapestry.getString("MultipartDecoder.io-exception-reading-input", ex.getMessage()), (Throwable)ex);
                this.cleanup();
                throw new ApplicationRuntimeException(ex);
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            throw throwable;
        }
    }

    private void checkForInitialBoundary(LineInput input, String boundary) throws IOException {
        String line = input.readLine();
        if (line.equals(boundary)) {
            return;
        }
        throw new ApplicationRuntimeException(Tapestry.getString("MultipartDecoder.missing-initial-boundary"));
    }

    private boolean readNextPart(LineInput input, byte[] boundary) throws IOException {
        String line;
        String disposition = null;
        String contentType = null;
        while ((line = input.readLine()).length() != 0) {
            int colonx = line.indexOf(58);
            if (colonx <= 0) continue;
            String key = line.substring(0, colonx).toLowerCase();
            if (key.equals("content-disposition")) {
                disposition = line.substring(colonx + 1).trim();
                continue;
            }
            if (!key.equals("content-type")) continue;
            contentType = line.substring(colonx + 1).trim();
        }
        if (disposition == null) {
            throw new ApplicationRuntimeException(Tapestry.getString("MultipartDecoder.missing-content-disposition"));
        }
        Map dispositionMap = this.explodeDisposition(disposition);
        String name = (String)dispositionMap.get("name");
        if (Tapestry.isNull(name)) {
            throw new ApplicationRuntimeException(Tapestry.getString("MultipartDecoder.invalid-content-disposition", disposition));
        }
        if (!dispositionMap.containsKey("filename")) {
            return this.readValuePart(input, boundary, name);
        }
        String fileName = (String)dispositionMap.get("filename");
        return this.readFilePart(input, boundary, name, fileName, contentType);
    }

    private Map explodeDisposition(String disposition) {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] elements = splitter.splitToArray(disposition);
        int i = 0;
        while (i < elements.length) {
            String element = elements[i];
            int x = element.indexOf(61);
            if (x >= 0) {
                String key = element.substring(0, x).trim();
                String rawValue = element.substring(x + 1);
                if (!rawValue.startsWith(QUOTE) || !rawValue.endsWith(QUOTE)) {
                    throw new ApplicationRuntimeException(Tapestry.getString("MultipartDecoder.invalid-content-disposition", disposition));
                }
                result.put(key, rawValue.substring(1, rawValue.length() - 1));
            }
            ++i;
        }
        return result;
    }

    private boolean readFilePart(LineInput input, byte[] boundary, String name, String fileName, String contentType) throws IOException {
        UploadOutputStream uploadStream = new UploadOutputStream();
        boolean last = this.readIntoStream(input, boundary, uploadStream);
        File file = uploadStream.getContentFile();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Read file part '" + name + "'."));
        }
        UploadPart p = file != null ? new UploadPart(fileName, contentType, file) : new UploadPart(fileName, contentType, uploadStream.getContent());
        this.partMap.put(name, p);
        return last;
    }

    private boolean readValuePart(LineInput input, byte[] boundary, String name) throws IOException {
        ValuePart p;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean last = this.readIntoStream(input, boundary, baos);
        baos.close();
        String value = baos.toString();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Read value part '" + name + "' with value: " + value));
        }
        if ((p = (ValuePart)this.partMap.get(name)) == null) {
            p = new ValuePart(value);
            this.partMap.put(name, p);
        } else {
            p.add(value);
        }
        return last;
    }

    private boolean readIntoStream(LineInput input, byte[] boundary, OutputStream stream) throws IOException {
        boolean result = false;
        int c = 0;
        boolean cr = false;
        boolean lf = false;
        int _char = -2;
        boolean more = true;
        while (true) {
            int b = 0;
            while (more) {
                int n = c = _char != -2 ? _char : input.read();
                if (c == -1) {
                    more = false;
                    continue;
                }
                _char = -2;
                if (c == 13 || c == 10) {
                    if (c != 13) break;
                    _char = input.read();
                    break;
                }
                if (b >= 0 && b < boundary.length && c == boundary[b]) {
                    ++b;
                    continue;
                }
                if (cr) {
                    stream.write(13);
                }
                if (lf) {
                    stream.write(10);
                }
                lf = false;
                cr = false;
                if (b > 0) {
                    stream.write(boundary, 0, b);
                }
                b = -1;
                stream.write(c);
            }
            if (b > 0 && b < boundary.length - 2 || b == boundary.length - 1) {
                stream.write(boundary, 0, b);
                b = -1;
            }
            if (b > 0 || c == -1) {
                if (b == boundary.length) {
                    result = true;
                }
                if (_char != 10) break;
                _char = -2;
                break;
            }
            if (cr) {
                stream.write(13);
            }
            if (lf) {
                stream.write(10);
            }
            cr = c == 13;
            boolean bl = lf = c == 10 || _char == 10;
            if (_char != 10) continue;
            _char = -2;
        }
        return result;
    }

    public void cleanup() {
        Iterator i = this.partMap.values().iterator();
        while (i.hasNext()) {
            IPart part = (IPart)i.next();
            part.cleanup();
        }
    }

    public String getString(String name) {
        ValuePart p = (ValuePart)this.partMap.get(name);
        if (p == null) {
            return null;
        }
        return p.getValue();
    }

    public String[] getStrings(String name) {
        ValuePart p = (ValuePart)this.partMap.get(name);
        if (p == null) {
            return null;
        }
        return p.getValues();
    }

    public IUploadFile getUploadFile(String name) {
        return (UploadPart)this.partMap.get(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

