/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.pageload;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.tapestry.IAsset;
import net.sf.tapestry.IBinding;
import net.sf.tapestry.IEngine;
import net.sf.tapestry.IMarkupWriter;
import net.sf.tapestry.IMonitor;
import net.sf.tapestry.INamespace;
import net.sf.tapestry.IPage;
import net.sf.tapestry.IPageSource;
import net.sf.tapestry.IRenderDescription;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.IResourceResolver;
import net.sf.tapestry.ISpecificationSource;
import net.sf.tapestry.PageLoaderException;
import net.sf.tapestry.asset.ContextAsset;
import net.sf.tapestry.asset.ExternalAsset;
import net.sf.tapestry.asset.PrivateAsset;
import net.sf.tapestry.binding.FieldBinding;
import net.sf.tapestry.binding.StaticBinding;
import net.sf.tapestry.pageload.PageLoader;
import net.sf.tapestry.spec.ComponentSpecification;
import net.sf.tapestry.util.MultiKey;
import net.sf.tapestry.util.pool.Pool;

public class PageSource
implements IPageSource,
IRenderDescription {
    private Map _fieldBindings;
    private Map staticBindings;
    private Map _externalAssets;
    private Map _contextAssets;
    private Map _privateAssets;
    private IResourceResolver _resolver;
    private Pool _pool;

    public PageSource(IResourceResolver resolver) {
        this._resolver = resolver;
        this._pool = new Pool();
    }

    public IResourceResolver getResourceResolver() {
        return this._resolver;
    }

    protected MultiKey buildKey(IEngine engine, String pageName) {
        Object[] keys = new Object[]{pageName, engine.getLocale()};
        return new MultiKey(keys, false);
    }

    protected MultiKey buildKey(IPage page) {
        Object[] keys = new Object[]{page.getName(), page.getLocale()};
        return new MultiKey(keys, false);
    }

    public IPage getPage(IRequestCycle cycle, String pageName, IMonitor monitor) throws PageLoaderException {
        IEngine engine = cycle.getEngine();
        MultiKey key = this.buildKey(engine, pageName);
        IPage result = (IPage)this._pool.retrieve(key);
        if (result == null) {
            if (monitor != null) {
                monitor.pageCreateBegin(pageName);
            }
            PageSpecificationResolver specificationResolver = new PageSpecificationResolver(engine.getSpecificationSource(), pageName);
            PageLoader loader = new PageLoader(this);
            result = loader.loadPage(pageName, specificationResolver.getNamespace(), cycle, specificationResolver.getSpecification());
            if (monitor != null) {
                monitor.pageCreateEnd(pageName);
            }
        } else {
            result.attach(engine);
        }
        return result;
    }

    public void releasePage(IPage page) {
        page.detach();
        this._pool.store(this.buildKey(page), page);
    }

    public synchronized void reset() {
        this._pool.clear();
        this._fieldBindings = null;
        this.staticBindings = null;
        this._externalAssets = null;
        this._contextAssets = null;
        this._privateAssets = null;
    }

    public synchronized IBinding getFieldBinding(String fieldName) {
        IBinding result;
        if (this._fieldBindings == null) {
            this._fieldBindings = new HashMap();
        }
        if ((result = (IBinding)this._fieldBindings.get(fieldName)) == null) {
            result = new FieldBinding(this._resolver, fieldName);
            this._fieldBindings.put(fieldName, result);
        }
        return result;
    }

    public synchronized IBinding getStaticBinding(String value) {
        IBinding result;
        if (this.staticBindings == null) {
            this.staticBindings = new HashMap();
        }
        if ((result = (IBinding)this.staticBindings.get(value)) == null) {
            result = new StaticBinding(value);
            this.staticBindings.put(value, result);
        }
        return result;
    }

    public synchronized IAsset getExternalAsset(String URL2) {
        IAsset result;
        if (this._externalAssets == null) {
            this._externalAssets = new HashMap();
        }
        if ((result = (IAsset)this._externalAssets.get(URL2)) == null) {
            result = new ExternalAsset(URL2);
            this._externalAssets.put(URL2, result);
        }
        return result;
    }

    public synchronized IAsset getContextAsset(String assetPath) {
        IAsset result;
        if (this._contextAssets == null) {
            this._contextAssets = new HashMap();
        }
        if ((result = (IAsset)this._contextAssets.get(assetPath)) == null) {
            result = new ContextAsset(assetPath);
            this._contextAssets.put(assetPath, result);
        }
        return result;
    }

    public synchronized IAsset getPrivateAsset(String resourcePath) {
        IAsset result;
        if (this._privateAssets == null) {
            this._privateAssets = new HashMap();
        }
        if ((result = (IAsset)this._privateAssets.get(resourcePath)) == null) {
            result = new PrivateAsset(resourcePath);
            this._privateAssets.put(resourcePath, result);
        }
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("PageSource@");
        buffer.append(Integer.toHexString(this.hashCode()));
        buffer.append('[');
        if (this._pool != null) {
            buffer.append("pool=");
            buffer.append(this._pool);
        }
        this.extend(buffer, this._fieldBindings, "field bindings");
        this.extend(buffer, this.staticBindings, "static bindings");
        this.extend(buffer, this._externalAssets, "external assets");
        this.extend(buffer, this._contextAssets, "context assets");
        this.extend(buffer, this._privateAssets, "private assets");
        int lastChar = buffer.length() - 1;
        buffer.append(']');
        return buffer.toString();
    }

    private void extend(StringBuffer buffer, Map map, String label) {
        int count;
        if (map == null) {
            return;
        }
        Map map2 = map;
        synchronized (map2) {
            count = map.size();
        }
        if (count == 0) {
            return;
        }
        char ch = buffer.charAt(buffer.length() - 1);
        if (ch != ' ' && ch != '[') {
            buffer.append(", ");
        }
        buffer.append(count);
        buffer.append(" cached ");
        buffer.append(label);
    }

    public void renderDescription(IMarkupWriter writer) {
        writer.print("PageSource");
        writer.begin("ul");
        if (this._pool != null) {
            writer.begin("li");
            writer.print("pool = ");
            this._pool.renderDescription(writer);
            writer.end();
        }
        this.describe(writer, this._fieldBindings, "field bindings");
        this.describe(writer, this.staticBindings, "static bindings");
        this.describe(writer, this._externalAssets, "external assets");
        this.describe(writer, this._contextAssets, "context assets");
        this.describe(writer, this._privateAssets, "private assets");
        writer.end();
    }

    private void describe(IMarkupWriter writer, Map map, String label) {
        if (map == null) {
            return;
        }
        Map map2 = map;
        synchronized (map2) {
            Set entrySet = map.entrySet();
            int count = entrySet.size();
            if (count > 0) {
                writer.begin("li");
                writer.print(" ");
                writer.print(count);
                writer.print(" cached ");
                writer.print(label);
                writer.begin("ul");
                Iterator i = map.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry e = i.next();
                    writer.begin("li");
                    writer.print(e.getKey().toString());
                    writer.println();
                    writer.end();
                }
                writer.end();
                writer.end();
            }
        }
    }

    private static class PageSpecificationResolver {
        private String _simplePageName;
        private INamespace _namespace;

        private PageSpecificationResolver(ISpecificationSource source, String pageName) {
            int colonx = pageName.indexOf(58);
            if (colonx > 0) {
                this._simplePageName = pageName.substring(colonx + 1);
                String namespaceId = pageName.substring(0, colonx);
                this._namespace = namespaceId.equals("framework") ? source.getFrameworkNamespace() : source.getApplicationNamespace().getChildNamespace(namespaceId);
            } else {
                this._simplePageName = pageName;
                this._namespace = source.getApplicationNamespace();
                if (!this._namespace.containsPage(this._simplePageName)) {
                    this._namespace = source.getFrameworkNamespace();
                }
            }
        }

        public INamespace getNamespace() {
            return this._namespace;
        }

        public ComponentSpecification getSpecification() {
            return this._namespace.getPageSpecification(this._simplePageName);
        }
    }
}

