/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.param;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.tapestry.BindingException;
import net.sf.tapestry.IBinding;
import net.sf.tapestry.IComponent;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.IResourceResolver;
import net.sf.tapestry.RequiredParameterException;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.param.BooleanParameterConnector;
import net.sf.tapestry.param.ConnectedParameterException;
import net.sf.tapestry.param.DoubleParameterConnector;
import net.sf.tapestry.param.IParameterConnector;
import net.sf.tapestry.param.IntParameterConnector;
import net.sf.tapestry.param.ObjectParameterConnector;
import net.sf.tapestry.param.StringParameterConnector;
import net.sf.tapestry.spec.ComponentSpecification;
import net.sf.tapestry.spec.Direction;
import net.sf.tapestry.spec.ParameterSpecification;
import net.sf.tapestry.util.prop.PropertyFinder;
import net.sf.tapestry.util.prop.PropertyInfo;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class ParameterManager {
    private static final Logger LOG = LogManager.getLogger((Class)(class$net$sf$tapestry$param$ParameterManager == null ? (class$net$sf$tapestry$param$ParameterManager = ParameterManager.class$("net.sf.tapestry.param.ParameterManager")) : class$net$sf$tapestry$param$ParameterManager));
    private static final Map scalarTypeMap = new HashMap();
    private IComponent _component;
    private IParameterConnector[] _connectors;
    static /* synthetic */ Class class$net$sf$tapestry$param$ParameterManager;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;

    public ParameterManager(IComponent component) {
        this._component = component;
    }

    public void setParameters(IRequestCycle cycle) throws RequiredParameterException {
        if (this._connectors == null) {
            this.setup(cycle);
        }
        int i = 0;
        while (i < this._connectors.length) {
            this._connectors[i].setParameter(cycle);
            ++i;
        }
    }

    public void resetParameters(IRequestCycle cycle) {
        if (this._connectors == null) {
            return;
        }
        int i = 0;
        while (i < this._connectors.length) {
            this._connectors[i].resetParameter(cycle);
            ++i;
        }
    }

    private void setup(IRequestCycle cycle) throws RequiredParameterException {
        boolean debug = LOG.isDebugEnabled();
        if (debug) {
            LOG.debug((Object)(this._component + ": connecting parameters and properties"));
        }
        ArrayList<IParameterConnector> list = new ArrayList<IParameterConnector>();
        ComponentSpecification spec = this._component.getSpecification();
        IResourceResolver resolver = this._component.getPage().getEngine().getResourceResolver();
        IParameterConnector disabledConnector = null;
        List names = spec.getParameterNames();
        Iterator i = names.iterator();
        while (i.hasNext()) {
            PropertyInfo propertyInfo;
            IBinding binding;
            String name = (String)i.next();
            if (debug) {
                LOG.debug((Object)("Connecting parameter " + name + "."));
            }
            if ((binding = this._component.getBinding(name)) == null) {
                if (!debug) continue;
                LOG.debug((Object)"Not bound.");
                continue;
            }
            ParameterSpecification pspec = spec.getParameter(name);
            if (pspec.getDirection() == Direction.CUSTOM) {
                if (!debug) continue;
                LOG.debug((Object)("Parameter is " + pspec.getDirection().getName() + "."));
                continue;
            }
            String propertyName = pspec.getPropertyName();
            if (debug && !name.equals(propertyName)) {
                LOG.debug((Object)("Connecting to property " + propertyName + "."));
            }
            if ((propertyInfo = PropertyFinder.getPropertyInfo(this._component.getClass(), propertyName)) == null) {
                throw new ConnectedParameterException(Tapestry.getString("ParameterManager.no-accessor", this._component.getExtendedId(), propertyName), this._component, name, propertyName);
            }
            if (!propertyInfo.isReadWrite()) {
                throw new ConnectedParameterException(Tapestry.getString("ParameterManager.property-not-read-write", this._component.getExtendedId(), propertyName), this._component, name, propertyName);
            }
            Class propertyType = propertyInfo.getType();
            Class parameterType = this.getType(pspec.getType(), resolver);
            if (parameterType == null) {
                throw new ConnectedParameterException(Tapestry.getString("ParameterManager.java-type-not-specified", name, this._component.getExtendedId()), this._component, name, propertyName);
            }
            if (!propertyType.equals(parameterType)) {
                throw new ConnectedParameterException(Tapestry.getString("ParameterManager.type-mismatch", new String[]{name, this._component.getExtendedId(), parameterType.toString(), propertyType.toString()}), this._component, name, propertyName);
            }
            IParameterConnector connector = this.createConnector(this._component, name, binding, propertyType, parameterType);
            if (binding.isInvariant()) {
                if (debug) {
                    LOG.debug((Object)("Setting invariant value using " + connector + "."));
                }
                try {
                    connector.setParameter(cycle);
                    continue;
                }
                catch (BindingException ex) {
                    throw new ConnectedParameterException(Tapestry.getString("ParameterManager.static-initialization-failure", propertyName, this._component.getExtendedId(), binding.toString()), this._component, name, propertyName, ex);
                }
            }
            if (debug) {
                LOG.debug((Object)("Adding " + connector + "."));
            }
            if (name.equals("disabled")) {
                disabledConnector = connector;
                continue;
            }
            list.add(connector);
        }
        if (disabledConnector != null) {
            list.add(disabledConnector);
        }
        this._connectors = list.toArray(new IParameterConnector[list.size()]);
    }

    private IParameterConnector createConnector(IComponent component, String parameterName, IBinding binding, Class propertyType, Class requiredType) {
        if (propertyType.equals(Boolean.TYPE)) {
            return new BooleanParameterConnector(component, parameterName, binding);
        }
        if (propertyType.equals(Integer.TYPE)) {
            return new IntParameterConnector(component, parameterName, binding);
        }
        if (propertyType.equals(Double.TYPE)) {
            return new DoubleParameterConnector(component, parameterName, binding);
        }
        if (propertyType.equals(class$java$lang$String == null ? (class$java$lang$String = ParameterManager.class$("java.lang.String")) : class$java$lang$String)) {
            return new StringParameterConnector(component, parameterName, binding);
        }
        return new ObjectParameterConnector(component, parameterName, binding, requiredType);
    }

    private Class getType(String name, IResourceResolver resolver) {
        if (Tapestry.isNull(name)) {
            return null;
        }
        Class result = (Class)scalarTypeMap.get(name);
        if (result != null) {
            return result;
        }
        return resolver.findClass(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        scalarTypeMap.put("boolean", Boolean.TYPE);
        scalarTypeMap.put("short", Short.TYPE);
        scalarTypeMap.put("int", Integer.TYPE);
        scalarTypeMap.put("long", Long.TYPE);
        scalarTypeMap.put("float", class$java$lang$Float == null ? (class$java$lang$Float = ParameterManager.class$("java.lang.Float")) : class$java$lang$Float);
        scalarTypeMap.put("double", class$java$lang$Double == null ? (class$java$lang$Double = ParameterManager.class$("java.lang.Double")) : class$java$lang$Double);
    }
}

