/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.parse;

import net.sf.tapestry.IMarkupWriter;
import net.sf.tapestry.IRender;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.RequestCycleException;
import net.sf.tapestry.Tapestry;

public class RenderTemplateHTML
implements IRender {
    private char[] templateData;
    private int offset;
    private int length;
    private boolean needsTrim = true;

    public RenderTemplateHTML(char[] templateData, int offset, int length) {
        this.templateData = templateData;
        this.offset = offset;
        this.length = length;
        if (offset < 0 || length < 0 || offset >= templateData.length || offset + length > templateData.length) {
            throw new IllegalArgumentException(Tapestry.getString("RenderTemplateHTML.bad-range", this));
        }
    }

    public void render(IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
        if (this.needsTrim) {
            RenderTemplateHTML renderTemplateHTML = this;
            synchronized (renderTemplateHTML) {
                if (this.needsTrim) {
                    this.trim();
                }
                this.needsTrim = false;
            }
        }
        if (this.length == 0) {
            return;
        }
        writer.printRaw(this.templateData, this.offset, this.length);
    }

    private void trim() {
        boolean didTrim = false;
        if (this.length == 0) {
            return;
        }
        try {
            char ch;
            while (this.length > 0) {
                ch = this.templateData[this.offset + this.length - 1];
                if (!Character.isWhitespace(ch)) break;
                --this.length;
                didTrim = true;
            }
            if (didTrim) {
                ++this.length;
            }
            didTrim = false;
            while (this.length > 0) {
                ch = this.templateData[this.offset];
                if (!Character.isWhitespace(ch)) break;
                ++this.offset;
                --this.length;
                didTrim = true;
            }
            if (didTrim) {
                --this.offset;
                ++this.length;
            }
        }
        catch (IndexOutOfBoundsException ex) {
            throw new RuntimeException(Tapestry.getString("RenderTemplateHTML.error-trimming", this));
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("RenderTemplateHTML[");
        buffer.append("offset: ");
        buffer.append(this.offset);
        buffer.append(" length: ");
        buffer.append(this.length);
        buffer.append('/');
        buffer.append(this.templateData.length);
        buffer.append(" <");
        try {
            int i = 0;
            while (i < this.length) {
                char ch = this.templateData[this.offset + i];
                if (ch < ' ' || ch > '~') {
                    buffer.append('.');
                } else {
                    buffer.append(ch);
                }
                ++i;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        buffer.append(">]");
        return buffer.toString();
    }
}

