/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.parse;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.tapestry.IResourceResolver;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.bean.IBeanInitializer;
import net.sf.tapestry.spec.AssetSpecification;
import net.sf.tapestry.spec.AssetType;
import net.sf.tapestry.spec.BeanLifecycle;
import net.sf.tapestry.spec.BeanSpecification;
import net.sf.tapestry.spec.BindingSpecification;
import net.sf.tapestry.spec.BindingType;
import net.sf.tapestry.spec.ComponentSpecification;
import net.sf.tapestry.spec.ContainedComponent;
import net.sf.tapestry.spec.Direction;
import net.sf.tapestry.spec.ExtensionSpecification;
import net.sf.tapestry.spec.IApplicationSpecification;
import net.sf.tapestry.spec.ILibrarySpecification;
import net.sf.tapestry.spec.ParameterSpecification;
import net.sf.tapestry.spec.SpecFactory;
import net.sf.tapestry.util.IPropertyHolder;
import net.sf.tapestry.util.xml.AbstractDocumentParser;
import net.sf.tapestry.util.xml.DocumentParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class SpecificationParser
extends AbstractDocumentParser {
    public static final String TAPESTRY_DTD_1_1_PUBLIC_ID = "-//Howard Ship//Tapestry Specification 1.1//EN";
    public static final String TAPESTRY_DTD_1_2_PUBLIC_ID = "-//Howard Lewis Ship//Tapestry Specification 1.2//EN";
    public static final String TAPESTRY_DTD_1_3_PUBLIC_ID = "-//Howard Lewis Ship//Tapestry Specification 1.3//EN";
    public static final String EXTENDED_PROPERTY_NAME_PATTERN = "^_?[a-zA-Z](\\w|-|\\.)*$";
    public static final String PARAMETER_NAME_PATTERN = "^_?[a-zA-Z]\\w*$";
    public static final String PROPERTY_NAME_PATTERN = "^_?[a-zA-Z]\\w*$";
    public static final String PAGE_NAME_PATTERN = "^_?[a-zA-Z](\\w|-|\\.)*$";
    public static final String COMPONENT_ALIAS_PATTERN = "^_?[a-zA-Z]\\w*$";
    public static final String BEAN_NAME_PATTERN = "^_?[a-zA-Z]\\w*$";
    public static final String COMPONENT_ID_PATTERN = "^_?[a-zA-Z]\\w*$";
    public static final String ASSET_NAME_PATTERN = "^_?[a-zA-Z]\\w*$";
    public static final String SERVICE_NAME_PATTERN = "^_?[a-zA-Z](\\w|-|\\.)*$";
    public static final String LIBRARY_ID_PATTERN = "^_?[a-zA-Z]\\w*$";
    public static final String EXTENSION_NAME_PATTERN = "^_?[a-zA-Z](\\w|-|\\.)*$";
    public static final String COMPONENT_TYPE_PATTERN = "^(_?[a-zA-Z]\\w*:)?[a-zA-Z_](\\w)*$";
    private boolean _version3 = false;
    private static final Map _conversionMap = new HashMap();
    private SpecFactory _factory;

    public SpecificationParser() {
        this.register(TAPESTRY_DTD_1_1_PUBLIC_ID, "Tapestry_1_1.dtd");
        this.register(TAPESTRY_DTD_1_2_PUBLIC_ID, "Tapestry_1_2.dtd");
        this.register(TAPESTRY_DTD_1_3_PUBLIC_ID, "Tapestry_1_3.dtd");
        this._factory = new SpecFactory();
    }

    public ComponentSpecification parseComponentSpecification(InputStream input, String resourcePath) throws DocumentParseException {
        try {
            Document document = this.parse(new InputSource(input), resourcePath, null);
            this._version3 = this.checkVersion3(document);
            String rootElementName = this._version3 ? "component-specification" : "specification";
            this.validateRootElement(document, rootElementName, resourcePath);
            ComponentSpecification componentSpecification = this.convertComponentSpecification(document, false);
            Object var7_6 = null;
            this.setResourcePath(null);
            return componentSpecification;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.setResourcePath(null);
            throw throwable;
        }
    }

    public ComponentSpecification parsePageSpecification(InputStream input, String resourcePath) throws DocumentParseException {
        try {
            Document document = this.parse(new InputSource(input), resourcePath, null);
            this._version3 = this.checkVersion3(document);
            String rootElementName = this._version3 ? "page-specification" : "specification";
            this.validateRootElement(document, rootElementName, resourcePath);
            ComponentSpecification result = this.convertComponentSpecification(document, true);
            result.setAllowBody(true);
            result.setAllowInformalParameters(false);
            result.setPageSpecification(true);
            ComponentSpecification componentSpecification = result;
            Object var8_7 = null;
            this.setResourcePath(null);
            return componentSpecification;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.setResourcePath(null);
            throw throwable;
        }
    }

    public IApplicationSpecification parseApplicationSpecification(InputStream input, String resourcePath, IResourceResolver resolver) throws DocumentParseException {
        try {
            Document document = this.parse(new InputSource(input), resourcePath, "application");
            this._version3 = this.checkVersion3(document);
            IApplicationSpecification iApplicationSpecification = this.convertApplicationSpecification(document, resolver);
            Object var7_6 = null;
            this.setResourcePath(null);
            return iApplicationSpecification;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.setResourcePath(null);
            throw throwable;
        }
    }

    public ILibrarySpecification parseLibrarySpecification(InputStream input, String resourcePath, IResourceResolver resolver) throws DocumentParseException {
        try {
            Document document = this.parse(new InputSource(input), resourcePath, "library-specification");
            this._version3 = true;
            ILibrarySpecification iLibrarySpecification = this.convertLibrarySpecification(document, resolver);
            Object var7_6 = null;
            this.setResourcePath(null);
            return iLibrarySpecification;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.setResourcePath(null);
            throw throwable;
        }
    }

    private boolean getBooleanValue(Node node) throws DocumentParseException {
        String key = this.getValue(node).toLowerCase();
        Boolean value = (Boolean)_conversionMap.get(key);
        if (value == null) {
            throw new DocumentParseException(Tapestry.getString("SpecificationParser.unable-to-convert-node-to-boolean", key, this.getNodePath(node.getParentNode())), this.getResourcePath());
        }
        return value;
    }

    private boolean getBooleanAttribute(Node node, String attributeName) {
        String attributeValue = this.getAttribute(node, attributeName);
        return attributeValue.equals("yes");
    }

    private IApplicationSpecification convertApplicationSpecification(Document document, IResourceResolver resolver) throws DocumentParseException {
        IApplicationSpecification specification = this._factory.createApplicationSpecification();
        Element root = document.getDocumentElement();
        specification.setName(this.getAttribute(root, "name"));
        specification.setEngineClassName(this.getAttribute(root, "engine-class"));
        this.processLibrarySpecification(document, specification, resolver);
        return specification;
    }

    private ILibrarySpecification convertLibrarySpecification(Document document, IResourceResolver resolver) throws DocumentParseException {
        ILibrarySpecification specification = this._factory.createLibrarySpecification();
        this.processLibrarySpecification(document, specification, resolver);
        return specification;
    }

    private void processLibrarySpecification(Document document, ILibrarySpecification specification, IResourceResolver resolver) throws DocumentParseException {
        specification.setPublicId(document.getDoctype().getPublicId());
        specification.setResourceResolver(resolver);
        Element root = document.getDocumentElement();
        Node node = root.getFirstChild();
        while (node != null) {
            if (this.isElement(node, "page")) {
                this.convertPage(specification, node);
            } else if (this.isElement(node, "component-alias")) {
                this.convertComponentAlias(specification, node);
            } else if (this.isElement(node, "property")) {
                this.convertProperty(specification, node);
            } else if (this.isElement(node, "service")) {
                this.convertService(specification, node);
            } else if (this.isElement(node, "description")) {
                specification.setDescription(this.getValue(node));
            } else if (this.isElement(node, "library")) {
                this.convertLibrary(specification, node);
            } else if (this.isElement(node, "extension")) {
                this.convertExtension(specification, node);
            }
            node = node.getNextSibling();
        }
        specification.instantiateImmediateExtensions();
    }

    private void convertLibrary(ILibrarySpecification specification, Node node) throws DocumentParseException {
        String id = this.getAttribute(node, "id");
        this.validate(id, "^_?[a-zA-Z]\\w*$", "SpecificationParser.invalid-library-id");
        if (id.equals("framework")) {
            throw new DocumentParseException(Tapestry.getString("SpecificationParser.framework-library-id-is-reserved", "framework"), this.getResourcePath());
        }
        String specificationPath = this.getAttribute(node, "specification-path");
        specification.setLibrarySpecificationPath(id, specificationPath);
    }

    private void convertPage(ILibrarySpecification specification, Node node) throws DocumentParseException {
        String name = this.getAttribute(node, "name");
        this.validate(name, "^_?[a-zA-Z](\\w|-|\\.)*$", "SpecificationParser.invalid-page-name");
        String specificationPath = this.getAttribute(node, "specification-path");
        specification.setPageSpecificationPath(name, specificationPath);
    }

    private void convertComponentAlias(ILibrarySpecification specification, Node node) throws DocumentParseException {
        String type = this.getAttribute(node, "type");
        this.validate(type, "^_?[a-zA-Z]\\w*$", "SpecificationParser.invalid-component-alias");
        String path = this.getAttribute(node, "specification-path");
        specification.setComponentSpecificationPath(type, path);
    }

    private void convertProperty(IPropertyHolder holder, Node node) {
        String name = this.getAttribute(node, "name");
        String value = this.getValue(node);
        holder.setProperty(name, value);
    }

    private ComponentSpecification convertComponentSpecification(Document document, boolean isPage) throws DocumentParseException {
        ComponentSpecification specification = this._factory.createComponentSpecification();
        Element root = document.getDocumentElement();
        specification.setPublicId(document.getDoctype().getPublicId());
        if (!isPage) {
            specification.setAllowBody(this.getBooleanAttribute(root, "allow-body"));
            specification.setAllowInformalParameters(this.getBooleanAttribute(root, "allow-informal-parameters"));
        }
        specification.setComponentClassName(this.getAttribute(root, "class"));
        Node node = root.getFirstChild();
        while (node != null) {
            if (this.isElement(node, "parameter")) {
                if (isPage) {
                    throw new DocumentParseException(Tapestry.getString("SpecificationParser.not-allowed-for-page", "parameter"), this.getResourcePath());
                }
                this.convertParameter(specification, node);
            } else if (this.isElement(node, "reserved-parameter")) {
                if (isPage) {
                    throw new DocumentParseException(Tapestry.getString("SpecificationParser.not-allowed-for-page", "reserved-parameter"), this.getResourcePath());
                }
                this.convertReservedParameter(specification, node);
            } else if (this.isElement(node, "bean")) {
                this.convertBean(specification, node);
            } else if (this.isElement(node, "component")) {
                this.convertComponent(specification, node);
            } else if (this.isElement(node, "external-asset")) {
                this.convertAsset(specification, node, AssetType.EXTERNAL, "URL");
            } else if (this.isElement(node, "context-asset")) {
                this.convertAsset(specification, node, AssetType.CONTEXT, "path");
            } else if (this.isElement(node, "private-asset")) {
                this.convertAsset(specification, node, AssetType.PRIVATE, "resource-path");
            } else if (this.isElement(node, "property")) {
                this.convertProperty(specification, node);
            } else if (this.isElement(node, "description")) {
                specification.setDescription(this.getValue(node));
            }
            node = node.getNextSibling();
        }
        return specification;
    }

    private void convertParameter(ComponentSpecification specification, Node node) throws DocumentParseException {
        ParameterSpecification param = this._factory.createParameterSpecification();
        String name = this.getAttribute(node, "name");
        this.validate(name, "^_?[a-zA-Z]\\w*$", "SpecificationParser.invalid-parameter-name");
        param.setType(this.getAttribute(node, "java-type"));
        param.setRequired(this.getBooleanAttribute(node, "required"));
        String propertyName = this.getAttribute(node, "property-name");
        if (propertyName == null) {
            propertyName = name;
            this.validate(propertyName, "^_?[a-zA-Z]\\w*$", "SpecificationParser.invalid-property-name");
        }
        param.setPropertyName(propertyName);
        String direction = this.getAttribute(node, "direction");
        if (direction != null) {
            param.setDirection((Direction)_conversionMap.get(direction));
        }
        specification.addParameter(name, param);
        Node child = node.getFirstChild();
        if (child != null && this.isElement(child, "description")) {
            param.setDescription(this.getValue(child));
        }
    }

    private void convertBean(ComponentSpecification specification, Node node) throws DocumentParseException {
        String name = this.getAttribute(node, "name");
        this.validate(name, "^_?[a-zA-Z]\\w*$", "SpecificationParser.invalid-bean-name");
        String className = this.getAttribute(node, "class");
        String lifecycleString = this.getAttribute(node, "lifecycle");
        BeanLifecycle lifecycle = (BeanLifecycle)_conversionMap.get(lifecycleString);
        BeanSpecification bspec = this._factory.createBeanSpecification(className, lifecycle);
        specification.addBeanSpecification(name, bspec);
        Node child = node.getFirstChild();
        while (child != null) {
            if (this.isElement(child, "description")) {
                bspec.setDescription(this.getValue(child));
            } else if (this.isElement(child, "property")) {
                this.convertProperty(bspec, child);
            } else if (this.isElement(child, "set-property")) {
                if (this._version3) {
                    this.convertSetProperty(bspec, child);
                } else {
                    this.convertSetProperty_2(bspec, child);
                }
            } else if (this.isElement(child, "set-string-property")) {
                this.convertSetStringProperty(bspec, child);
            }
            child = child.getNextSibling();
        }
    }

    private void convertSetProperty_2(BeanSpecification spec, Node node) throws DocumentParseException {
        String name = this.getAttribute(node, "name");
        Node child = node.getFirstChild();
        while (child != null) {
            if (this.isElement(child, "static-value")) {
                this.convertStaticValue(spec, name, child);
            } else if (this.isElement(child, "field-value")) {
                this.convertFieldValue(spec, name, child);
            } else if (this.isElement(child, "property-value")) {
                this.convertPropertyValue(spec, name, child);
            }
            child = child.getNextSibling();
        }
    }

    private void convertSetProperty(BeanSpecification spec, Node node) throws DocumentParseException {
        String name = this.getAttribute(node, "name");
        String expression = this.getAttribute(node, "expression");
        IBeanInitializer iz = this._factory.createExpressionBeanInitializer(name, expression);
        spec.addInitializer(iz);
    }

    private void convertSetStringProperty(BeanSpecification spec, Node node) throws DocumentParseException {
        String name = this.getAttribute(node, "name");
        String key = this.getAttribute(node, "key");
        IBeanInitializer iz = this._factory.createStringBeanInitializer(name, key);
        spec.addInitializer(iz);
    }

    private void convertFieldValue(BeanSpecification spec, String propertyName, Node node) {
        String fieldName = this.getAttribute(node, "field-name");
        IBeanInitializer iz = this._factory.createFieldBeanInitializer(propertyName, fieldName);
        spec.addInitializer(iz);
    }

    private void convertPropertyValue(BeanSpecification spec, String propertyName, Node node) {
        String propertyPath = this.getAttribute(node, "property-path");
        IBeanInitializer iz = this._factory.createPropertyBeanInitializer(propertyName, propertyPath);
        spec.addInitializer(iz);
    }

    private void convertExpressionValue(BeanSpecification spec, String propertyName, Node node) {
        String expression = this.getAttribute(node, "expression");
        IBeanInitializer iz = this._factory.createExpressionBeanInitializer(propertyName, expression);
        spec.addInitializer(iz);
    }

    private void convertStaticValue(BeanSpecification spec, String propertyName, Node node) throws DocumentParseException {
        String type = this.getAttribute(node, "type");
        String value = this.getValue(node);
        IConverter converter = (IConverter)_conversionMap.get(type);
        if (converter == null) {
            throw new DocumentParseException(Tapestry.getString("SpecificationParser.unknown-static-value-type", type), this.getResourcePath());
        }
        Object staticValue = converter.convert(value);
        IBeanInitializer iz = this._factory.createStaticBeanInitializer(propertyName, staticValue);
        spec.addInitializer(iz);
    }

    private void convertComponent(ComponentSpecification specification, Node node) throws DocumentParseException {
        ContainedComponent c;
        String id = this.getAttribute(node, "id");
        this.validate(id, "^_?[a-zA-Z]\\w*$", "SpecificationParser.invalid-component-id");
        String type = this.getAttribute(node, "type");
        String copyOf = this.getAttribute(node, "copy-of");
        if (type != null && copyOf != null) {
            throw new DocumentParseException(Tapestry.getString("SpecificationParser.both-type-and-copy-of", id), this.getResourcePath());
        }
        if (copyOf != null) {
            c = this.copyExistingComponent(specification, copyOf);
        } else {
            if (type == null) {
                throw new DocumentParseException(Tapestry.getString("SpecificationParser.missing-type-or-copy-of", id), this.getResourcePath());
            }
            if (this._version3) {
                this.validate(type, COMPONENT_TYPE_PATTERN, "SpecificationParser.invalid-component-type");
            }
            c = this._factory.createContainedComponent();
            c.setType(type);
        }
        Node child = node.getFirstChild();
        while (child != null) {
            if (this.isElement(child, "binding")) {
                this.convertBinding(c, child, BindingType.DYNAMIC, this._version3 ? "expression" : "property-path");
            } else if (this.isElement(child, "field-binding")) {
                this.convertBinding(c, child, BindingType.FIELD, "field-name");
            } else if (this.isElement(child, "inherited-binding")) {
                this.convertBinding(c, child, BindingType.INHERITED, "parameter-name");
            } else if (this.isElement(child, "static-binding")) {
                this.convertStaticBinding(c, child);
            } else if (this.isElement(child, "string-binding")) {
                this.convertBinding(c, child, BindingType.STRING, "key");
            } else if (this.isElement(child, "property")) {
                this.convertProperty(c, child);
            }
            child = child.getNextSibling();
        }
        specification.addComponent(id, c);
    }

    private void convertBinding(ContainedComponent component, Node node, BindingType type, String attributeName) {
        String name = this.getAttribute(node, "name");
        String value = this.getAttribute(node, attributeName);
        BindingSpecification binding = this._factory.createBindingSpecification(type, value);
        component.setBinding(name, binding);
    }

    private void convertStaticBinding(ContainedComponent component, Node node) {
        String name = this.getAttribute(node, "name");
        String value = this.getValue(node);
        BindingSpecification binding = this._factory.createBindingSpecification(BindingType.STATIC, value);
        component.setBinding(name, binding);
    }

    private ContainedComponent copyExistingComponent(ComponentSpecification spec, String id) throws DocumentParseException {
        ContainedComponent c = spec.getComponent(id);
        if (c == null) {
            throw new DocumentParseException(Tapestry.getString("SpecificationParser.unable-to-copy", id), this.getResourcePath());
        }
        ContainedComponent result = this._factory.createContainedComponent();
        result.setType(c.getType());
        result.setCopyOf(id);
        Iterator i = c.getBindingNames().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            BindingSpecification binding = c.getBinding(name);
            result.setBinding(name, binding);
        }
        return result;
    }

    private void convertAsset(ComponentSpecification specification, Node node, AssetType type, String attributeName) throws DocumentParseException {
        String name = this.getAttribute(node, "name");
        if (!name.equals("$template")) {
            this.validate(name, "^_?[a-zA-Z]\\w*$", "SpecificationParser.invalid-asset-name");
        }
        String value = this.getAttribute(node, attributeName);
        AssetSpecification asset = this._factory.createAssetSpecification(type, value);
        specification.addAsset(name, asset);
        this.processPropertiesInNode(asset, node);
    }

    private void processPropertiesInNode(IPropertyHolder holder, Node node) throws DocumentParseException {
        Node child = node.getFirstChild();
        while (child != null) {
            if (this.isElement(child, "property")) {
                this.convertProperty(holder, child);
            }
            child = child.getNextSibling();
        }
    }

    private void convertReservedParameter(ComponentSpecification spec, Node node) {
        String name = this.getAttribute(node, "name");
        spec.addReservedParameterName(name);
    }

    private void convertService(ILibrarySpecification spec, Node node) throws DocumentParseException {
        String name = this.getAttribute(node, "name");
        this.validate(name, "^_?[a-zA-Z](\\w|-|\\.)*$", "SpecificationParser.invalid-service-name");
        String className = this.getAttribute(node, "class");
        spec.setServiceClassName(name, className);
    }

    public void setFactory(SpecFactory factory) {
        this._factory = factory;
    }

    public SpecFactory getFactory() {
        return this._factory;
    }

    private void convertExtension(ILibrarySpecification specification, Node node) throws DocumentParseException {
        String name = this.getAttribute(node, "name");
        String className = this.getAttribute(node, "class");
        boolean immediate = this.getBooleanAttribute(node, "immediate");
        this.validate(name, "^_?[a-zA-Z](\\w|-|\\.)*$", "SpecificationParser.invalid-extension-name");
        ExtensionSpecification exSpec = this._factory.createExtensionSpecification();
        exSpec.setClassName(className);
        exSpec.setImmediate(immediate);
        specification.addExtensionSpecification(name, exSpec);
        Node child = node.getFirstChild();
        while (child != null) {
            if (this.isElement(child, "configure")) {
                this.convertConfigure(exSpec, child);
            } else if (this.isElement(child, "property")) {
                this.convertProperty(exSpec, child);
            }
            child = child.getNextSibling();
        }
    }

    private void convertConfigure(ExtensionSpecification spec, Node node) throws DocumentParseException {
        String propertyName = this.getAttribute(node, "property-name");
        String type = this.getAttribute(node, "type");
        String value = this.getValue(node);
        this.validate(propertyName, "^_?[a-zA-Z]\\w*$", "SpecificationParser.invalid-property-name");
        IConverter converter = (IConverter)_conversionMap.get(type);
        if (converter == null) {
            throw new DocumentParseException(Tapestry.getString("SpecificationParser.unknown-static-value-type", type), this.getResourcePath());
        }
        Object objectValue = converter.convert(value);
        spec.addConfiguration(propertyName, objectValue);
    }

    private boolean checkVersion3(Document document) {
        String publicId = document.getDoctype().getPublicId();
        return publicId.equals(TAPESTRY_DTD_1_3_PUBLIC_ID);
    }

    static {
        _conversionMap.put("true", Boolean.TRUE);
        _conversionMap.put("t", Boolean.TRUE);
        _conversionMap.put("1", Boolean.TRUE);
        _conversionMap.put("y", Boolean.TRUE);
        _conversionMap.put("yes", Boolean.TRUE);
        _conversionMap.put("on", Boolean.TRUE);
        _conversionMap.put("false", Boolean.FALSE);
        _conversionMap.put("f", Boolean.FALSE);
        _conversionMap.put("0", Boolean.FALSE);
        _conversionMap.put("off", Boolean.FALSE);
        _conversionMap.put("no", Boolean.FALSE);
        _conversionMap.put("n", Boolean.FALSE);
        _conversionMap.put("none", BeanLifecycle.NONE);
        _conversionMap.put("request", BeanLifecycle.REQUEST);
        _conversionMap.put("page", BeanLifecycle.PAGE);
        _conversionMap.put("render", BeanLifecycle.RENDER);
        _conversionMap.put("boolean", new BooleanConverter());
        _conversionMap.put("int", new IntConverter());
        _conversionMap.put("double", new DoubleConverter());
        _conversionMap.put("String", new StringConverter());
        _conversionMap.put("long", new LongConverter());
        _conversionMap.put("in", Direction.IN);
        _conversionMap.put("form", Direction.FORM);
        _conversionMap.put("custom", Direction.CUSTOM);
    }

    private static class StringConverter
    implements IConverter {
        private StringConverter() {
        }

        public Object convert(String value) {
            return value.trim();
        }
    }

    private static class DoubleConverter
    implements IConverter {
        private DoubleConverter() {
        }

        public Object convert(String value) throws DocumentParseException {
            try {
                return new Double(value);
            }
            catch (NumberFormatException ex) {
                throw new DocumentParseException(Tapestry.getString("SpecificationParser.fail-convert-double", value), ex);
            }
        }
    }

    private static class LongConverter
    implements IConverter {
        private LongConverter() {
        }

        public Object convert(String value) throws DocumentParseException {
            try {
                return new Long(value);
            }
            catch (NumberFormatException ex) {
                throw new DocumentParseException(Tapestry.getString("SpecificationParser.fail-convert-long", value), ex);
            }
        }
    }

    private static class IntConverter
    implements IConverter {
        private IntConverter() {
        }

        public Object convert(String value) throws DocumentParseException {
            try {
                return new Integer(value);
            }
            catch (NumberFormatException ex) {
                throw new DocumentParseException(Tapestry.getString("SpecificationParser.fail-convert-int", value), ex);
            }
        }
    }

    private static class BooleanConverter
    implements IConverter {
        private BooleanConverter() {
        }

        public Object convert(String value) throws DocumentParseException {
            Object result = _conversionMap.get(value.toLowerCase());
            if (result == null || !(result instanceof Boolean)) {
                throw new DocumentParseException(Tapestry.getString("SpecificationParser.fail-convert-boolean", value));
            }
            return result;
        }
    }

    private static interface IConverter {
        public Object convert(String var1) throws DocumentParseException;
    }
}

