/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.spec;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.spec.AssetSpecification;
import net.sf.tapestry.spec.BeanSpecification;
import net.sf.tapestry.spec.ContainedComponent;
import net.sf.tapestry.spec.ParameterSpecification;
import net.sf.tapestry.util.BasePropertyHolder;

public class ComponentSpecification
extends BasePropertyHolder {
    private String _componentClassName;
    protected String specificationResourcePath;
    private String _description;
    protected Map _components;
    protected Map _assets;
    protected Map _parameters;
    protected Map _beans;
    protected Set _reservedParameterNames;
    private boolean _allowBody = true;
    private boolean _allowInformalParameters = true;
    private String _publicId;
    private boolean _pageSpecification;

    public void addAsset(String name, AssetSpecification asset) {
        if (this._assets == null) {
            this._assets = new HashMap();
        }
        if (this._assets.containsKey(name)) {
            throw new IllegalArgumentException(Tapestry.getString("ComponentSpecification.duplicate-asset", this, name));
        }
        this._assets.put(name, asset);
    }

    public void addComponent(String id, ContainedComponent component) {
        if (this._components == null) {
            this._components = new HashMap();
        }
        if (this._components.containsKey(id)) {
            throw new IllegalArgumentException(Tapestry.getString("ComponentSpecification.duplicate-component", this, id));
        }
        this._components.put(id, component);
    }

    public void addParameter(String name, ParameterSpecification spec) {
        if (this._parameters == null) {
            this._parameters = new HashMap();
        }
        if (this._parameters.containsKey(name)) {
            throw new IllegalArgumentException(Tapestry.getString("ComponentSpecification.duplicate-parameter", this, name));
        }
        this._parameters.put(name, spec);
        this.addReservedParameterName(name);
    }

    public boolean getAllowBody() {
        return this._allowBody;
    }

    public boolean getAllowInformalParameters() {
        return this._allowInformalParameters;
    }

    public AssetSpecification getAsset(String name) {
        if (this._assets == null) {
            return null;
        }
        return (AssetSpecification)this._assets.get(name);
    }

    public List getAssetNames() {
        return this.sortedKeys(this._assets);
    }

    public ContainedComponent getComponent(String id) {
        if (this._components == null) {
            return null;
        }
        return (ContainedComponent)this._components.get(id);
    }

    public String getComponentClassName() {
        return this._componentClassName;
    }

    public List getComponentIds() {
        return this.sortedKeys(this._components);
    }

    public ParameterSpecification getParameter(String name) {
        if (this._parameters == null) {
            return null;
        }
        return (ParameterSpecification)this._parameters.get(name);
    }

    public List getParameterNames() {
        return this.sortedKeys(this._parameters);
    }

    public String getSpecificationResourcePath() {
        return this.specificationResourcePath;
    }

    public void setAllowBody(boolean value) {
        this._allowBody = value;
    }

    public void setAllowInformalParameters(boolean value) {
        this._allowInformalParameters = value;
    }

    public void setComponentClassName(String value) {
        this._componentClassName = value;
    }

    public void setSpecificationResourcePath(String value) {
        this.specificationResourcePath = value;
    }

    public void addBeanSpecification(String name, BeanSpecification specification) {
        if (this._beans == null) {
            this._beans = new HashMap();
        } else if (this._beans.containsKey(name)) {
            throw new IllegalArgumentException(Tapestry.getString("ComponentSpecification.duplicate-bean", this, name));
        }
        this._beans.put(name, specification);
    }

    public BeanSpecification getBeanSpecification(String name) {
        if (this._beans == null) {
            return null;
        }
        return (BeanSpecification)this._beans.get(name);
    }

    public Collection getBeanNames() {
        if (this._beans == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableCollection(this._beans.keySet());
    }

    public void addReservedParameterName(String value) {
        if (this._reservedParameterNames == null) {
            this._reservedParameterNames = new HashSet();
        }
        this._reservedParameterNames.add(value.toLowerCase());
    }

    public boolean isReservedParameterName(String value) {
        if (this._reservedParameterNames == null) {
            return false;
        }
        return this._reservedParameterNames.contains(value.toLowerCase());
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(super.toString());
        buffer.append('[');
        if (this.specificationResourcePath != null) {
            buffer.append(this.specificationResourcePath);
        } else if (this._componentClassName != null) {
            buffer.append(this._componentClassName);
        }
        buffer.append(']');
        return buffer.toString();
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public String getPublicId() {
        return this._publicId;
    }

    public void setPublicId(String publicId) {
        this._publicId = publicId;
    }

    public boolean isPageSpecification() {
        return this._pageSpecification;
    }

    public void setPageSpecification(boolean pageSpecification) {
        this._pageSpecification = pageSpecification;
    }

    private List sortedKeys(Map input) {
        if (input == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = new ArrayList(input.keySet());
        Collections.sort(result);
        return result;
    }
}

