/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.spec;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.tapestry.IResourceResolver;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.spec.ExtensionSpecification;
import net.sf.tapestry.spec.ILibrarySpecification;
import net.sf.tapestry.util.BasePropertyHolder;

public class LibrarySpecification
extends BasePropertyHolder
implements ILibrarySpecification {
    private IResourceResolver _resolver;
    private Map _pages;
    private Map _components;
    private Map _services;
    private Map _libraries;
    private String _description;
    private Map _extensions;
    private Map _instantiatedExtensions;
    private String _publicId;

    public String getLibrarySpecificationPath(String id) {
        return (String)this.get(this._libraries, id);
    }

    public void setLibrarySpecificationPath(String id, String path) {
        if (this._libraries == null) {
            this._libraries = new HashMap();
        }
        if (this._libraries.containsKey(id)) {
            throw new IllegalArgumentException(Tapestry.getString("LibrarySpecification.duplicate-child-namespace-id", id));
        }
        this._libraries.put(id, path);
    }

    public List getLibraryIds() {
        return this.sortedKeys(this._libraries);
    }

    public String getPageSpecificationPath(String name) {
        return (String)this.get(this._pages, name);
    }

    public void setPageSpecificationPath(String name, String path) {
        if (this._pages == null) {
            this._pages = new HashMap();
        }
        if (this._pages.containsKey(name)) {
            throw new IllegalArgumentException(Tapestry.getString("LibrarySpecification.duplicate-page-name", name));
        }
        this._pages.put(name, path);
    }

    public List getPageNames() {
        return this.sortedKeys(this._pages);
    }

    public void setComponentSpecificationPath(String alias, String path) {
        if (this._components == null) {
            this._components = new HashMap();
        }
        if (this._components.containsKey(alias)) {
            throw new IllegalArgumentException(Tapestry.getString("LibrarySpecification.duplicate-component-alias", alias));
        }
        this._components.put(alias, path);
    }

    public String getComponentSpecificationPath(String alias) {
        return (String)this.get(this._components, alias);
    }

    public List getComponentAliases() {
        return this.sortedKeys(this._components);
    }

    public String getServiceClassName(String name) {
        return (String)this.get(this._services, name);
    }

    public List getServiceNames() {
        return this.sortedKeys(this._services);
    }

    public void setServiceClassName(String name, String className) {
        if (this._services == null) {
            this._services = new HashMap();
        }
        if (this._services.containsKey(name)) {
            throw new IllegalArgumentException(Tapestry.getString("LibrarySpecification.duplicate-service-name", name));
        }
        this._services.put(name, className);
    }

    private List sortedKeys(Map map) {
        if (map == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = new ArrayList(map.keySet());
        Collections.sort(result);
        return result;
    }

    private Object get(Map map, Object key) {
        if (map == null) {
            return null;
        }
        return map.get(key);
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public Map getExtensionSpecifications() {
        if (this._extensions == null) {
            return null;
        }
        return Collections.unmodifiableMap(this._extensions);
    }

    public void addExtensionSpecification(String name, ExtensionSpecification extension) {
        if (this._extensions == null) {
            this._extensions = new HashMap();
        }
        if (this._extensions.containsKey(name)) {
            throw new IllegalArgumentException(Tapestry.getString("LibrarySpecification.duplicate-extension-name", this, name));
        }
        this._extensions.put(name, extension);
    }

    public List getExtensionNames() {
        return this.sortedKeys(this._instantiatedExtensions);
    }

    public ExtensionSpecification getExtensionSpecification(String name) {
        if (this._extensions == null) {
            return null;
        }
        return (ExtensionSpecification)this._extensions.get(name);
    }

    public boolean checkExtension(String name) {
        if (this._extensions == null) {
            return false;
        }
        return this._extensions.containsKey(name);
    }

    public synchronized Object getExtension(String name) {
        Object result;
        if (this._instantiatedExtensions == null) {
            this._instantiatedExtensions = new HashMap();
        }
        if ((result = this._instantiatedExtensions.get(name)) == null) {
            ExtensionSpecification spec = this.getExtensionSpecification(name);
            if (spec == null) {
                throw new IllegalArgumentException(Tapestry.getString("LibrarySpecification.no-such-extension", name));
            }
            result = spec.instantiateExtension(this._resolver);
            this._instantiatedExtensions.put(name, result);
        }
        return result;
    }

    public synchronized void instantiateImmediateExtensions() {
        if (this._extensions == null) {
            return;
        }
        Iterator i = this._extensions.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            ExtensionSpecification spec = (ExtensionSpecification)entry.getValue();
            if (!spec.isImmediate()) continue;
            String name = (String)entry.getKey();
            this.getExtension(name);
        }
    }

    public IResourceResolver getResourceResolver() {
        return this._resolver;
    }

    public void setResourceResolver(IResourceResolver resolver) {
        this._resolver = resolver;
    }

    protected Map getExtensions() {
        return this._extensions;
    }

    protected void setExtensions(Map extension) {
        this._extensions = extension;
    }

    protected Map getLibraries() {
        return this._libraries;
    }

    protected void setLibraries(Map libraries) {
        this._libraries = libraries;
    }

    protected Map getPages() {
        return this._pages;
    }

    protected void setPages(Map pages) {
        this._pages = pages;
    }

    protected Map getServices() {
        return this._services;
    }

    protected void setServices(Map services) {
        this._services = services;
    }

    protected Map getComponents() {
        return this._components;
    }

    protected void setComponents(Map components) {
        this._components = components;
    }

    public String getPublicId() {
        return this._publicId;
    }

    public void setPublicId(String publicId) {
        this._publicId = publicId;
    }
}

