/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.util.ICleanable;

public class JanitorThread
extends Thread {
    public static final long DEFAULT_INTERVAL_MILLIS = 30720L;
    private long interval = 30720L;
    private boolean lockInterval = false;
    private static JanitorThread shared = null;
    private List references = new ArrayList();

    public JanitorThread() {
        this((String)null);
    }

    public JanitorThread(String name) {
        super(name);
        this.setDaemon(true);
        this.setPriority(1);
    }

    public static synchronized JanitorThread getSharedJanitorThread() {
        if (shared == null) {
            shared = new JanitorThread("Shared-JanitorThread");
            JanitorThread.shared.lockInterval = true;
            shared.start();
        }
        return shared;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long value) {
        if (this.lockInterval) {
            throw new IllegalStateException(Tapestry.getString("JanitorThread.interval-locked"));
        }
        if (value < 1L) {
            throw new IllegalArgumentException(Tapestry.getString("JanitorThread.illegal-interval"));
        }
        this.interval = value;
        this.interrupt();
    }

    public void add(ICleanable cleanable) {
        WeakReference<ICleanable> reference = new WeakReference<ICleanable>(cleanable);
        List list = this.references;
        synchronized (list) {
            this.references.add(reference);
        }
    }

    protected void sweep() {
        List list = this.references;
        synchronized (list) {
            Iterator i = this.references.iterator();
            while (i.hasNext()) {
                WeakReference ref = (WeakReference)i.next();
                ICleanable cleanable = (ICleanable)ref.get();
                if (cleanable == null) {
                    i.remove();
                    continue;
                }
                cleanable.executeCleanup();
            }
        }
    }

    protected void waitForNextPass() {
        try {
            Thread.sleep(this.interval);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void run() {
        while (true) {
            this.waitForNextPass();
            this.sweep();
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("JanitorThread@");
        buffer.append(Integer.toHexString(this.hashCode()));
        buffer.append("[interval=");
        buffer.append(this.interval);
        buffer.append(" count=");
        List list = this.references;
        synchronized (list) {
            buffer.append(this.references.size());
        }
        buffer.append(']');
        return buffer.toString();
    }
}

